/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.serialization;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.KafkaException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.SerializationException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.serialization.Deserializer;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.serialization.DoubleDeserializer;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.serialization.FloatDeserializer;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.serialization.IntegerDeserializer;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.serialization.LongDeserializer;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.serialization.Serde;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.serialization.Serdes;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.serialization.ShortDeserializer;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.serialization.UUIDDeserializer;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListDeserializer<Inner>
implements Deserializer<List<Inner>> {
    final Logger log = LoggerFactory.getLogger(ListDeserializer.class);
    private static final Map<Class<? extends Deserializer<?>>, Integer> FIXED_LENGTH_DESERIALIZERS = Utils.mkMap(Utils.mkEntry(ShortDeserializer.class, 2), Utils.mkEntry(IntegerDeserializer.class, 4), Utils.mkEntry(FloatDeserializer.class, 4), Utils.mkEntry(LongDeserializer.class, 8), Utils.mkEntry(DoubleDeserializer.class, 8), Utils.mkEntry(UUIDDeserializer.class, 36));
    private Deserializer<Inner> inner;
    private Class<?> listClass;
    private Integer primitiveSize;

    public ListDeserializer() {
    }

    public <L extends List<Inner>> ListDeserializer(Class<L> listClass, Deserializer<Inner> inner) {
        if (listClass == null || inner == null) {
            this.log.error("Could not construct ListDeserializer as not all required parameters were present -- listClass: {}, inner: {}", listClass, inner);
            throw new IllegalArgumentException("ListDeserializer requires both \"listClass\" and \"innerDeserializer\" parameters to be provided during initialization");
        }
        this.listClass = listClass;
        this.inner = inner;
        this.primitiveSize = FIXED_LENGTH_DESERIALIZERS.get(inner.getClass());
    }

    public Deserializer<Inner> innerDeserializer() {
        return this.inner;
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        if (this.listClass != null || this.inner != null) {
            this.log.error("Could not configure ListDeserializer as some parameters were already set -- listClass: {}, inner: {}", this.listClass, this.inner);
            throw new ConfigException("List deserializer was already initialized using a non-default constructor");
        }
        this.configureListClass(configs, isKey);
        this.configureInnerSerde(configs, isKey);
    }

    private void configureListClass(Map<String, ?> configs, boolean isKey) {
        block5: {
            String listTypePropertyName = isKey ? "default.list.key.serde.type" : "default.list.value.serde.type";
            Object listClassOrName = configs.get(listTypePropertyName);
            if (listClassOrName == null) {
                throw new ConfigException("Not able to determine the list class because it was neither passed via the constructor nor set in the config.");
            }
            try {
                if (listClassOrName instanceof String) {
                    this.listClass = Utils.loadClass((String)listClassOrName, Object.class);
                    break block5;
                }
                if (listClassOrName instanceof Class) {
                    this.listClass = (Class)listClassOrName;
                    break block5;
                }
                throw new KafkaException("Could not determine the list class instance using \"" + listTypePropertyName + "\" property.");
            }
            catch (ClassNotFoundException e2) {
                throw new ConfigException(listTypePropertyName, listClassOrName, "Deserializer's list class \"" + listClassOrName + "\" could not be found.");
            }
        }
    }

    private void configureInnerSerde(Map<String, ?> configs, boolean isKey) {
        String innerSerdePropertyName = isKey ? "default.list.key.serde.inner" : "default.list.value.serde.inner";
        Object innerSerdeClassOrName = configs.get(innerSerdePropertyName);
        if (innerSerdeClassOrName == null) {
            throw new ConfigException("Not able to determine the inner serde class because it was neither passed via the constructor nor set in the config.");
        }
        try {
            if (innerSerdeClassOrName instanceof String) {
                this.inner = Utils.newInstance((String)innerSerdeClassOrName, Serde.class).deserializer();
            } else if (innerSerdeClassOrName instanceof Class) {
                this.inner = ((Serde)Utils.newInstance((Class)innerSerdeClassOrName)).deserializer();
            } else {
                throw new KafkaException("Could not determine the inner serde class instance using \"" + innerSerdePropertyName + "\" property.");
            }
            this.inner.configure(configs, isKey);
            this.primitiveSize = FIXED_LENGTH_DESERIALIZERS.get(this.inner.getClass());
        }
        catch (ClassNotFoundException e2) {
            throw new ConfigException(innerSerdePropertyName, innerSerdeClassOrName, "Deserializer's inner serde class \"" + innerSerdeClassOrName + "\" could not be found.");
        }
    }

    private List<Inner> createListInstance(int listSize) {
        try {
            Constructor<?> listConstructor = this.listClass.getConstructor(Integer.TYPE);
            return (List)listConstructor.newInstance(listSize);
        }
        catch (NoSuchMethodException e2) {
            try {
                Constructor<?> listConstructor = this.listClass.getConstructor(new Class[0]);
                return (List)listConstructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e3) {
                this.log.error("Failed to construct list due to ", (Throwable)e3);
                throw new KafkaException("Could not construct a list instance of \"" + this.listClass.getCanonicalName() + "\"", e3);
            }
        }
    }

    private Serdes.ListSerde.SerializationStrategy parseSerializationStrategyFlag(int serializationStrategyFlag) throws IOException {
        if (serializationStrategyFlag < 0 || serializationStrategyFlag >= Serdes.ListSerde.SerializationStrategy.VALUES.length) {
            throw new SerializationException("Invalid serialization strategy flag value");
        }
        return Serdes.ListSerde.SerializationStrategy.VALUES[serializationStrategyFlag];
    }

    private List<Integer> deserializeNullIndexList(DataInputStream dis) throws IOException {
        int nullIndexListSize;
        ArrayList<Integer> nullIndexList = new ArrayList<Integer>(nullIndexListSize);
        for (nullIndexListSize = dis.readInt(); nullIndexListSize != 0; --nullIndexListSize) {
            nullIndexList.add(dis.readInt());
        }
        return nullIndexList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Inner> deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        try (DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));){
            Serdes.ListSerde.SerializationStrategy serStrategy = this.parseSerializationStrategyFlag(dis.readByte());
            List<Integer> nullIndexList = null;
            if (serStrategy == Serdes.ListSerde.SerializationStrategy.CONSTANT_SIZE) {
                nullIndexList = this.deserializeNullIndexList(dis);
            }
            int size = dis.readInt();
            List<Inner> deserializedList = this.createListInstance(size);
            for (int i2 = 0; i2 < size; ++i2) {
                int entrySize;
                int n2 = entrySize = serStrategy == Serdes.ListSerde.SerializationStrategy.CONSTANT_SIZE ? this.primitiveSize.intValue() : dis.readInt();
                if (entrySize == -1 || nullIndexList != null && nullIndexList.contains(i2)) {
                    deserializedList.add(null);
                    continue;
                }
                byte[] payload = new byte[entrySize];
                if (dis.read(payload) == -1) {
                    this.log.error("Ran out of bytes in serialized list");
                    this.log.trace("Deserialized list so far: {}", deserializedList);
                    throw new SerializationException("End of the stream was reached prematurely");
                }
                deserializedList.add(this.inner.deserialize(topic, payload));
            }
            List<Inner> list = deserializedList;
            return list;
        }
        catch (IOException e2) {
            throw new KafkaException("Unable to deserialize into a List", e2);
        }
    }

    @Override
    public void close() {
        if (this.inner != null) {
            this.inner.close();
        }
    }
}

