/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class ByteUtils {
    public static final ByteBuffer EMPTY_BUF = ByteBuffer.wrap(new byte[0]);

    private ByteUtils() {
    }

    public static long readUnsignedInt(ByteBuffer buffer) {
        return (long)buffer.getInt() & 0xFFFFFFFFL;
    }

    public static long readUnsignedInt(ByteBuffer buffer, int index) {
        return (long)buffer.getInt(index) & 0xFFFFFFFFL;
    }

    public static int readUnsignedIntLE(InputStream in) throws IOException {
        return in.read() | in.read() << 8 | in.read() << 16 | in.read() << 24;
    }

    public static int readUnsignedIntLE(byte[] buffer, int offset) {
        return buffer[offset] << 0 & 0xFF | (buffer[offset + 1] & 0xFF) << 8 | (buffer[offset + 2] & 0xFF) << 16 | (buffer[offset + 3] & 0xFF) << 24;
    }

    public static void writeUnsignedInt(ByteBuffer buffer, int index, long value) {
        buffer.putInt(index, (int)(value & 0xFFFFFFFFL));
    }

    public static void writeUnsignedInt(ByteBuffer buffer, long value) {
        buffer.putInt((int)(value & 0xFFFFFFFFL));
    }

    public static void writeUnsignedIntLE(OutputStream out, int value) throws IOException {
        out.write(value);
        out.write(value >>> 8);
        out.write(value >>> 16);
        out.write(value >>> 24);
    }

    public static void writeUnsignedIntLE(byte[] buffer, int offset, int value) {
        buffer[offset] = (byte)value;
        buffer[offset + 1] = (byte)(value >>> 8);
        buffer[offset + 2] = (byte)(value >>> 16);
        buffer[offset + 3] = (byte)(value >>> 24);
    }

    public static int readUnsignedVarint(ByteBuffer buffer) {
        byte b2;
        int value = 0;
        int i2 = 0;
        while (((b2 = buffer.get()) & 0x80) != 0) {
            value |= (b2 & 0x7F) << i2;
            if ((i2 += 7) <= 28) continue;
            throw ByteUtils.illegalVarintException(value);
        }
        return value |= b2 << i2;
    }

    public static int readUnsignedVarint(DataInput in) throws IOException {
        byte b2;
        int value = 0;
        int i2 = 0;
        while (((b2 = in.readByte()) & 0x80) != 0) {
            value |= (b2 & 0x7F) << i2;
            if ((i2 += 7) <= 28) continue;
            throw ByteUtils.illegalVarintException(value);
        }
        return value |= b2 << i2;
    }

    public static int readVarint(ByteBuffer buffer) {
        int value = ByteUtils.readUnsignedVarint(buffer);
        return value >>> 1 ^ -(value & 1);
    }

    public static int readVarint(DataInput in) throws IOException {
        int value = ByteUtils.readUnsignedVarint(in);
        return value >>> 1 ^ -(value & 1);
    }

    public static long readVarlong(DataInput in) throws IOException {
        long b2;
        long value = 0L;
        int i2 = 0;
        while (((b2 = (long)in.readByte()) & 0x80L) != 0L) {
            value |= (b2 & 0x7FL) << i2;
            if ((i2 += 7) <= 63) continue;
            throw ByteUtils.illegalVarlongException(value);
        }
        return (value |= b2 << i2) >>> 1 ^ -(value & 1L);
    }

    public static long readVarlong(ByteBuffer buffer) {
        long b2;
        long value = 0L;
        int i2 = 0;
        while (((b2 = (long)buffer.get()) & 0x80L) != 0L) {
            value |= (b2 & 0x7FL) << i2;
            if ((i2 += 7) <= 63) continue;
            throw ByteUtils.illegalVarlongException(value);
        }
        return (value |= b2 << i2) >>> 1 ^ -(value & 1L);
    }

    public static double readDouble(DataInput in) throws IOException {
        return in.readDouble();
    }

    public static double readDouble(ByteBuffer buffer) {
        return buffer.getDouble();
    }

    public static void writeUnsignedVarint(int value, ByteBuffer buffer) {
        while ((long)(value & 0xFFFFFF80) != 0L) {
            byte b2 = (byte)(value & 0x7F | 0x80);
            buffer.put(b2);
            value >>>= 7;
        }
        buffer.put((byte)value);
    }

    public static void writeUnsignedVarint(int value, DataOutput out) throws IOException {
        while ((long)(value & 0xFFFFFF80) != 0L) {
            byte b2 = (byte)(value & 0x7F | 0x80);
            out.writeByte(b2);
            value >>>= 7;
        }
        out.writeByte((byte)value);
    }

    public static void writeVarint(int value, DataOutput out) throws IOException {
        ByteUtils.writeUnsignedVarint(value << 1 ^ value >> 31, out);
    }

    public static void writeVarint(int value, ByteBuffer buffer) {
        ByteUtils.writeUnsignedVarint(value << 1 ^ value >> 31, buffer);
    }

    public static void writeVarlong(long value, DataOutput out) throws IOException {
        long v2 = value << 1 ^ value >> 63;
        while ((v2 & 0xFFFFFFFFFFFFFF80L) != 0L) {
            out.writeByte((int)v2 & 0x7F | 0x80);
            v2 >>>= 7;
        }
        out.writeByte((byte)v2);
    }

    public static void writeVarlong(long value, ByteBuffer buffer) {
        long v2 = value << 1 ^ value >> 63;
        while ((v2 & 0xFFFFFFFFFFFFFF80L) != 0L) {
            byte b2 = (byte)(v2 & 0x7FL | 0x80L);
            buffer.put(b2);
            v2 >>>= 7;
        }
        buffer.put((byte)v2);
    }

    public static void writeDouble(double value, DataOutput out) throws IOException {
        out.writeDouble(value);
    }

    public static void writeDouble(double value, ByteBuffer buffer) {
        buffer.putDouble(value);
    }

    public static int sizeOfUnsignedVarint(int value) {
        int leadingZeros = Integer.numberOfLeadingZeros(value);
        int leadingZerosBelow38DividedBy7 = (38 - leadingZeros) * 74899 >>> 19;
        return leadingZerosBelow38DividedBy7 + (leadingZeros >>> 5);
    }

    public static int sizeOfVarint(int value) {
        return ByteUtils.sizeOfUnsignedVarint(value << 1 ^ value >> 31);
    }

    public static int sizeOfVarlong(long value) {
        long v2 = value << 1 ^ value >> 63;
        int leadingZeros = Long.numberOfLeadingZeros(v2);
        int leadingZerosBelow70DividedBy7 = (70 - leadingZeros) * 74899 >>> 19;
        return leadingZerosBelow70DividedBy7 + (leadingZeros >>> 6);
    }

    private static IllegalArgumentException illegalVarintException(int value) {
        throw new IllegalArgumentException("Varint is too long, the most significant bit in the 5th byte is set, converted value: " + Integer.toHexString(value));
    }

    private static IllegalArgumentException illegalVarlongException(long value) {
        throw new IllegalArgumentException("Varlong is too long, most significant bit in the 10th byte is set, converted value: " + Long.toHexString(value));
    }
}

