/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.health;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Utils;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.health.ConnectorState;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.health.ConnectorType;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.health.TaskState;
import java.util.Map;
import java.util.Objects;

public class ConnectorHealth {
    private final String name;
    private final ConnectorState connectorState;
    private final Map<Integer, TaskState> tasks;
    private final ConnectorType type;

    public ConnectorHealth(String name, ConnectorState connectorState, Map<Integer, TaskState> tasks, ConnectorType type) {
        if (Utils.isBlank(name)) {
            throw new IllegalArgumentException("Connector name is required");
        }
        Objects.requireNonNull(connectorState, "connectorState can't be null");
        Objects.requireNonNull(tasks, "tasks can't be null");
        Objects.requireNonNull(type, "type can't be null");
        this.name = name;
        this.connectorState = connectorState;
        this.tasks = tasks;
        this.type = type;
    }

    public String name() {
        return this.name;
    }

    public ConnectorState connectorState() {
        return this.connectorState;
    }

    public Map<Integer, TaskState> tasksState() {
        return this.tasks;
    }

    public ConnectorType type() {
        return this.type;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        ConnectorHealth that = (ConnectorHealth)o2;
        return this.name.equals(that.name) && this.connectorState.equals(that.connectorState) && this.tasks.equals(that.tasks) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.connectorState, this.tasks, this.type});
    }

    public String toString() {
        return "ConnectorHealth{name='" + this.name + '\'' + ", connectorState=" + this.connectorState + ", tasks=" + this.tasks + ", type=" + (Object)((Object)this.type) + '}';
    }
}

