/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.json;

import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.JsonNode;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.SerializationException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.serialization.Deserializer;
import java.util.Collections;
import java.util.Set;

public class JsonDeserializer
implements Deserializer<JsonNode> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public JsonDeserializer() {
        this(Collections.emptySet(), JsonNodeFactory.withExactBigDecimals(true));
    }

    JsonDeserializer(Set<DeserializationFeature> deserializationFeatures, JsonNodeFactory jsonNodeFactory) {
        deserializationFeatures.forEach(this.objectMapper::enable);
        this.objectMapper.setNodeFactory(jsonNodeFactory);
    }

    @Override
    public JsonNode deserialize(String topic, byte[] bytes) {
        JsonNode data;
        if (bytes == null) {
            return null;
        }
        try {
            data = this.objectMapper.readTree(bytes);
        }
        catch (Exception e2) {
            throw new SerializationException(e2);
        }
        return data;
    }
}

