/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Exit;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.Herder;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.rest.RestServer;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connect {
    private static final Logger log = LoggerFactory.getLogger(Connect.class);
    private final Herder herder;
    private final RestServer rest;
    private final CountDownLatch startLatch = new CountDownLatch(1);
    private final CountDownLatch stopLatch = new CountDownLatch(1);
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final ShutdownHook shutdownHook;

    public Connect(Herder herder, RestServer rest) {
        log.debug("Kafka Connect instance created");
        this.herder = herder;
        this.rest = rest;
        this.shutdownHook = new ShutdownHook();
    }

    public void start() {
        try {
            log.info("Kafka Connect starting");
            Exit.addShutdownHook("connect-shutdown-hook", this.shutdownHook);
            this.herder.start();
            this.rest.initializeResources(this.herder);
            log.info("Kafka Connect started");
        }
        finally {
            this.startLatch.countDown();
        }
    }

    public void stop() {
        try {
            boolean wasShuttingDown = this.shutdown.getAndSet(true);
            if (!wasShuttingDown) {
                log.info("Kafka Connect stopping");
                this.rest.stop();
                this.herder.stop();
                log.info("Kafka Connect stopped");
            }
        }
        finally {
            this.stopLatch.countDown();
        }
    }

    public void awaitStop() {
        try {
            this.stopLatch.await();
        }
        catch (InterruptedException e2) {
            log.error("Interrupted waiting for Kafka Connect to shutdown");
        }
    }

    public boolean isRunning() {
        return this.herder.isRunning();
    }

    public URI restUrl() {
        return this.rest.serverUrl();
    }

    public URI adminUrl() {
        return this.rest.adminUrl();
    }

    private class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        @Override
        public void run() {
            try {
                Connect.this.startLatch.await();
                Connect.this.stop();
            }
            catch (InterruptedException e2) {
                log.error("Interrupted in shutdown hook while waiting for Kafka Connect startup to finish");
            }
        }
    }
}

