/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.rest;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.ConnectException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.rest.errors.BadRequestException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.ws.rs.core.HttpHeaders;
import org.eclipse.jetty.client.api.Request;

public class InternalRequestSignature {
    public static final String SIGNATURE_HEADER = "X-Connect-Authorization";
    public static final String SIGNATURE_ALGORITHM_HEADER = "X-Connect-Request-Signature-Algorithm";
    private final byte[] requestBody;
    private final Mac mac;
    private final byte[] requestSignature;

    public static void addToRequest(SecretKey key, byte[] requestBody, String signatureAlgorithm, Request request) {
        Mac mac;
        try {
            mac = InternalRequestSignature.mac(signatureAlgorithm);
        }
        catch (NoSuchAlgorithmException e2) {
            throw new ConnectException(e2);
        }
        byte[] requestSignature = InternalRequestSignature.sign(mac, key, requestBody);
        request.header(SIGNATURE_HEADER, Base64.getEncoder().encodeToString(requestSignature)).header(SIGNATURE_ALGORITHM_HEADER, signatureAlgorithm);
    }

    public static InternalRequestSignature fromHeaders(byte[] requestBody, HttpHeaders headers) {
        byte[] decodedSignature;
        Mac mac;
        if (headers == null) {
            return null;
        }
        String signatureAlgorithm = headers.getHeaderString(SIGNATURE_ALGORITHM_HEADER);
        String encodedSignature = headers.getHeaderString(SIGNATURE_HEADER);
        if (signatureAlgorithm == null || encodedSignature == null) {
            return null;
        }
        try {
            mac = InternalRequestSignature.mac(signatureAlgorithm);
        }
        catch (NoSuchAlgorithmException e2) {
            throw new BadRequestException(e2.getMessage());
        }
        try {
            decodedSignature = Base64.getDecoder().decode(encodedSignature);
        }
        catch (IllegalArgumentException e3) {
            throw new BadRequestException(e3.getMessage());
        }
        return new InternalRequestSignature(requestBody, mac, decodedSignature);
    }

    public InternalRequestSignature(byte[] requestBody, Mac mac, byte[] requestSignature) {
        this.requestBody = requestBody;
        this.mac = mac;
        this.requestSignature = requestSignature;
    }

    public String keyAlgorithm() {
        return this.mac.getAlgorithm();
    }

    public boolean isValid(SecretKey key) {
        return MessageDigest.isEqual(InternalRequestSignature.sign(this.mac, key, this.requestBody), this.requestSignature);
    }

    private static Mac mac(String signatureAlgorithm) throws NoSuchAlgorithmException {
        return Mac.getInstance(signatureAlgorithm);
    }

    private static byte[] sign(Mac mac, SecretKey key, byte[] requestBody) {
        try {
            mac.init(key);
        }
        catch (InvalidKeyException e2) {
            throw new ConnectException(e2);
        }
        return mac.doFinal(requestBody);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        InternalRequestSignature that = (InternalRequestSignature)o2;
        return Arrays.equals(this.requestBody, that.requestBody) && this.mac.getAlgorithm().equals(that.mac.getAlgorithm()) && this.mac.getMacLength() == that.mac.getMacLength() && this.mac.getProvider().equals(that.mac.getProvider()) && Arrays.equals(this.requestSignature, that.requestSignature);
    }

    public int hashCode() {
        int result = Objects.hash(this.mac);
        result = 31 * result + Arrays.hashCode(this.requestBody);
        result = 31 * result + Arrays.hashCode(this.requestSignature);
        return result;
    }
}

