/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.rest.resources;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.Herder;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.PredicatedTransformation;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.isolation.PluginDesc;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.isolation.PluginType;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.rest.entities.ConfigInfos;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.rest.entities.ConfigKeyInfo;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.rest.entities.PluginInfo;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.rest.errors.ConnectRestException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.sink.SinkConnector;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceConnector;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.tools.MockSinkConnector;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.tools.MockSourceConnector;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.tools.SchemaSourceConnector;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.tools.VerifiableSinkConnector;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.tools.VerifiableSourceConnector;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.transforms.Transformation;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.util.FutureCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/connector-plugins")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ConnectorPluginsResource {
    private static final String ALIAS_SUFFIX = "Connector";
    private final Herder herder;
    private final List<PluginInfo> connectorPlugins;
    static final List<Class<? extends SinkConnector>> SINK_CONNECTOR_EXCLUDES = Arrays.asList(VerifiableSinkConnector.class, MockSinkConnector.class);
    static final List<Class<? extends SourceConnector>> SOURCE_CONNECTOR_EXCLUDES = Arrays.asList(VerifiableSourceConnector.class, MockSourceConnector.class, SchemaSourceConnector.class);
    static final List<Class<? extends Transformation<?>>> TRANSFORM_EXCLUDES = Collections.singletonList(PredicatedTransformation.class);

    public ConnectorPluginsResource(Herder herder) {
        this.herder = herder;
        this.connectorPlugins = new ArrayList<PluginInfo>();
        this.addConnectorPlugins(herder.plugins().sinkConnectors(), SINK_CONNECTOR_EXCLUDES);
        this.addConnectorPlugins(herder.plugins().sourceConnectors(), SOURCE_CONNECTOR_EXCLUDES);
        this.addConnectorPlugins(herder.plugins().transformations(), TRANSFORM_EXCLUDES);
        this.addConnectorPlugins(herder.plugins().predicates(), Collections.emptySet());
        this.addConnectorPlugins(herder.plugins().converters(), Collections.emptySet());
        this.addConnectorPlugins(herder.plugins().headerConverters(), Collections.emptySet());
    }

    private <T> void addConnectorPlugins(Collection<PluginDesc<T>> plugins, Collection<Class<? extends T>> excludes) {
        plugins.stream().filter(p2 -> !excludes.contains(p2.pluginClass())).map(PluginInfo::new).forEach(this.connectorPlugins::add);
    }

    @PUT
    @Path(value="/{connectorType}/config/validate")
    public ConfigInfos validateConfigs(@PathParam(value="connectorType") String connType, Map<String, String> connectorConfig) throws Throwable {
        String includedConnType = connectorConfig.get("connector.class");
        if (includedConnType != null && !this.normalizedPluginName(includedConnType).endsWith(this.normalizedPluginName(connType))) {
            throw new BadRequestException("Included connector type " + includedConnType + " does not match request type " + connType);
        }
        FutureCallback<ConfigInfos> validationCallback = new FutureCallback<ConfigInfos>();
        this.herder.validateConnectorConfig(connectorConfig, validationCallback, false);
        try {
            return (ConfigInfos)validationCallback.get(90000L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e2) {
            throw new ConnectRestException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Request timed out");
        }
        catch (InterruptedException e3) {
            throw new ConnectRestException(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Request interrupted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/")
    public List<PluginInfo> listConnectorPlugins(@DefaultValue(value="true") @QueryParam(value="connectorsOnly") boolean connectorsOnly) {
        ConnectorPluginsResource connectorPluginsResource = this;
        synchronized (connectorPluginsResource) {
            if (connectorsOnly) {
                return Collections.unmodifiableList(this.connectorPlugins.stream().filter(p2 -> PluginType.SINK.toString().equals(p2.type()) || PluginType.SOURCE.toString().equals(p2.type())).collect(Collectors.toList()));
            }
            return Collections.unmodifiableList(this.connectorPlugins);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{name}/config")
    public List<ConfigKeyInfo> getConnectorConfigDef(@PathParam(value="name") String pluginName) {
        ConnectorPluginsResource connectorPluginsResource = this;
        synchronized (connectorPluginsResource) {
            return this.herder.connectorPluginConfig(pluginName);
        }
    }

    private String normalizedPluginName(String pluginName) {
        return pluginName.endsWith(ALIAS_SUFFIX) && pluginName.length() > ALIAS_SUFFIX.length() ? pluginName.substring(0, pluginName.length() - ALIAS_SUFFIX.length()) : pluginName;
    }
}

