/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.storage;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigDef;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.errors.SerializationException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.serialization.StringDeserializer;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.serialization.StringSerializer;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.SchemaAndValue;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.DataException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.storage.Converter;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.storage.ConverterType;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.storage.HeaderConverter;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.storage.StringConverterConfig;
import java.util.HashMap;
import java.util.Map;

public class StringConverter
implements Converter,
HeaderConverter {
    private final StringSerializer serializer = new StringSerializer();
    private final StringDeserializer deserializer = new StringDeserializer();

    @Override
    public ConfigDef config() {
        return StringConverterConfig.configDef();
    }

    @Override
    public void configure(Map<String, ?> configs) {
        StringConverterConfig conf = new StringConverterConfig(configs);
        String encoding = conf.encoding();
        HashMap serializerConfigs = new HashMap(configs);
        HashMap deserializerConfigs = new HashMap(configs);
        serializerConfigs.put("serializer.encoding", encoding);
        deserializerConfigs.put("deserializer.encoding", encoding);
        boolean isKey = conf.type() == ConverterType.KEY;
        this.serializer.configure(serializerConfigs, isKey);
        this.deserializer.configure(deserializerConfigs, isKey);
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        HashMap conf = new HashMap(configs);
        conf.put("converter.type", isKey ? ConverterType.KEY.getName() : ConverterType.VALUE.getName());
        this.configure(conf);
    }

    @Override
    public byte[] fromConnectData(String topic, Schema schema, Object value) {
        try {
            return this.serializer.serialize(topic, value == null ? null : value.toString());
        }
        catch (SerializationException e2) {
            throw new DataException("Failed to serialize to a string: ", e2);
        }
    }

    @Override
    public SchemaAndValue toConnectData(String topic, byte[] value) {
        try {
            return new SchemaAndValue(Schema.OPTIONAL_STRING_SCHEMA, this.deserializer.deserialize(topic, value));
        }
        catch (SerializationException e2) {
            throw new DataException("Failed to deserialize string: ", e2);
        }
    }

    @Override
    public byte[] fromConnectHeader(String topic, String headerKey, Schema schema, Object value) {
        return this.fromConnectData(topic, schema, value);
    }

    @Override
    public SchemaAndValue toConnectHeader(String topic, String headerKey, byte[] value) {
        return this.toConnectData(topic, value);
    }

    @Override
    public void close() {
    }
}

