/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.tools;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigDef;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.isolation.Plugins;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.transforms.predicates.Predicate;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class PredicateDoc {
    private static final List<DocInfo> PREDICATES;

    private static void printPredicateHtml(PrintStream out, DocInfo docInfo) {
        out.println("<div id=\"" + docInfo.predicateName + "\">");
        out.print("<h5>");
        out.print("<a href=\"#" + docInfo.predicateName + "\">" + docInfo.predicateName + "</a>");
        out.println("</h5>");
        out.println(docInfo.overview);
        out.println("<p/>");
        out.println(docInfo.configDef.toHtml(6, key -> docInfo.predicateName + "_" + key));
        out.println("</div>");
    }

    private static void printHtml(PrintStream out) {
        for (DocInfo docInfo : PREDICATES) {
            PredicateDoc.printPredicateHtml(out, docInfo);
        }
    }

    public static void main(String ... args) {
        PredicateDoc.printHtml(System.out);
    }

    static {
        List collect = new Plugins(Collections.emptyMap()).predicates().stream().map(p2 -> {
            try {
                String overviewDoc = (String)p2.pluginClass().getDeclaredField("OVERVIEW_DOC").get(null);
                ConfigDef configDef = (ConfigDef)p2.pluginClass().getDeclaredField("CONFIG_DEF").get(null);
                return new DocInfo(p2.pluginClass(), overviewDoc, configDef);
            }
            catch (ReflectiveOperationException e2) {
                throw new RuntimeException("Predicate class " + p2.pluginClass().getName() + " lacks either a `public static final String OVERVIEW_DOC` or `public static final ConfigDef CONFIG_DEF`");
            }
        }).sorted(Comparator.comparing(docInfo -> docInfo.predicateName)).collect(Collectors.toList());
        PREDICATES = collect;
    }

    private static final class DocInfo {
        final String predicateName;
        final String overview;
        final ConfigDef configDef;

        private <P extends Predicate<?>> DocInfo(Class<P> predicateClass, String overview, ConfigDef configDef) {
            this.predicateName = predicateClass.getName();
            this.overview = overview;
            this.configDef = configDef;
        }
    }
}

