/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.transforms;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.cache.Cache;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.cache.LRUCache;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.cache.SynchronizedCache;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigDef;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Utils;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.connector.ConnectRecord;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Date;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Field;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.SchemaBuilder;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Time;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Timestamp;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.ConnectException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.DataException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.transforms.Transformation;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.transforms.util.Requirements;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.transforms.util.SchemaUtil;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.transforms.util.SimpleConfig;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public abstract class TimestampConverter<R extends ConnectRecord<R>>
implements Transformation<R> {
    public static final String OVERVIEW_DOC = "Convert timestamps between different formats such as Unix epoch, strings, and Connect Date/Timestamp types.Applies to individual fields or to the entire value.<p/>Use the concrete transformation type designed for the record key (<code>" + Key.class.getName() + "</code>) or value (<code>" + Value.class.getName() + "</code>).";
    public static final String FIELD_CONFIG = "field";
    private static final String FIELD_DEFAULT = "";
    public static final String TARGET_TYPE_CONFIG = "target.type";
    public static final String FORMAT_CONFIG = "format";
    private static final String FORMAT_DEFAULT = "";
    public static final String UNIX_PRECISION_CONFIG = "unix.precision";
    private static final String UNIX_PRECISION_DEFAULT = "milliseconds";
    private static final String PURPOSE = "converting timestamp formats";
    private static final String TYPE_STRING = "string";
    private static final String TYPE_UNIX = "unix";
    private static final String TYPE_DATE = "Date";
    private static final String TYPE_TIME = "Time";
    private static final String TYPE_TIMESTAMP = "Timestamp";
    private static final String UNIX_PRECISION_MILLIS = "milliseconds";
    private static final String UNIX_PRECISION_MICROS = "microseconds";
    private static final String UNIX_PRECISION_NANOS = "nanoseconds";
    private static final String UNIX_PRECISION_SECONDS = "seconds";
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    public static final Schema OPTIONAL_DATE_SCHEMA = Date.builder().optional().schema();
    public static final Schema OPTIONAL_TIMESTAMP_SCHEMA = Timestamp.builder().optional().schema();
    public static final Schema OPTIONAL_TIME_SCHEMA = Time.builder().optional().schema();
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("field", ConfigDef.Type.STRING, "", ConfigDef.Importance.HIGH, "The field containing the timestamp, or empty if the entire value is a timestamp").define("target.type", ConfigDef.Type.STRING, ConfigDef.NO_DEFAULT_VALUE, ConfigDef.ValidString.in("string", "unix", "Date", "Time", "Timestamp"), ConfigDef.Importance.HIGH, "The desired timestamp representation: string, unix, Date, Time, or Timestamp").define("format", ConfigDef.Type.STRING, "", ConfigDef.Importance.MEDIUM, "A SimpleDateFormat-compatible format for the timestamp. Used to generate the output when type=string or used to parse the input if the input is a string.").define("unix.precision", ConfigDef.Type.STRING, "milliseconds", ConfigDef.ValidString.in("nanoseconds", "microseconds", "milliseconds", "seconds"), ConfigDef.Importance.LOW, "The desired Unix precision for the timestamp: seconds, milliseconds, microseconds, or nanoseconds. Used to generate the output when type=unix or used to parse the input if the input is a Long.Note: This SMT will cause precision loss during conversions from, and to, values with sub-millisecond components.");
    private static final Map<String, TimestampTranslator> TRANSLATORS = new HashMap<String, TimestampTranslator>();
    private Config config;
    private Cache<Schema, Schema> schemaUpdateCache;

    @Override
    public void configure(Map<String, ?> configs) {
        SimpleConfig simpleConfig = new SimpleConfig(CONFIG_DEF, configs);
        String field = simpleConfig.getString(FIELD_CONFIG);
        String type = simpleConfig.getString(TARGET_TYPE_CONFIG);
        String formatPattern = simpleConfig.getString(FORMAT_CONFIG);
        String unixPrecision = simpleConfig.getString(UNIX_PRECISION_CONFIG);
        this.schemaUpdateCache = new SynchronizedCache<Schema, Schema>(new LRUCache(16));
        if (type.equals(TYPE_STRING) && Utils.isBlank(formatPattern)) {
            throw new ConfigException("TimestampConverter requires format option to be specified when using string timestamps");
        }
        SimpleDateFormat format = null;
        if (!Utils.isBlank(formatPattern)) {
            try {
                format = new SimpleDateFormat(formatPattern);
                format.setTimeZone(UTC);
            }
            catch (IllegalArgumentException e2) {
                throw new ConfigException("TimestampConverter requires a SimpleDateFormat-compatible pattern for string timestamps: " + formatPattern, (Object)e2);
            }
        }
        this.config = new Config(field, type, format, unixPrecision);
    }

    @Override
    public R apply(R record) {
        if (this.operatingSchema(record) == null) {
            return this.applySchemaless(record);
        }
        return this.applyWithSchema(record);
    }

    @Override
    public ConfigDef config() {
        return CONFIG_DEF;
    }

    @Override
    public void close() {
    }

    protected abstract Schema operatingSchema(R var1);

    protected abstract Object operatingValue(R var1);

    protected abstract R newRecord(R var1, Schema var2, Object var3);

    private R applyWithSchema(R record) {
        Schema schema = this.operatingSchema(record);
        if (this.config.field.isEmpty()) {
            Object value = this.operatingValue(record);
            Schema updatedSchema = TRANSLATORS.get(this.config.type).typeSchema(schema.isOptional());
            return this.newRecord(record, updatedSchema, this.convertTimestamp(value, this.timestampTypeFromSchema(schema)));
        }
        Struct value = Requirements.requireStructOrNull(this.operatingValue(record), PURPOSE);
        Schema updatedSchema = this.schemaUpdateCache.get(schema);
        if (updatedSchema == null) {
            SchemaBuilder builder = SchemaUtil.copySchemaBasics(schema, SchemaBuilder.struct());
            for (Field field : schema.fields()) {
                if (field.name().equals(this.config.field)) {
                    builder.field(field.name(), TRANSLATORS.get(this.config.type).typeSchema(field.schema().isOptional()));
                    continue;
                }
                builder.field(field.name(), field.schema());
            }
            if (schema.isOptional()) {
                builder.optional();
            }
            if (schema.defaultValue() != null) {
                Struct updatedDefaultValue = this.applyValueWithSchema((Struct)schema.defaultValue(), builder);
                builder.defaultValue(updatedDefaultValue);
            }
            updatedSchema = builder.build();
            this.schemaUpdateCache.put(schema, updatedSchema);
        }
        Struct updatedValue = this.applyValueWithSchema(value, updatedSchema);
        return this.newRecord(record, updatedSchema, updatedValue);
    }

    private Struct applyValueWithSchema(Struct value, Schema updatedSchema) {
        if (value == null) {
            return null;
        }
        Struct updatedValue = new Struct(updatedSchema);
        for (Field field : value.schema().fields()) {
            Object updatedFieldValue = field.name().equals(this.config.field) ? this.convertTimestamp(value.get(field), this.timestampTypeFromSchema(field.schema())) : value.get(field);
            updatedValue.put(field.name(), updatedFieldValue);
        }
        return updatedValue;
    }

    private R applySchemaless(R record) {
        Object rawValue = this.operatingValue(record);
        if (rawValue == null || this.config.field.isEmpty()) {
            return this.newRecord(record, null, this.convertTimestamp(rawValue));
        }
        Map<String, Object> value = Requirements.requireMap(rawValue, PURPOSE);
        HashMap<String, Object> updatedValue = new HashMap<String, Object>(value);
        updatedValue.put(this.config.field, this.convertTimestamp(value.get(this.config.field)));
        return this.newRecord(record, null, updatedValue);
    }

    private String timestampTypeFromSchema(Schema schema) {
        if ("com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Timestamp".equals(schema.name())) {
            return TYPE_TIMESTAMP;
        }
        if ("com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Date".equals(schema.name())) {
            return TYPE_DATE;
        }
        if ("com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Time".equals(schema.name())) {
            return TYPE_TIME;
        }
        if (schema.type().equals((Object)Schema.Type.STRING)) {
            return TYPE_STRING;
        }
        if (schema.type().equals((Object)Schema.Type.INT64)) {
            return TYPE_UNIX;
        }
        throw new ConnectException("Schema " + schema + " does not correspond to a known timestamp type format");
    }

    private String inferTimestampType(Object timestamp) {
        if (timestamp instanceof java.util.Date) {
            return TYPE_TIMESTAMP;
        }
        if (timestamp instanceof Long) {
            return TYPE_UNIX;
        }
        if (timestamp instanceof String) {
            return TYPE_STRING;
        }
        throw new DataException("TimestampConverter does not support " + timestamp.getClass() + " objects as timestamps");
    }

    private Object convertTimestamp(Object timestamp, String timestampFormat) {
        TimestampTranslator sourceTranslator;
        if (timestamp == null) {
            return null;
        }
        if (timestampFormat == null) {
            timestampFormat = this.inferTimestampType(timestamp);
        }
        if ((sourceTranslator = TRANSLATORS.get(timestampFormat)) == null) {
            throw new ConnectException("Unsupported timestamp type: " + timestampFormat);
        }
        java.util.Date rawTimestamp = sourceTranslator.toRaw(this.config, timestamp);
        TimestampTranslator targetTranslator = TRANSLATORS.get(this.config.type);
        if (targetTranslator == null) {
            throw new ConnectException("Unsupported timestamp type: " + this.config.type);
        }
        return targetTranslator.toType(this.config, rawTimestamp);
    }

    private Object convertTimestamp(Object timestamp) {
        return this.convertTimestamp(timestamp, null);
    }

    static {
        TRANSLATORS.put(TYPE_STRING, new TimestampTranslator(){

            @Override
            public java.util.Date toRaw(Config config, Object orig) {
                if (!(orig instanceof String)) {
                    throw new DataException("Expected string timestamp to be a String, but found " + orig.getClass());
                }
                try {
                    return config.format.parse((String)orig);
                }
                catch (ParseException e2) {
                    throw new DataException("Could not parse timestamp: value (" + orig + ") does not match pattern (" + config.format.toPattern() + ")", e2);
                }
            }

            @Override
            public Schema typeSchema(boolean isOptional) {
                return isOptional ? Schema.OPTIONAL_STRING_SCHEMA : Schema.STRING_SCHEMA;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String toType(Config config, java.util.Date orig) {
                SimpleDateFormat simpleDateFormat = config.format;
                synchronized (simpleDateFormat) {
                    return config.format.format(orig);
                }
            }
        });
        TRANSLATORS.put(TYPE_UNIX, new TimestampTranslator(){

            @Override
            public java.util.Date toRaw(Config config, Object orig) {
                if (!(orig instanceof Long)) {
                    throw new DataException("Expected Unix timestamp to be a Long, but found " + orig.getClass());
                }
                Long unixTime = (Long)orig;
                switch (config.unixPrecision) {
                    case "seconds": {
                        return Timestamp.toLogical(Timestamp.SCHEMA, TimeUnit.SECONDS.toMillis(unixTime));
                    }
                    case "microseconds": {
                        return Timestamp.toLogical(Timestamp.SCHEMA, TimeUnit.MICROSECONDS.toMillis(unixTime));
                    }
                    case "nanoseconds": {
                        return Timestamp.toLogical(Timestamp.SCHEMA, TimeUnit.NANOSECONDS.toMillis(unixTime));
                    }
                }
                return Timestamp.toLogical(Timestamp.SCHEMA, unixTime);
            }

            @Override
            public Schema typeSchema(boolean isOptional) {
                return isOptional ? Schema.OPTIONAL_INT64_SCHEMA : Schema.INT64_SCHEMA;
            }

            @Override
            public Long toType(Config config, java.util.Date orig) {
                Long unixTimeMillis = Timestamp.fromLogical(Timestamp.SCHEMA, orig);
                switch (config.unixPrecision) {
                    case "seconds": {
                        return TimeUnit.MILLISECONDS.toSeconds(unixTimeMillis);
                    }
                    case "microseconds": {
                        return TimeUnit.MILLISECONDS.toMicros(unixTimeMillis);
                    }
                    case "nanoseconds": {
                        return TimeUnit.MILLISECONDS.toNanos(unixTimeMillis);
                    }
                }
                return unixTimeMillis;
            }
        });
        TRANSLATORS.put(TYPE_DATE, new TimestampTranslator(){

            @Override
            public java.util.Date toRaw(Config config, Object orig) {
                if (!(orig instanceof java.util.Date)) {
                    throw new DataException("Expected Date to be a java.util.Date, but found " + orig.getClass());
                }
                return (java.util.Date)orig;
            }

            @Override
            public Schema typeSchema(boolean isOptional) {
                return isOptional ? OPTIONAL_DATE_SCHEMA : Date.SCHEMA;
            }

            @Override
            public java.util.Date toType(Config config, java.util.Date orig) {
                Calendar result = Calendar.getInstance(UTC);
                result.setTime(orig);
                result.set(11, 0);
                result.set(12, 0);
                result.set(13, 0);
                result.set(14, 0);
                return result.getTime();
            }
        });
        TRANSLATORS.put(TYPE_TIME, new TimestampTranslator(){

            @Override
            public java.util.Date toRaw(Config config, Object orig) {
                if (!(orig instanceof java.util.Date)) {
                    throw new DataException("Expected Time to be a java.util.Date, but found " + orig.getClass());
                }
                return (java.util.Date)orig;
            }

            @Override
            public Schema typeSchema(boolean isOptional) {
                return isOptional ? OPTIONAL_TIME_SCHEMA : Time.SCHEMA;
            }

            @Override
            public java.util.Date toType(Config config, java.util.Date orig) {
                Calendar origCalendar = Calendar.getInstance(UTC);
                origCalendar.setTime(orig);
                Calendar result = Calendar.getInstance(UTC);
                result.setTimeInMillis(0L);
                result.set(11, origCalendar.get(11));
                result.set(12, origCalendar.get(12));
                result.set(13, origCalendar.get(13));
                result.set(14, origCalendar.get(14));
                return result.getTime();
            }
        });
        TRANSLATORS.put(TYPE_TIMESTAMP, new TimestampTranslator(){

            @Override
            public java.util.Date toRaw(Config config, Object orig) {
                if (!(orig instanceof java.util.Date)) {
                    throw new DataException("Expected Timestamp to be a java.util.Date, but found " + orig.getClass());
                }
                return (java.util.Date)orig;
            }

            @Override
            public Schema typeSchema(boolean isOptional) {
                return isOptional ? OPTIONAL_TIMESTAMP_SCHEMA : Timestamp.SCHEMA;
            }

            @Override
            public java.util.Date toType(Config config, java.util.Date orig) {
                return orig;
            }
        });
    }

    public static class Value<R extends ConnectRecord<R>>
    extends TimestampConverter<R> {
        @Override
        protected Schema operatingSchema(R record) {
            return ((ConnectRecord)record).valueSchema();
        }

        @Override
        protected Object operatingValue(R record) {
            return ((ConnectRecord)record).value();
        }

        @Override
        protected R newRecord(R record, Schema updatedSchema, Object updatedValue) {
            return ((ConnectRecord)record).newRecord(((ConnectRecord)record).topic(), ((ConnectRecord)record).kafkaPartition(), ((ConnectRecord)record).keySchema(), ((ConnectRecord)record).key(), updatedSchema, updatedValue, ((ConnectRecord)record).timestamp());
        }
    }

    public static class Key<R extends ConnectRecord<R>>
    extends TimestampConverter<R> {
        @Override
        protected Schema operatingSchema(R record) {
            return ((ConnectRecord)record).keySchema();
        }

        @Override
        protected Object operatingValue(R record) {
            return ((ConnectRecord)record).key();
        }

        @Override
        protected R newRecord(R record, Schema updatedSchema, Object updatedValue) {
            return ((ConnectRecord)record).newRecord(((ConnectRecord)record).topic(), ((ConnectRecord)record).kafkaPartition(), updatedSchema, updatedValue, ((ConnectRecord)record).valueSchema(), ((ConnectRecord)record).value(), ((ConnectRecord)record).timestamp());
        }
    }

    private static class Config {
        String field;
        String type;
        SimpleDateFormat format;
        String unixPrecision;

        Config(String field, String type, SimpleDateFormat format, String unixPrecision) {
            this.field = field;
            this.type = type;
            this.format = format;
            this.unixPrecision = unixPrecision;
        }
    }

    private static interface TimestampTranslator {
        public java.util.Date toRaw(Config var1, Object var2);

        public Schema typeSchema(boolean var1);

        public Object toType(Config var1, java.util.Date var2);
    }
}

