/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.util;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.admin.Admin;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.InvalidRecordException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.KafkaFuture;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.connector.Connector;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.ConnectException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.WorkerConfig;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.sink.SinkConnector;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceConnector;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectUtils {
    private static final Logger log = LoggerFactory.getLogger(ConnectUtils.class);

    public static Long checkAndConvertTimestamp(Long timestamp) {
        if (timestamp == null || timestamp >= 0L) {
            return timestamp;
        }
        if (timestamp == -1L) {
            return null;
        }
        throw new InvalidRecordException(String.format("Invalid record timestamp %d", timestamp));
    }

    public static String lookupKafkaClusterId(WorkerConfig config) {
        log.info("Creating Kafka admin client");
        try (Admin adminClient = Admin.create(config.originals());){
            String string = ConnectUtils.lookupKafkaClusterId(adminClient);
            return string;
        }
    }

    static String lookupKafkaClusterId(Admin adminClient) {
        log.debug("Looking up Kafka cluster ID");
        try {
            KafkaFuture<String> clusterIdFuture = adminClient.describeCluster().clusterId();
            if (clusterIdFuture == null) {
                log.info("Kafka cluster version is too old to return cluster ID");
                return null;
            }
            log.debug("Fetching Kafka cluster ID");
            String kafkaClusterId = clusterIdFuture.get();
            log.info("Kafka cluster ID: {}", (Object)kafkaClusterId);
            return kafkaClusterId;
        }
        catch (InterruptedException e2) {
            throw new ConnectException("Unexpectedly interrupted when looking up Kafka cluster info", e2);
        }
        catch (ExecutionException e3) {
            throw new ConnectException("Failed to connect to and describe Kafka cluster. Check worker's broker connection and security properties.", e3);
        }
    }

    public static void ensureProperty(Map<String, ? super String> props, String key, String expectedValue, String justification, boolean caseSensitive) {
        ConnectUtils.ensurePropertyAndGetWarning(props, key, expectedValue, justification, caseSensitive).ifPresent(arg_0 -> ((Logger)log).warn(arg_0));
    }

    static Optional<String> ensurePropertyAndGetWarning(Map<String, ? super String> props, String key, String expectedValue, String justification, boolean caseSensitive) {
        boolean matchesExpectedValue;
        if (!props.containsKey(key)) {
            props.put(key, expectedValue);
            return Optional.empty();
        }
        String value = Objects.toString(props.get(key));
        boolean bl = matchesExpectedValue = caseSensitive ? expectedValue.equals(value) : expectedValue.equalsIgnoreCase(value);
        if (matchesExpectedValue) {
            return Optional.empty();
        }
        props.put(key, expectedValue);
        justification = justification != null ? " " + justification : "";
        return Optional.of(String.format("The value '%s' for the '%s' property will be ignored as it cannot be overridden%s. The value '%s' will be used instead.", value, key, justification, expectedValue));
    }

    public static void addMetricsContextProperties(Map<String, Object> prop, WorkerConfig config, String clusterId) {
        prop.putAll(config.originalsWithPrefix("metrics.context.", false));
        prop.put("metrics.context.connect.kafka.cluster.id", clusterId);
        Object groupId = config.originals().get("group.id");
        if (groupId != null) {
            prop.put("metrics.context.connect.group.id", groupId);
        }
    }

    public static boolean isSinkConnector(Connector connector) {
        return SinkConnector.class.isAssignableFrom(connector.getClass());
    }

    public static boolean isSourceConnector(Connector connector) {
        return SourceConnector.class.isAssignableFrom(connector.getClass());
    }
}

