/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.util;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.admin.NewTopic;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.SourceConnectorConfig;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.util.TopicAdmin;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;

public class TopicCreationGroup {
    private final String name;
    private final Pattern inclusionPattern;
    private final Pattern exclusionPattern;
    private final int numPartitions;
    private final short replicationFactor;
    private final Map<String, Object> otherConfigs;

    protected TopicCreationGroup(String group, SourceConnectorConfig config) {
        this.name = group;
        this.inclusionPattern = Pattern.compile(String.join((CharSequence)"|", config.topicCreationInclude(group)));
        this.exclusionPattern = Pattern.compile(String.join((CharSequence)"|", config.topicCreationExclude(group)));
        this.numPartitions = config.topicCreationPartitions(group);
        this.replicationFactor = config.topicCreationReplicationFactor(group);
        this.otherConfigs = config.topicCreationOtherConfigs(group);
    }

    public static Map<String, TopicCreationGroup> configuredGroups(SourceConnectorConfig config) {
        if (!config.usesTopicCreation()) {
            return Collections.emptyMap();
        }
        List<String> groupNames = config.getList("topic.creation.groups");
        LinkedHashMap<String, TopicCreationGroup> groups = new LinkedHashMap<String, TopicCreationGroup>();
        for (String group : groupNames) {
            groups.put(group, new TopicCreationGroup(group, config));
        }
        groups.put("default", new TopicCreationGroup("default", config));
        return groups;
    }

    public String name() {
        return this.name;
    }

    public boolean matches(String topic) {
        return !this.exclusionPattern.matcher(topic).matches() && this.inclusionPattern.matcher(topic).matches();
    }

    public NewTopic newTopic(String topic) {
        TopicAdmin.NewTopicBuilder builder = new TopicAdmin.NewTopicBuilder(topic);
        return builder.partitions(this.numPartitions).replicationFactor(this.replicationFactor).config(this.otherConfigs).build();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof TopicCreationGroup)) {
            return false;
        }
        TopicCreationGroup that = (TopicCreationGroup)o2;
        return Objects.equals(this.name, that.name) && this.numPartitions == that.numPartitions && this.replicationFactor == that.replicationFactor && Objects.equals(this.inclusionPattern.pattern(), that.inclusionPattern.pattern()) && Objects.equals(this.exclusionPattern.pattern(), that.exclusionPattern.pattern()) && Objects.equals(this.otherConfigs, that.otherConfigs);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.numPartitions, this.replicationFactor, this.inclusionPattern.pattern(), this.exclusionPattern.pattern(), this.otherConfigs);
    }

    public String toString() {
        return "TopicCreationGroup{name='" + this.name + '\'' + ", inclusionPattern=" + this.inclusionPattern + ", exclusionPattern=" + this.exclusionPattern + ", numPartitions=" + this.numPartitions + ", replicationFactor=" + this.replicationFactor + ", otherConfigs=" + this.otherConfigs + '}';
    }
}

