/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.tools;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.KafkaException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.AbstractConfig;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigDef;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.SaslConfigs;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.SslConfigs;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.types.Password;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.oauthbearer.secured.AccessTokenRetriever;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.oauthbearer.secured.AccessTokenRetrieverFactory;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.oauthbearer.secured.AccessTokenValidator;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.oauthbearer.secured.AccessTokenValidatorFactory;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.oauthbearer.secured.CloseableVerificationKeyResolver;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.security.oauthbearer.secured.VerificationKeyResolverFactory;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Exit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.Argument;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;

public class OAuthCompatibilityTool {
    public static void main(String[] args) {
        Namespace namespace;
        ArgsHandler argsHandler = new ArgsHandler();
        try {
            namespace = argsHandler.parseArgs(args);
        }
        catch (ArgumentParserException e2) {
            Exit.exit(1);
            return;
        }
        ConfigHandler configHandler = new ConfigHandler(namespace);
        Map configs = configHandler.getConfigs();
        Map jaasConfigs = configHandler.getJaasOptions();
        try {
            String accessToken;
            AccessTokenValidator atv;
            try (AccessTokenRetriever atr = AccessTokenRetrieverFactory.create(configs, jaasConfigs);){
                atr.init();
                atv = AccessTokenValidatorFactory.create(configs);
                System.out.println("PASSED 1/5: client configuration");
                accessToken = atr.retrieve();
                System.out.println("PASSED 2/5: client JWT retrieval");
                atv.validate(accessToken);
                System.out.println("PASSED 3/5: client JWT validation");
            }
            var8_8 = null;
            try (CloseableVerificationKeyResolver vkr = VerificationKeyResolverFactory.create(configs, jaasConfigs);){
                vkr.init();
                atv = AccessTokenValidatorFactory.create(configs, vkr);
                System.out.println("PASSED 4/5: broker configuration");
                atv.validate(accessToken);
                System.out.println("PASSED 5/5: broker JWT validation");
            }
            catch (Throwable throwable) {
                var8_8 = throwable;
                throw throwable;
            }
            System.out.println("SUCCESS");
            Exit.exit(0);
        }
        catch (Throwable t2) {
            System.out.println("FAILED:");
            t2.printStackTrace();
            if (t2 instanceof ConfigException) {
                System.out.printf("%n", new Object[0]);
                argsHandler.parser.printHelp();
            }
            Exit.exit(1);
        }
    }

    private static class ConfigHandler {
        private final Namespace namespace;

        private ConfigHandler(Namespace namespace) {
            this.namespace = namespace;
        }

        private Map<String, ?> getConfigs() {
            HashMap<String, Object> m2 = new HashMap<String, Object>();
            this.maybeAddInt(m2, "sasl.login.connect.timeout.ms");
            this.maybeAddInt(m2, "sasl.login.read.timeout.ms");
            this.maybeAddLong(m2, "sasl.login.retry.backoff.ms");
            this.maybeAddLong(m2, "sasl.login.retry.backoff.max.ms");
            this.maybeAddString(m2, "sasl.oauthbearer.scope.claim.name");
            this.maybeAddString(m2, "sasl.oauthbearer.sub.claim.name");
            this.maybeAddString(m2, "sasl.oauthbearer.token.endpoint.url");
            this.maybeAddString(m2, "sasl.oauthbearer.jwks.endpoint.url");
            this.maybeAddLong(m2, "sasl.oauthbearer.jwks.endpoint.refresh.ms");
            this.maybeAddLong(m2, "sasl.oauthbearer.jwks.endpoint.retry.backoff.max.ms");
            this.maybeAddLong(m2, "sasl.oauthbearer.jwks.endpoint.retry.backoff.ms");
            this.maybeAddInt(m2, "sasl.oauthbearer.clock.skew.seconds");
            this.maybeAddStringList(m2, "sasl.oauthbearer.expected.audience");
            this.maybeAddString(m2, "sasl.oauthbearer.expected.issuer");
            ConfigDef cd = new ConfigDef();
            SaslConfigs.addClientSaslSupport(cd);
            SslConfigs.addClientSslSupport(cd);
            AbstractConfig config = new AbstractConfig(cd, m2);
            return config.values();
        }

        private Map<String, Object> getJaasOptions() {
            HashMap<String, Object> m2 = new HashMap<String, Object>();
            this.maybeAddString(m2, "clientId");
            this.maybeAddString(m2, "clientSecret");
            this.maybeAddString(m2, "scope");
            this.maybeAddStringList(m2, "ssl.cipher.suites");
            this.maybeAddStringList(m2, "ssl.enabled.protocols");
            this.maybeAddString(m2, "ssl.endpoint.identification.algorithm");
            this.maybeAddClass(m2, "ssl.engine.factory.class");
            this.maybeAddString(m2, "ssl.keymanager.algorithm");
            this.maybeAddPassword(m2, "ssl.keystore.certificate.chain");
            this.maybeAddPassword(m2, "ssl.keystore.key");
            this.maybeAddString(m2, "ssl.keystore.location");
            this.maybeAddPassword(m2, "ssl.keystore.password");
            this.maybeAddString(m2, "ssl.keystore.type");
            this.maybeAddPassword(m2, "ssl.key.password");
            this.maybeAddString(m2, "ssl.protocol");
            this.maybeAddString(m2, "ssl.provider");
            this.maybeAddString(m2, "ssl.secure.random.implementation");
            this.maybeAddString(m2, "ssl.trustmanager.algorithm");
            this.maybeAddPassword(m2, "ssl.truststore.certificates");
            this.maybeAddString(m2, "ssl.truststore.location");
            this.maybeAddPassword(m2, "ssl.truststore.password");
            this.maybeAddString(m2, "ssl.truststore.type");
            return m2;
        }

        private void maybeAddInt(Map<String, Object> m2, String option) {
            Integer value = this.namespace.getInt(option);
            if (value != null) {
                m2.put(option, value);
            }
        }

        private void maybeAddLong(Map<String, Object> m2, String option) {
            Long value = this.namespace.getLong(option);
            if (value != null) {
                m2.put(option, value);
            }
        }

        private void maybeAddString(Map<String, Object> m2, String option) {
            String value = this.namespace.getString(option);
            if (value != null) {
                m2.put(option, value);
            }
        }

        private void maybeAddPassword(Map<String, Object> m2, String option) {
            String value = this.namespace.getString(option);
            if (value != null) {
                m2.put(option, new Password(value));
            }
        }

        private void maybeAddClass(Map<String, Object> m2, String option) {
            String value = this.namespace.getString(option);
            if (value != null) {
                try {
                    m2.put(option, Class.forName(value));
                }
                catch (ClassNotFoundException e2) {
                    throw new KafkaException("Could not find class for " + option, e2);
                }
            }
        }

        private void maybeAddStringList(Map<String, Object> m2, String option) {
            List value = this.namespace.getList(option);
            if (value != null) {
                m2.put(option, value);
            }
        }
    }

    private static class ArgsHandler {
        private static final String DESCRIPTION = String.format("This tool is used to verify OAuth/OIDC provider compatibility.%n%nRun the following script to determine the configuration options:%n%n    ./bin/kafka-run-class.sh %s --help", OAuthCompatibilityTool.class.getName());
        private final ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"oauth-compatibility-tool").defaultHelp(true).description(DESCRIPTION);

        private ArgsHandler() {
        }

        private Namespace parseArgs(String[] args) throws ArgumentParserException {
            this.addArgument("sasl.login.connect.timeout.ms", "The (optional) value in milliseconds for the external authentication provider connection timeout. Currently applies only to OAUTHBEARER.", Integer.class);
            this.addArgument("sasl.login.read.timeout.ms", "The (optional) value in milliseconds for the external authentication provider read timeout. Currently applies only to OAUTHBEARER.", Integer.class);
            this.addArgument("sasl.login.retry.backoff.max.ms", "The (optional) value in milliseconds for the maximum wait between login attempts to the external authentication provider. Login uses an exponential backoff algorithm with an initial wait based on the sasl.login.retry.backoff.ms setting and will double in wait length between attempts up to a maximum wait length specified by the sasl.login.retry.backoff.max.ms setting. Currently applies only to OAUTHBEARER.", Long.class);
            this.addArgument("sasl.login.retry.backoff.ms", "The (optional) value in milliseconds for the initial wait between login attempts to the external authentication provider. Login uses an exponential backoff algorithm with an initial wait based on the sasl.login.retry.backoff.ms setting and will double in wait length between attempts up to a maximum wait length specified by the sasl.login.retry.backoff.max.ms setting. Currently applies only to OAUTHBEARER.", Long.class);
            this.addArgument("sasl.oauthbearer.clock.skew.seconds", "The (optional) value in seconds to allow for differences between the time of the OAuth/OIDC identity provider and the broker.", Integer.class);
            this.addArgument("sasl.oauthbearer.expected.audience", "The (optional) comma-delimited setting for the broker to use to verify that the JWT was issued for one of the expected audiences. The JWT will be inspected for the standard OAuth \"aud\" claim and if this value is set, the broker will match the value from JWT's \"aud\" claim  to see if there is an exact match. If there is no match, the broker will reject the JWT and authentication will fail.").action((ArgumentAction)Arguments.append());
            this.addArgument("sasl.oauthbearer.expected.issuer", "The (optional) setting for the broker to use to verify that the JWT was created by the expected issuer. The JWT will be inspected for the standard OAuth \"iss\" claim and if this value is set, the broker will match it exactly against what is in the JWT's \"iss\" claim. If there is no match, the broker will reject the JWT and authentication will fail.");
            this.addArgument("sasl.oauthbearer.jwks.endpoint.refresh.ms", "The (optional) value in milliseconds for the broker to wait between refreshing its JWKS (JSON Web Key Set) cache that contains the keys to verify the signature of the JWT.", Long.class);
            this.addArgument("sasl.oauthbearer.jwks.endpoint.retry.backoff.max.ms", "The (optional) value in milliseconds for the maximum wait between attempts to retrieve the JWKS (JSON Web Key Set) from the external authentication provider. JWKS retrieval uses an exponential backoff algorithm with an initial wait based on the sasl.oauthbearer.jwks.endpoint.retry.backoff.ms setting and will double in wait length between attempts up to a maximum wait length specified by the sasl.oauthbearer.jwks.endpoint.retry.backoff.max.ms setting.", Long.class);
            this.addArgument("sasl.oauthbearer.jwks.endpoint.retry.backoff.ms", "The (optional) value in milliseconds for the initial wait between JWKS (JSON Web Key Set) retrieval attempts from the external authentication provider. JWKS retrieval uses an exponential backoff algorithm with an initial wait based on the sasl.oauthbearer.jwks.endpoint.retry.backoff.ms setting and will double in wait length between attempts up to a maximum wait length specified by the sasl.oauthbearer.jwks.endpoint.retry.backoff.max.ms setting.", Long.class);
            this.addArgument("sasl.oauthbearer.jwks.endpoint.url", "The OAuth/OIDC provider URL from which the provider's <a href=\"https://datatracker.ietf.org/doc/html/rfc7517#section-5\">JWKS (JSON Web Key Set)</a> can be retrieved. The URL can be HTTP(S)-based or file-based. If the URL is HTTP(S)-based, the JWKS data will be retrieved from the OAuth/OIDC provider via the configured URL on broker startup. All then-current keys will be cached on the broker for incoming requests. If an authentication request is received for a JWT that includes a \"kid\" header claim value that isn't yet in the cache, the JWKS endpoint will be queried again on demand. However, the broker polls the URL every sasl.oauthbearer.jwks.endpoint.refresh.ms milliseconds to refresh the cache with any forthcoming keys before any JWT requests that include them are received. If the URL is file-based, the broker will load the JWKS file from a configured location on startup. In the event that the JWT includes a \"kid\" header value that isn't in the JWKS file, the broker will reject the JWT and authentication will fail.");
            this.addArgument("sasl.oauthbearer.scope.claim.name", "The OAuth claim for the scope is often named \"scope\", but this (optional) setting can provide a different name to use for the scope included in the JWT payload's claims if the OAuth/OIDC provider uses a different name for that claim.");
            this.addArgument("sasl.oauthbearer.sub.claim.name", "The OAuth claim for the subject is often named \"sub\", but this (optional) setting can provide a different name to use for the subject included in the JWT payload's claims if the OAuth/OIDC provider uses a different name for that claim.");
            this.addArgument("sasl.oauthbearer.token.endpoint.url", "The URL for the OAuth/OIDC identity provider. If the URL is HTTP(S)-based, it is the issuer's token endpoint URL to which requests will be made to login based on the configuration in sasl.jaas.config. If the URL is file-based, it specifies a file containing an access token (in JWT serialized form) issued by the OAuth/OIDC identity provider to use for authorization.");
            this.addArgument("ssl.cipher.suites", "A list of cipher suites. This is a named combination of authentication, encryption, MAC and key exchange algorithm used to negotiate the security settings for a network connection using TLS or SSL network protocol. By default all the available cipher suites are supported.").action((ArgumentAction)Arguments.append());
            this.addArgument("ssl.enabled.protocols", "The list of protocols enabled for SSL connections. The default is 'TLSv1.2,TLSv1.3' when running with Java 11 or newer, 'TLSv1.2' otherwise. With the default value for Java 11, clients and servers will prefer TLSv1.3 if both support it and fallback to TLSv1.2 otherwise (assuming both support at least TLSv1.2). This default should be fine for most cases. Also see the config documentation for `ssl.protocol`.").action((ArgumentAction)Arguments.append());
            this.addArgument("ssl.endpoint.identification.algorithm", "The endpoint identification algorithm to validate server hostname using server certificate. ");
            this.addArgument("ssl.engine.factory.class", "The class of type org.apache.kafka.common.security.auth.SslEngineFactory to provide SSLEngine objects. Default value is org.apache.kafka.common.security.ssl.DefaultSslEngineFactory");
            this.addArgument("ssl.keymanager.algorithm", "The algorithm used by key manager factory for SSL connections. Default value is the key manager factory algorithm configured for the Java Virtual Machine.");
            this.addArgument("ssl.keystore.certificate.chain", "Certificate chain in the format specified by 'ssl.keystore.type'. Default SSL engine factory supports only PEM format with a list of X.509 certificates");
            this.addArgument("ssl.keystore.key", "Private key in the format specified by 'ssl.keystore.type'. Default SSL engine factory supports only PEM format with PKCS#8 keys. If the key is encrypted, key password must be specified using 'ssl.key.password'");
            this.addArgument("ssl.keystore.location", "The location of the key store file. This is optional for client and can be used for two-way authentication for client.");
            this.addArgument("ssl.keystore.password", "The store password for the key store file. This is optional for client and only needed if 'ssl.keystore.location' is configured. Key store password is not supported for PEM format.");
            this.addArgument("ssl.keystore.type", "The file format of the key store file. This is optional for client.");
            this.addArgument("ssl.key.password", "The password of the private key in the key store file or the PEM key specified in `ssl.keystore.key'. This is required for clients only if two-way authentication is configured.");
            this.addArgument("ssl.protocol", "The SSL protocol used to generate the SSLContext. The default is 'TLSv1.3' when running with Java 11 or newer, 'TLSv1.2' otherwise. This value should be fine for most use cases. Allowed values in recent JVMs are 'TLSv1.2' and 'TLSv1.3'. 'TLS', 'TLSv1.1', 'SSL', 'SSLv2' and 'SSLv3' may be supported in older JVMs, but their usage is discouraged due to known security vulnerabilities. With the default value for this config and 'ssl.enabled.protocols', clients will downgrade to 'TLSv1.2' if the server does not support 'TLSv1.3'. If this config is set to 'TLSv1.2', clients will not use 'TLSv1.3' even if it is one of the values in ssl.enabled.protocols and the server only supports 'TLSv1.3'.");
            this.addArgument("ssl.provider", "The name of the security provider used for SSL connections. Default value is the default security provider of the JVM.");
            this.addArgument("ssl.secure.random.implementation", "The SecureRandom PRNG implementation to use for SSL cryptography operations. ");
            this.addArgument("ssl.trustmanager.algorithm", "The algorithm used by trust manager factory for SSL connections. Default value is the trust manager factory algorithm configured for the Java Virtual Machine.");
            this.addArgument("ssl.truststore.certificates", "Trusted certificates in the format specified by 'ssl.truststore.type'. Default SSL engine factory supports only PEM format with X.509 certificates.");
            this.addArgument("ssl.truststore.location", "The location of the trust store file.");
            this.addArgument("ssl.truststore.password", "The password for the trust store file. If a password is not set, trust store file configured will still be used, but integrity checking is disabled. Trust store password is not supported for PEM format.");
            this.addArgument("ssl.truststore.type", "The file format of the trust store file.");
            this.addArgument("clientId", "The OAuth/OIDC identity provider-issued client ID to uniquely identify the service account to use for authentication for this client. The value must be paired with a corresponding clientSecret value and is provided to the OAuth provider using the OAuth clientcredentials grant type.");
            this.addArgument("clientSecret", "The OAuth/OIDC identity provider-issued client secret serves a similar function as a password to the clientId account and identifies the service account to use for authentication for this client. The value must be paired with a corresponding clientId value and is provided to the OAuth provider using the OAuth clientcredentials grant type.");
            this.addArgument("scope", "The (optional) HTTP/HTTPS login request to the token endpoint (sasl.oauthbearer.token.endpoint.url) may need to specify an OAuth \"scope\". If so, the scope is used to provide the value to include with the login request.");
            try {
                return this.parser.parseArgs(args);
            }
            catch (ArgumentParserException e2) {
                this.parser.handleError(e2);
                throw e2;
            }
        }

        private Argument addArgument(String option, String help) {
            return this.addArgument(option, help, String.class);
        }

        private Argument addArgument(String option, String help, Class<?> clazz) {
            String name = "--" + option;
            return this.parser.addArgument(new String[]{name}).type(clazz).metavar(new String[]{option}).dest(option).help(help);
        }
    }
}

