/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import io.debezium.DebeziumException;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.data.Envelope;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.Column;
import io.debezium.relational.RelationalChangeRecordEmitter;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.TableSchema;
import io.debezium.util.Clock;
import io.debezium.util.Strings;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseChangeRecordEmitter<T>
extends RelationalChangeRecordEmitter {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseChangeRecordEmitter.class);
    private final OracleConnectorConfig connectorConfig;
    private final Object[] oldColumnValues;
    private final Object[] newColumnValues;
    private final OracleDatabaseSchema schema;
    protected final Table table;

    protected BaseChangeRecordEmitter(OracleConnectorConfig connectorConfig, Partition partition, OffsetContext offset, OracleDatabaseSchema schema, Table table, Clock clock, Object[] oldColumnValues, Object[] newColumnValues) {
        super(partition, offset, clock);
        this.connectorConfig = connectorConfig;
        this.schema = schema;
        this.oldColumnValues = oldColumnValues;
        this.newColumnValues = newColumnValues;
        this.table = table;
    }

    @Override
    protected Object[] getOldColumnValues() {
        return this.oldColumnValues;
    }

    @Override
    protected Object[] getNewColumnValues() {
        return this.newColumnValues;
    }

    protected void emitTruncateRecord(ChangeRecordEmitter.Receiver receiver, TableSchema tableSchema) throws InterruptedException {
        Struct envelope = tableSchema.getEnvelopeSchema().truncate(this.getOffset().getSourceInfo(), this.getClock().currentTimeAsInstant());
        receiver.changeRecord(this.getPartition(), tableSchema, Envelope.Operation.TRUNCATE, null, envelope, this.getOffset(), null);
    }

    protected void emitUpdateAsPrimaryKeyChangeRecord(ChangeRecordEmitter.Receiver receiver, TableSchema tableSchema, Struct oldKey, Struct newKey, Struct oldValue, Struct newValue) throws InterruptedException {
        List<Column> reselectColumns;
        if (this.connectorConfig.isLobEnabled() && !(reselectColumns = this.getReselectColumns(newValue)).isEmpty()) {
            LOGGER.info("Table '{}' primary key changed from '{}' to '{}' via an UPDATE, re-selecting LOB columns {} out of bands.", new Object[]{this.table.id(), oldKey, newKey, reselectColumns.stream().map(Column::name).collect(Collectors.toList())});
            JdbcConfiguration jdbcConfig = this.connectorConfig.getJdbcConfig();
            try (OracleConnection connection = new OracleConnection(jdbcConfig, () -> this.getClass().getClassLoader(), false);){
                String query = this.getReselectQuery(reselectColumns, this.table, connection);
                if (!Strings.isNullOrBlank(this.connectorConfig.getPdbName())) {
                    connection.setSessionToPdb(this.connectorConfig.getPdbName());
                }
                connection.prepareQuery(query, ps -> this.prepareReselectQueryStatement(ps, this.table, newKey), rs -> this.updateNewValuesFromReselectQueryResults(rs, reselectColumns));
                newValue = tableSchema.valueFromColumnData(this.newColumnValues);
            }
            catch (SQLException e2) {
                throw new DebeziumException("Failed to re-select table with LOB columns due to primary key update", e2);
            }
        }
        super.emitUpdateAsPrimaryKeyChangeRecord(receiver, tableSchema, oldKey, newKey, oldValue, newValue);
    }

    private List<Column> getReselectColumns(Struct newValue) {
        ArrayList<Column> reselectColumns = new ArrayList<Column>();
        for (Column column : this.schema.getLobColumnsForTable(this.table.id())) {
            Object value;
            if (!this.schema.isColumnUnavailableValuePlaceholder(column, value = newValue.get(column.name()))) continue;
            reselectColumns.add(column);
        }
        return reselectColumns;
    }

    private String getReselectQuery(List<Column> reselectColumns, Table table, OracleConnection connection) {
        TableId id = new TableId(null, table.id().schema(), table.id().table());
        StringBuilder query = new StringBuilder("SELECT ").append(reselectColumns.stream().map(c2 -> connection.quotedColumnIdString(c2.name())).collect(Collectors.joining(", "))).append(" FROM ").append(id.toDoubleQuotedString()).append(" WHERE ");
        for (int i2 = 0; i2 < table.primaryKeyColumnNames().size(); ++i2) {
            if (i2 > 0) {
                query.append(" AND ");
            }
            query.append(connection.quotedColumnIdString(table.primaryKeyColumnNames().get(i2))).append("=?");
        }
        return query.toString();
    }

    private void prepareReselectQueryStatement(PreparedStatement ps, Table table, Struct newKey) throws SQLException {
        for (int i2 = 0; i2 < table.primaryKeyColumnNames().size(); ++i2) {
            ps.setObject(i2 + 1, newKey.get(table.primaryKeyColumnNames().get(i2)));
        }
    }

    private void updateNewValuesFromReselectQueryResults(ResultSet rs, List<Column> reselectColumns) throws SQLException {
        if (rs.next()) {
            for (int i2 = 0; i2 < reselectColumns.size(); ++i2) {
                Column column = reselectColumns.get(i2);
                this.newColumnValues[column.position() - 1] = rs.getObject(i2 + 1);
            }
        }
    }
}

