/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle;

import io.debezium.DebeziumException;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OraclePartition;
import io.debezium.connector.oracle.OracleTableIdParser;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.source.snapshot.incremental.SignalBasedIncrementalSnapshotChangeEventSource;
import io.debezium.pipeline.source.spi.DataChangeEventListener;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.TableId;
import io.debezium.schema.DatabaseSchema;
import io.debezium.util.Clock;
import java.sql.SQLException;

public class OracleSignalBasedIncrementalSnapshotChangeEventSource
extends SignalBasedIncrementalSnapshotChangeEventSource<OraclePartition, TableId> {
    private final String pdbName;
    private final OracleConnection connection;

    public OracleSignalBasedIncrementalSnapshotChangeEventSource(RelationalDatabaseConnectorConfig config, JdbcConnection jdbcConnection, EventDispatcher<OraclePartition, TableId> dispatcher, DatabaseSchema<?> databaseSchema, Clock clock, SnapshotProgressListener<OraclePartition> progressListener, DataChangeEventListener<OraclePartition> dataChangeEventListener) {
        super(config, jdbcConnection, dispatcher, databaseSchema, clock, progressListener, dataChangeEventListener);
        this.pdbName = ((OracleConnectorConfig)config).getPdbName();
        this.connection = (OracleConnection)jdbcConnection;
    }

    @Override
    protected String getSignalTableName(String dataCollectionId) {
        TableId tableId = OracleTableIdParser.parse(dataCollectionId);
        return tableId.schema() + "." + tableId.table();
    }

    @Override
    protected void preReadChunk(IncrementalSnapshotContext<TableId> context) {
        super.preReadChunk(context);
        if (this.pdbName != null) {
            this.connection.setSessionToPdb(this.pdbName);
        }
    }

    @Override
    protected void postReadChunk(IncrementalSnapshotContext<TableId> context) {
        super.postReadChunk(context);
        if (this.pdbName != null) {
            this.connection.resetSessionToCdb();
        }
    }

    @Override
    protected void postIncrementalSnapshotCompleted() {
        super.postIncrementalSnapshotCompleted();
        try {
            this.connection.close();
        }
        catch (SQLException e2) {
            throw new DebeziumException("Failed to close snapshot connection", e2);
        }
    }
}

