/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.SchemaAndValue;
import io.debezium.DebeziumException;
import io.debezium.connector.oracle.BaseChangeRecordEmitter;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.connector.oracle.logminer.events.EventType;
import io.debezium.data.Envelope;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.Table;
import io.debezium.util.Clock;
import oracle.sql.ROWID;

public class LogMinerChangeRecordEmitter
extends BaseChangeRecordEmitter<Object> {
    private final Envelope.Operation operation;

    public LogMinerChangeRecordEmitter(OracleConnectorConfig connectorConfig, Partition partition, OffsetContext offset, Envelope.Operation operation, Object[] oldValues, Object[] newValues, Table table, OracleDatabaseSchema schema, Clock clock, String rowId) {
        super(connectorConfig, partition, offset, schema, table, clock, oldValues, newValues);
        this.operation = operation;
        this.addStaticHeader(ROWID.class.getSimpleName(), new SchemaAndValue(null, rowId));
    }

    public LogMinerChangeRecordEmitter(OracleConnectorConfig connectorConfig, Partition partition, OffsetContext offset, EventType eventType, Object[] oldValues, Object[] newValues, Table table, OracleDatabaseSchema schema, Clock clock, String rowId) {
        this(connectorConfig, partition, offset, LogMinerChangeRecordEmitter.getOperation(eventType), oldValues, newValues, table, schema, clock, rowId);
    }

    private static Envelope.Operation getOperation(EventType eventType) {
        switch (eventType) {
            case INSERT: {
                return Envelope.Operation.CREATE;
            }
            case UPDATE: 
            case SELECT_LOB_LOCATOR: {
                return Envelope.Operation.UPDATE;
            }
            case DELETE: {
                return Envelope.Operation.DELETE;
            }
        }
        throw new DebeziumException("Unsupported operation type: " + (Object)((Object)eventType));
    }

    @Override
    public Envelope.Operation getOperation() {
        return this.operation;
    }
}

