/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.events;

import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.events.EventType;
import io.debezium.connector.oracle.logminer.events.LogMinerEventRow;
import io.debezium.relational.TableId;
import java.time.Instant;
import java.util.Objects;

public class LogMinerEvent {
    private final EventType eventType;
    private final Scn scn;
    private final TableId tableId;
    private final String rowId;
    private final String rsId;
    private final Instant changeTime;

    public LogMinerEvent(LogMinerEventRow row) {
        this(row.getEventType(), row.getScn(), row.getTableId(), row.getRowId(), row.getRsId(), row.getChangeTime());
    }

    public LogMinerEvent(EventType eventType, Scn scn, TableId tableId, String rowId, String rsId, Instant changeTime) {
        this.eventType = eventType;
        this.scn = scn;
        this.tableId = tableId;
        this.rowId = rowId;
        this.rsId = rsId;
        this.changeTime = changeTime;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public Scn getScn() {
        return this.scn;
    }

    public TableId getTableId() {
        return this.tableId;
    }

    public String getRowId() {
        return this.rowId;
    }

    public String getRsId() {
        return this.rsId;
    }

    public Instant getChangeTime() {
        return this.changeTime;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        LogMinerEvent that = (LogMinerEvent)o2;
        return this.eventType == that.eventType && Objects.equals(this.scn, that.scn) && Objects.equals(this.tableId, that.tableId) && Objects.equals(this.rowId, that.rowId) && Objects.equals(this.rsId, that.rsId) && Objects.equals(this.changeTime, that.changeTime);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.eventType, this.scn, this.tableId, this.rowId, this.rsId, this.changeTime});
    }

    public String toString() {
        return "LogMinerEvent{eventType=" + (Object)((Object)this.eventType) + ", scn=" + this.scn + ", tableId=" + this.tableId + ", rowId='" + this.rowId + '\'' + ", rsId=" + this.rsId + ", changeTime=" + this.changeTime + '}';
    }
}

