/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.events;

import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.events.EventType;
import io.debezium.relational.TableId;
import io.debezium.util.HexConverter;
import io.debezium.util.Strings;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogMinerEventRow {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogMinerEventRow.class);
    private static final Calendar UTC_CALENDAR = Calendar.getInstance(TimeZone.getTimeZone(ZoneOffset.UTC));
    private static final int SCN = 1;
    private static final int SQL_REDO = 2;
    private static final int OPERATION_CODE = 3;
    private static final int CHANGE_TIME = 4;
    private static final int TX_ID = 5;
    private static final int CSF = 6;
    private static final int TABLE_NAME = 7;
    private static final int TABLESPACE_NAME = 8;
    private static final int OPERATION = 9;
    private static final int USERNAME = 10;
    private static final int ROW_ID = 11;
    private static final int ROLLBACK_FLAG = 12;
    private static final int RS_ID = 13;
    private static final int STATUS = 14;
    private static final int INFO = 15;
    private static final int SSN = 16;
    private static final int THREAD = 17;
    private Scn scn;
    private TableId tableId;
    private String tableName;
    private String tablespaceName;
    private EventType eventType;
    private Instant changeTime;
    private String transactionId;
    private String operation;
    private String userName;
    private String rowId;
    private boolean rollbackFlag;
    private String rsId;
    private String redoSql;
    private int status;
    private String info;
    private int ssn;
    private int thread;

    public Scn getScn() {
        return this.scn;
    }

    public TableId getTableId() {
        return this.tableId;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTablespaceName() {
        return this.tablespaceName;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public Instant getChangeTime() {
        return this.changeTime;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getOperation() {
        return this.operation;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getRowId() {
        return this.rowId;
    }

    public boolean isRollbackFlag() {
        return this.rollbackFlag;
    }

    public String getRsId() {
        return this.rsId;
    }

    public String getRedoSql() {
        return this.redoSql;
    }

    public int getStatus() {
        return this.status;
    }

    public String getInfo() {
        return this.info;
    }

    public int getSsn() {
        return this.ssn;
    }

    public int getThread() {
        return this.thread;
    }

    public static LogMinerEventRow fromResultSet(ResultSet resultSet, String catalogName, boolean isTxIdRawValue) throws SQLException {
        LogMinerEventRow row = new LogMinerEventRow();
        row.initializeFromResultSet(resultSet, catalogName, isTxIdRawValue);
        return row;
    }

    private void initializeFromResultSet(ResultSet resultSet, String catalogName, boolean isTxIdRawValue) throws SQLException {
        this.scn = this.getScn(resultSet);
        this.tableName = resultSet.getString(7);
        this.tablespaceName = resultSet.getString(8);
        this.eventType = EventType.from(resultSet.getInt(3));
        this.changeTime = this.getChangeTime(resultSet);
        this.transactionId = this.getTransactionId(resultSet, isTxIdRawValue);
        this.operation = resultSet.getString(9);
        this.userName = resultSet.getString(10);
        this.rowId = resultSet.getString(11);
        this.rollbackFlag = resultSet.getInt(12) == 1;
        this.rsId = resultSet.getString(13);
        this.redoSql = this.getSqlRedo(resultSet);
        this.status = resultSet.getInt(14);
        this.info = resultSet.getString(15);
        this.ssn = resultSet.getInt(16);
        this.thread = resultSet.getInt(17);
        if (this.tableName != null) {
            this.tableId = new TableId(catalogName, this.tablespaceName, this.tableName);
        }
    }

    private String getTransactionId(ResultSet rs, boolean asRawValue) throws SQLException {
        if (asRawValue) {
            byte[] result = rs.getBytes(5);
            return result != null ? HexConverter.convertToHexString(result) : null;
        }
        return rs.getString(5);
    }

    private Instant getChangeTime(ResultSet rs) throws SQLException {
        Timestamp result = rs.getTimestamp(4, UTC_CALENDAR);
        return result != null ? result.toInstant() : null;
    }

    private Scn getScn(ResultSet rs) throws SQLException {
        String scn = rs.getString(1);
        return Strings.isNullOrEmpty(scn) ? Scn.NULL : Scn.valueOf(scn);
    }

    private String getSqlRedo(ResultSet rs) throws SQLException {
        int lobLimitCounter = 9;
        String redoSql = rs.getString(2);
        if (redoSql == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(redoSql);
        int csf = rs.getInt(6);
        while (csf == 1) {
            rs.next();
            if (lobLimitCounter-- == 0) {
                LOGGER.warn("LOB value was truncated due to the connector limitation of {} MB", (Object)40);
                break;
            }
            redoSql = rs.getString(2);
            result.append(redoSql);
            csf = rs.getInt(6);
        }
        return result.toString();
    }

    public String toString() {
        return "LogMinerEventRow{scn=" + this.scn + ", tableId='" + this.tableId + '\'' + ", tableName='" + this.tableName + '\'' + ", tablespaceName='" + this.tablespaceName + '\'' + ", eventType=" + (Object)((Object)this.eventType) + ", changeTime=" + this.changeTime + ", transactionId='" + this.transactionId + '\'' + ", operation='" + this.operation + '\'' + ", userName='" + this.userName + '\'' + ", rowId='" + this.rowId + '\'' + ", rollbackFlag=" + this.rollbackFlag + ", rsId=" + this.rsId + ", ssn=" + this.ssn + ", redoSql='" + this.redoSql + '\'' + '}';
    }
}

