/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.logwriter;

import io.debezium.DebeziumException;
import io.debezium.connector.oracle.OracleConnection;
import io.debezium.connector.oracle.Scn;
import io.debezium.connector.oracle.logminer.logwriter.LogWriterFlushStrategy;
import io.debezium.jdbc.JdbcConfiguration;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitLogWriterFlushStrategy
implements LogWriterFlushStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommitLogWriterFlushStrategy.class);
    private static final String CREATE_FLUSH_TABLE = "CREATE TABLE LOG_MINING_FLUSH(LAST_SCN NUMBER(19,0))";
    private static final String INSERT_FLUSH_TABLE = "INSERT INTO LOG_MINING_FLUSH VALUES (0)";
    private static final String UPDATE_FLUSH_TABLE = "UPDATE LOG_MINING_FLUSH SET LAST_SCN = ";
    private static final String DELETE_FLUSH_TABLE = "DELETE FROM LOG_MINING_FLUSH";
    private final OracleConnection connection;
    private final boolean closeConnectionOnClose;

    public CommitLogWriterFlushStrategy(OracleConnection connection) {
        this.connection = connection;
        this.closeConnectionOnClose = false;
        this.createFlushTableIfNotExists();
    }

    public CommitLogWriterFlushStrategy(JdbcConfiguration jdbcConfig) throws SQLException {
        this.connection = new OracleConnection(jdbcConfig, () -> this.getClass().getClassLoader());
        this.connection.setAutoCommit(false);
        this.closeConnectionOnClose = true;
        this.createFlushTableIfNotExists();
    }

    @Override
    public void close() {
        if (this.closeConnectionOnClose) {
            try {
                this.connection.close();
            }
            catch (SQLException e2) {
                throw new DebeziumException("Failed to close connection to host '" + this.getHost() + "'", e2);
            }
        }
    }

    @Override
    public String getHost() {
        return this.connection.config().getHostname();
    }

    @Override
    public void flush(Scn currentScn) {
        try {
            this.connection.execute(UPDATE_FLUSH_TABLE + currentScn);
        }
        catch (SQLException e2) {
            throw new DebeziumException("Failed to flush Oracle LogWriter (LGWR) buffers to disk", e2);
        }
    }

    private void createFlushTableIfNotExists() {
        try {
            if (!this.connection.isTableExists("LOG_MINING_FLUSH")) {
                this.connection.executeWithoutCommitting(CREATE_FLUSH_TABLE);
            }
            this.fixMultiRowDataBug();
            if (this.connection.isTableEmpty("LOG_MINING_FLUSH")) {
                this.connection.executeWithoutCommitting(INSERT_FLUSH_TABLE);
                this.connection.commit();
            }
        }
        catch (SQLException e2) {
            throw new DebeziumException("Failed to create flush table", e2);
        }
    }

    private void fixMultiRowDataBug() throws SQLException {
        if (this.connection.getRowCount("LOG_MINING_FLUSH") > 1L) {
            LOGGER.warn("DBZ-4118: The flush table, {}, has multiple rows and has been corrected.", (Object)"LOG_MINING_FLUSH");
            this.connection.executeWithoutCommitting(DELETE_FLUSH_TABLE);
            this.connection.executeWithoutCommitting(INSERT_FLUSH_TABLE);
            this.connection.commit();
        }
    }
}

