/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.parser;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.connector.oracle.logminer.LogMinerHelper;
import io.debezium.connector.oracle.logminer.parser.LogMinerDmlEntry;
import io.debezium.connector.oracle.logminer.parser.LogMinerDmlEntryImpl;
import io.debezium.connector.oracle.logminer.parser.ParserUtils;
import io.debezium.relational.Table;
import io.debezium.text.ParsingException;
import java.util.function.Consumer;

@NotThreadSafe
public class SelectLobParser {
    private static final String BEGIN = "BEGIN";
    private static final String SELECT = "select";
    private static final String FROM = "from";
    private static final String WHERE = "where";
    private static final String AND = "and";
    private static final String OR = "or";
    private static final String FOR_UPDATE = "for update";
    private static final String BLOB_LOCATOR = "loc_b";
    private static final String BLOB_BUFFER = "buf_b";
    private String columnName;
    private String schemaName;
    private String tableName;
    private boolean binary;
    private Object[] columnValues;

    public LogMinerDmlEntry parse(String sql, Table table) {
        this.reset(table);
        if (sql != null) {
            try {
                int start = sql.indexOf(BEGIN);
                if (start != -1 && sql.indexOf(SELECT, start = sql.indexOf(" ", start + 1) + 1) == start) {
                    start = sql.indexOf(" ", start) + 1;
                    start = this.parseQuotedValue(sql, start, s2 -> {
                        this.columnName = s2;
                    });
                    start = sql.indexOf(" ", start) + 1;
                    if (sql.indexOf(BLOB_LOCATOR, start = sql.indexOf(" ", start) + 1) == start || sql.indexOf(BLOB_BUFFER, start) == start) {
                        this.binary = true;
                    }
                    if (sql.indexOf(FROM, start = sql.indexOf(" ", start) + 1) == start) {
                        start = sql.indexOf(" ", start) + 1;
                        if (sql.indexOf(46, start = this.parseQuotedValue(sql, start, s2 -> {
                            this.schemaName = s2;
                        })) == start) {
                            ++start;
                            start = this.parseQuotedValue(sql, start, s2 -> {
                                this.tableName = s2;
                            });
                            if (sql.indexOf(WHERE, ++start) == start) {
                                this.parseWhere(sql, start += WHERE.length() + 1, table);
                            }
                        }
                    }
                    ParserUtils.setColumnUnavailableValues(this.columnValues, table);
                }
            }
            catch (Throwable t2) {
                throw new ParsingException(null, "Parsing failed for SEL_LOB_LOCATOR sql: '" + sql + "'", t2);
            }
        }
        LogMinerDmlEntry entry = LogMinerDmlEntryImpl.forLobLocator(this.columnValues);
        entry.setObjectOwner(this.schemaName);
        entry.setObjectName(this.tableName);
        return entry;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public boolean isBinary() {
        return this.binary;
    }

    private int parseQuotedValue(String sql, int index, Consumer<String> collector) {
        boolean inDoubleQuotes = false;
        int start = -1;
        int last = -1;
        for (int i2 = index; i2 < sql.length(); ++i2) {
            if (sql.charAt(i2) != '\"') continue;
            if (!inDoubleQuotes) {
                inDoubleQuotes = true;
                start = i2 + 1;
                continue;
            }
            inDoubleQuotes = false;
            last = i2;
            index = i2 + 1;
            break;
        }
        if (start != -1 && last != -1) {
            collector.accept(sql.substring(start, last));
        }
        return index;
    }

    private int parseColumnValue(String sql, int index, int columnIndex) {
        String value;
        boolean inSingleQuotes = false;
        int start = -1;
        int last = -1;
        int nested = 0;
        for (int i2 = index; i2 < sql.length(); ++i2) {
            char lookAhead;
            char c2 = sql.charAt(i2);
            char c3 = lookAhead = i2 + 1 < sql.length() ? sql.charAt(i2 + 1) : (char)'\u0000';
            if (i2 == index && c2 != '\'') {
                start = i2;
                continue;
            }
            if (c2 == '(' && !inSingleQuotes) {
                ++nested;
                continue;
            }
            if (c2 == ')' && !inSingleQuotes) {
                if (--nested != 0) continue;
                last = i2 + 1;
                index = i2 + 1;
                break;
            }
            if (c2 == '\'') {
                if (inSingleQuotes && lookAhead == '\'') {
                    ++i2;
                    continue;
                }
                if (inSingleQuotes) {
                    inSingleQuotes = false;
                    if (nested != 0) continue;
                    last = i2;
                    index = i2 + 1;
                    break;
                }
                inSingleQuotes = true;
                if (nested != 0) continue;
                start = i2 + 1;
                continue;
            }
            if (c2 != ' ' || inSingleQuotes || nested != 0) continue;
            last = i2;
            index = i2;
            break;
        }
        if (start != -1 && last != -1 && !(value = sql.substring(start, last)).equalsIgnoreCase("null")) {
            this.columnValues[columnIndex] = value;
        }
        return index;
    }

    private int parseWhere(String sql, int index, Table table) {
        for (int i2 = index; i2 < sql.length(); ++i2) {
            StringBuilder columnName = new StringBuilder();
            index = this.parseQuotedValue(sql, index, columnName::append);
            index = this.parseOperator(sql, index);
            index = this.parseColumnValue(sql, index, LogMinerHelper.getColumnIndexByName(columnName.toString(), table));
            if (sql.indexOf(AND, ++index) == index) {
                index += AND.length() + 1;
                continue;
            }
            if (sql.indexOf(OR, index) == index) {
                index += OR.length() + 1;
                continue;
            }
            if (sql.indexOf(FOR_UPDATE, index) == index) break;
        }
        return index;
    }

    private int parseOperator(String sql, int index) {
        boolean initialSpace = false;
        for (int i2 = index; i2 < sql.length(); ++i2) {
            char lookAhead;
            char c2 = sql.charAt(i2);
            char c3 = lookAhead = i2 + 1 < sql.length() ? sql.charAt(i2 + 1) : (char)'\u0000';
            if (initialSpace || c2 != ' ') {
                if (initialSpace && c2 == '=' && lookAhead == ' ') {
                    index += 3;
                    break;
                }
                if (initialSpace && c2 == 'I' && lookAhead == 'S') {
                    char lookAhead2;
                    char c4 = lookAhead2 = i2 + 2 < sql.length() ? sql.charAt(i2 + 2) : (char)'\u0000';
                    if (lookAhead2 == ' ') {
                        index += 4;
                        break;
                    }
                    throw new ParsingException(null, "Expected 'IS' at index " + i2 + ": " + sql);
                }
                throw new ParsingException(null, "Failed to parse operator at index " + i2 + ": " + sql);
            }
            initialSpace = true;
        }
        return index;
    }

    private void reset(Table table) {
        this.columnName = null;
        this.schemaName = null;
        this.tableName = null;
        this.binary = false;
        this.columnValues = new Object[table.columns().size()];
    }
}

