/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.logminer.processor.infinispan.marshalling;

import io.debezium.connector.oracle.OracleValueConverters;
import io.debezium.connector.oracle.logminer.parser.LogMinerDmlEntryImpl;
import java.util.Arrays;
import org.infinispan.protostream.annotations.ProtoAdapter;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;

@ProtoAdapter(value=LogMinerDmlEntryImpl.class)
public class LogMinerDmlEntryImplAdapter {
    private static final String NULL_VALUE_SENTINEL = "$$DBZ-NULL$$";
    private static final String UNAVAILABLE_VALUE_SENTINEL = "$$DBZ-UNAVAILABLE-VALUE$$";

    @ProtoFactory
    public LogMinerDmlEntryImpl factory(int operation, String[] newValues, String[] oldValues, String name, String owner) {
        return new LogMinerDmlEntryImpl(operation, this.stringArrayToObjectArray(newValues), this.stringArrayToObjectArray(oldValues), owner, name);
    }

    @ProtoField(number=1, required=true)
    public int getOperation(LogMinerDmlEntryImpl entry) {
        return entry.getEventType().getValue();
    }

    @ProtoField(number=2)
    public String[] getNewValues(LogMinerDmlEntryImpl entry) {
        return this.objectArrayToStringArray(entry.getNewValues());
    }

    @ProtoField(number=3)
    public String[] getOldValues(LogMinerDmlEntryImpl entry) {
        return this.objectArrayToStringArray(entry.getOldValues());
    }

    @ProtoField(number=4, required=true)
    public String getName(LogMinerDmlEntryImpl entry) {
        return entry.getObjectName();
    }

    @ProtoField(number=5, required=true)
    public String getOwner(LogMinerDmlEntryImpl entry) {
        return entry.getObjectOwner();
    }

    private String[] objectArrayToStringArray(Object[] values) {
        String[] results = new String[values.length];
        for (int i2 = 0; i2 < values.length; ++i2) {
            results[i2] = values[i2] == null ? NULL_VALUE_SENTINEL : (values[i2] == OracleValueConverters.UNAVAILABLE_VALUE ? UNAVAILABLE_VALUE_SENTINEL : (String)values[i2]);
        }
        return results;
    }

    private Object[] stringArrayToObjectArray(String[] values) {
        Object[] results = Arrays.copyOf(values, values.length, Object[].class);
        for (int i2 = 0; i2 < results.length; ++i2) {
            if (results[i2].equals(NULL_VALUE_SENTINEL)) {
                results[i2] = null;
                continue;
            }
            if (!results[i2].equals(UNAVAILABLE_VALUE_SENTINEL)) continue;
            results[i2] = OracleValueConverters.UNAVAILABLE_VALUE;
        }
        return results;
    }
}

