/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.transforms.outbox;

import io.debezium.DebeziumException;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.oracle.Module;
import io.debezium.transforms.outbox.EventRouterConfigDefinition;
import io.debezium.transforms.outbox.EventRouterConfigurationProvider;
import java.util.Map;

public class OracleEventRouterConfigurationProvider
implements EventRouterConfigurationProvider {
    private Configuration configuration;

    @Override
    public String getName() {
        return Module.name();
    }

    @Override
    public void configure(Map<String, ?> configMap) {
        this.configuration = Configuration.from(configMap);
    }

    @Override
    public String getFieldEventId() {
        return this.getStringWithUpperCaseDefault(EventRouterConfigDefinition.FIELD_EVENT_ID);
    }

    @Override
    public String getFieldEventKey() {
        return this.getStringWithUpperCaseDefault(EventRouterConfigDefinition.FIELD_EVENT_KEY);
    }

    @Override
    public String getFieldEventTimestamp() {
        return this.getStringWithUpperCaseDefault(EventRouterConfigDefinition.FIELD_EVENT_TIMESTAMP);
    }

    @Override
    public String getFieldPayload() {
        return this.getStringWithUpperCaseDefault(EventRouterConfigDefinition.FIELD_PAYLOAD);
    }

    @Override
    public String getFieldPayloadId() {
        return this.getStringWithUpperCaseDefault(EventRouterConfigDefinition.FIELD_PAYLOAD_ID);
    }

    @Override
    public String getRouteByField() {
        return this.getStringWithUpperCaseDefault(EventRouterConfigDefinition.ROUTE_BY_FIELD);
    }

    private String getStringWithUpperCaseDefault(Field field) {
        if (this.configuration == null) {
            throw new DebeziumException("Event router configuration for Oracle has not yet been configured");
        }
        if (this.configuration.hasKey(field.name())) {
            return this.configuration.getString(field);
        }
        if (field.defaultValue() != null) {
            return field.defaultValueAsString().toUpperCase();
        }
        return null;
    }
}

