/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.metrics;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Sanitizer;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.ConnectException;
import io.debezium.annotation.ThreadSafe;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.util.Clock;
import io.debezium.util.Collect;
import io.debezium.util.Metronome;
import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.util.Map;
import java.util.stream.Collectors;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class Metrics {
    private static final Logger LOGGER = LoggerFactory.getLogger(Metrics.class);
    private static final int REGISTRATION_RETRIES = 12;
    private static final Duration REGISTRATION_RETRY_DELAY = Duration.ofSeconds(5L);
    private final ObjectName name;
    private volatile boolean registered = false;

    protected Metrics(CdcSourceTaskContext taskContext, String contextName) {
        this.name = this.metricName(taskContext.getConnectorType(), taskContext.getConnectorName(), contextName);
    }

    protected Metrics(CdcSourceTaskContext taskContext, Map<String, String> tags) {
        this.name = this.metricName(taskContext.getConnectorType(), tags);
    }

    protected Metrics(CommonConnectorConfig connectorConfig, String contextName, boolean multiPartitionMode) {
        String connectorType = connectorConfig.getContextName();
        String connectorName = connectorConfig.getLogicalName();
        this.name = multiPartitionMode ? this.metricName(connectorType, Collect.linkMapOf("server", connectorName, "task", connectorConfig.getTaskId(), "context", contextName)) : this.metricName(connectorType, connectorName, contextName);
    }

    public synchronized void register() {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            if (mBeanServer == null) {
                LOGGER.info("JMX not supported, bean '{}' not registered", (Object)this.name);
                return;
            }
            for (int attempt = 1; attempt <= 12; ++attempt) {
                try {
                    mBeanServer.registerMBean(this, this.name);
                    break;
                }
                catch (InstanceAlreadyExistsException e2) {
                    if (attempt < 12) {
                        LOGGER.warn("Unable to register metrics as an old set with the same name exists, retrying in {} (attempt {} out of {})", new Object[]{REGISTRATION_RETRY_DELAY, attempt, 12});
                        Metronome metronome = Metronome.sleeper(REGISTRATION_RETRY_DELAY, Clock.system());
                        metronome.pause();
                        continue;
                    }
                    LOGGER.error("Failed to register metrics MBean, metrics will not be available");
                    continue;
                }
            }
            this.registered = true;
        }
        catch (InterruptedException | JMException e3) {
            throw new RuntimeException("Unable to register the MBean '" + this.name + "'", e3);
        }
    }

    public synchronized void unregister() {
        if (this.name != null && this.registered) {
            try {
                MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
                if (mBeanServer == null) {
                    LOGGER.debug("JMX not supported, bean '{}' not registered", (Object)this.name);
                    return;
                }
                try {
                    mBeanServer.unregisterMBean(this.name);
                }
                catch (InstanceNotFoundException e2) {
                    LOGGER.info("Unable to unregister metrics MBean '{}' as it was not found", (Object)this.name);
                }
                this.registered = false;
            }
            catch (JMException e3) {
                throw new RuntimeException("Unable to unregister the MBean '" + this.name + "'", e3);
            }
        }
    }

    protected ObjectName metricName(String connectorType, String connectorName, String contextName) {
        return this.metricName(connectorType, Collect.linkMapOf("context", contextName, "server", connectorName));
    }

    protected ObjectName metricName(String connectorType, Map<String, String> tags) {
        String metricName = "debezium." + connectorType.toLowerCase() + ":type=connector-metrics," + tags.entrySet().stream().map(e2 -> (String)e2.getKey() + "=" + Sanitizer.jmxSanitize((String)e2.getValue())).collect(Collectors.joining(","));
        try {
            return new ObjectName(metricName);
        }
        catch (MalformedObjectNameException e3) {
            throw new ConnectException("Invalid metric name '" + metricName + "'");
        }
    }
}

