/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.SchemaAndValue;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.header.ConnectHeaders;
import io.debezium.data.Envelope;
import io.debezium.pipeline.AbstractChangeRecordEmitter;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.TableSchema;
import io.debezium.schema.DataCollectionSchema;
import io.debezium.util.Clock;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RelationalChangeRecordEmitter<P extends Partition>
extends AbstractChangeRecordEmitter<P, TableSchema> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RelationalChangeRecordEmitter.class);
    public static final String PK_UPDATE_OLDKEY_FIELD = "__debezium.oldkey";
    public static final String PK_UPDATE_NEWKEY_FIELD = "__debezium.newkey";
    private final Map<String, SchemaAndValue> staticHeaders = new HashMap<String, SchemaAndValue>();

    public RelationalChangeRecordEmitter(P partition, OffsetContext offsetContext, Clock clock) {
        super(partition, offsetContext, clock);
    }

    @Override
    public void emitChangeRecords(DataCollectionSchema schema, ChangeRecordEmitter.Receiver<P> receiver) throws InterruptedException {
        TableSchema tableSchema = (TableSchema)schema;
        Envelope.Operation operation = this.getOperation();
        switch (operation) {
            case CREATE: {
                this.emitCreateRecord(receiver, tableSchema);
                break;
            }
            case READ: {
                this.emitReadRecord(receiver, tableSchema);
                break;
            }
            case UPDATE: {
                this.emitUpdateRecord(receiver, tableSchema);
                break;
            }
            case DELETE: {
                this.emitDeleteRecord(receiver, tableSchema);
                break;
            }
            case TRUNCATE: {
                this.emitTruncateRecord(receiver, tableSchema);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation: " + (Object)((Object)operation));
            }
        }
    }

    public void addStaticHeader(String key, SchemaAndValue value) {
        this.staticHeaders.put(key, value);
    }

    @Override
    protected void emitCreateRecord(ChangeRecordEmitter.Receiver<P> receiver, TableSchema tableSchema) throws InterruptedException {
        Object[] newColumnValues = this.getNewColumnValues();
        Struct newKey = tableSchema.keyFromColumnData(newColumnValues);
        Struct newValue = tableSchema.valueFromColumnData(newColumnValues);
        Struct envelope = tableSchema.getEnvelopeSchema().create(newValue, this.getOffset().getSourceInfo(), this.getClock().currentTimeAsInstant());
        if (this.skipEmptyMessages() && (newColumnValues == null || newColumnValues.length == 0)) {
            LOGGER.warn("no new values found for table '{}' from create message at '{}'; skipping record", (Object)tableSchema, (Object)this.getOffset().getSourceInfo());
            return;
        }
        receiver.changeRecord(this.getPartition(), tableSchema, Envelope.Operation.CREATE, newKey, envelope, this.getOffset(), this.getStaticConnectHeaders());
    }

    @Override
    protected void emitReadRecord(ChangeRecordEmitter.Receiver<P> receiver, TableSchema tableSchema) throws InterruptedException {
        Object[] newColumnValues = this.getNewColumnValues();
        Struct newKey = tableSchema.keyFromColumnData(newColumnValues);
        Struct newValue = tableSchema.valueFromColumnData(newColumnValues);
        Struct envelope = tableSchema.getEnvelopeSchema().read(newValue, this.getOffset().getSourceInfo(), this.getClock().currentTimeAsInstant());
        receiver.changeRecord(this.getPartition(), tableSchema, Envelope.Operation.READ, newKey, envelope, this.getOffset(), this.getStaticConnectHeaders());
    }

    @Override
    protected void emitUpdateRecord(ChangeRecordEmitter.Receiver<P> receiver, TableSchema tableSchema) throws InterruptedException {
        Object[] oldColumnValues = this.getOldColumnValues();
        Object[] newColumnValues = this.getNewColumnValues();
        Struct oldKey = tableSchema.keyFromColumnData(oldColumnValues);
        Struct newKey = tableSchema.keyFromColumnData(newColumnValues);
        Struct newValue = tableSchema.valueFromColumnData(newColumnValues);
        Struct oldValue = tableSchema.valueFromColumnData(oldColumnValues);
        if (this.skipEmptyMessages() && (newColumnValues == null || newColumnValues.length == 0)) {
            LOGGER.warn("no new values found for table '{}' from update message at '{}'; skipping record", (Object)tableSchema, (Object)this.getOffset().getSourceInfo());
            return;
        }
        if (oldKey == null || Objects.equals(oldKey, newKey)) {
            Struct envelope = tableSchema.getEnvelopeSchema().update(oldValue, newValue, this.getOffset().getSourceInfo(), this.getClock().currentTimeAsInstant());
            receiver.changeRecord(this.getPartition(), tableSchema, Envelope.Operation.UPDATE, newKey, envelope, this.getOffset(), this.getStaticConnectHeaders());
        } else {
            this.emitUpdateAsPrimaryKeyChangeRecord(receiver, tableSchema, oldKey, newKey, oldValue, newValue);
        }
    }

    @Override
    protected void emitDeleteRecord(ChangeRecordEmitter.Receiver<P> receiver, TableSchema tableSchema) throws InterruptedException {
        Object[] oldColumnValues = this.getOldColumnValues();
        Struct oldKey = tableSchema.keyFromColumnData(oldColumnValues);
        Struct oldValue = tableSchema.valueFromColumnData(oldColumnValues);
        if (this.skipEmptyMessages() && (oldColumnValues == null || oldColumnValues.length == 0)) {
            LOGGER.warn("no old values found for table '{}' from delete message at '{}'; skipping record", (Object)tableSchema, (Object)this.getOffset().getSourceInfo());
            return;
        }
        Struct envelope = tableSchema.getEnvelopeSchema().delete(oldValue, this.getOffset().getSourceInfo(), this.getClock().currentTimeAsInstant());
        receiver.changeRecord(this.getPartition(), tableSchema, Envelope.Operation.DELETE, oldKey, envelope, this.getOffset(), this.getStaticConnectHeaders());
    }

    protected void emitTruncateRecord(ChangeRecordEmitter.Receiver<P> receiver, TableSchema schema) throws InterruptedException {
        throw new UnsupportedOperationException("TRUNCATE not supported");
    }

    protected abstract Object[] getOldColumnValues();

    protected abstract Object[] getNewColumnValues();

    protected boolean skipEmptyMessages() {
        return false;
    }

    protected void emitUpdateAsPrimaryKeyChangeRecord(ChangeRecordEmitter.Receiver<P> receiver, TableSchema tableSchema, Struct oldKey, Struct newKey, Struct oldValue, Struct newValue) throws InterruptedException {
        ConnectHeaders headers = this.getStaticConnectHeaders();
        headers.add(PK_UPDATE_NEWKEY_FIELD, newKey, tableSchema.keySchema());
        Struct envelope = tableSchema.getEnvelopeSchema().delete(oldValue, this.getOffset().getSourceInfo(), this.getClock().currentTimeAsInstant());
        receiver.changeRecord(this.getPartition(), tableSchema, Envelope.Operation.DELETE, oldKey, envelope, this.getOffset(), headers);
        headers = this.getStaticConnectHeaders();
        headers.add(PK_UPDATE_OLDKEY_FIELD, oldKey, tableSchema.keySchema());
        envelope = tableSchema.getEnvelopeSchema().create(newValue, this.getOffset().getSourceInfo(), this.getClock().currentTimeAsInstant());
        receiver.changeRecord(this.getPartition(), tableSchema, Envelope.Operation.CREATE, newKey, envelope, this.getOffset(), headers);
    }

    private ConnectHeaders getStaticConnectHeaders() {
        ConnectHeaders headers = new ConnectHeaders();
        this.staticHeaders.forEach(headers::add);
        return headers;
    }
}

