/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.text;

import io.debezium.annotation.Immutable;
import java.text.StringCharacterIterator;

@Immutable
public class XmlCharacters {
    private static final int NUMBER_OF_CHARACTERS = 65536;
    private static final char[] MASKS = new char[65536];
    private static final int VALID_CHARACTER = 1;
    private static final int CONTENT_CHARACTER = 2;
    private static final int SPACE_CHARACTER = 4;
    private static final int NAME_START_CHARACTER = 8;
    private static final int NAME_CHARACTER = 16;
    private static final int NCNAME_START_CHARACTER = 32;
    private static final int NCNAME_CHARACTER = 64;
    private static final int PUBID_CHARACTER = 128;

    private XmlCharacters() {
    }

    public static boolean isValidNameStart(int c2) {
        return c2 < 65536 && (MASKS[c2] & 8) != 0;
    }

    public static boolean isValidNcNameStart(int c2) {
        return c2 < 65536 && (MASKS[c2] & 0x20) != 0;
    }

    public static boolean isValidName(int c2) {
        return c2 < 65536 && (MASKS[c2] & 0x10) != 0;
    }

    public static boolean isValidNcName(int c2) {
        return c2 < 65536 && (MASKS[c2] & 0x40) != 0;
    }

    public static boolean isValidPubid(int c2) {
        return c2 < 65536 && (MASKS[c2] & 0x80) != 0;
    }

    public static boolean isValid(int c2) {
        return c2 < 65536 && (MASKS[c2] & '\u0001') != 0 || 65536 <= c2 && c2 <= 0x10FFFF;
    }

    public static boolean isValidContent(int c2) {
        return c2 < 65536 && (MASKS[c2] & 2) != 0 || 65536 <= c2 && c2 <= 0x10FFFF;
    }

    public static boolean isValidSpace(int c2) {
        return c2 <= 32 && (MASKS[c2] & 4) != 0;
    }

    public static boolean isValidName(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        StringCharacterIterator iter = new StringCharacterIterator(name);
        char c2 = iter.first();
        if (!XmlCharacters.isValidNameStart(c2)) {
            return false;
        }
        while (c2 != '\uffff') {
            if (!XmlCharacters.isValidName(c2)) {
                return false;
            }
            c2 = iter.next();
        }
        return true;
    }

    public static boolean isValidNcName(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        StringCharacterIterator iter = new StringCharacterIterator(name);
        char c2 = iter.first();
        if (!XmlCharacters.isValidNcNameStart(c2)) {
            return false;
        }
        while (c2 != '\uffff') {
            if (!XmlCharacters.isValidNcName(c2)) {
                return false;
            }
            c2 = iter.next();
        }
        return true;
    }

    static {
        MASKS[9] = (char)(MASKS[9] | 3);
        MASKS[10] = (char)(MASKS[10] | 3);
        MASKS[13] = (char)(MASKS[13] | 3);
        int i2 = 32;
        while (i2 <= 55295) {
            int n2 = i2++;
            MASKS[n2] = (char)(MASKS[n2] | 3);
        }
        i2 = 57344;
        while (i2 <= 65533) {
            int n3 = i2++;
            MASKS[n3] = (char)(MASKS[n3] | 3);
        }
        MASKS[60] = (char)(MASKS[60] & 0xFFFFFFFD);
        MASKS[38] = (char)(MASKS[38] & 0xFFFFFFFD);
        MASKS[10] = (char)(MASKS[10] & 0xFFFFFFFD);
        MASKS[13] = (char)(MASKS[13] & 0xFFFFFFFD);
        MASKS[93] = (char)(MASKS[93] & 0xFFFFFFFD);
        MASKS[32] = (char)(MASKS[32] | 4);
        MASKS[9] = (char)(MASKS[9] | 4);
        MASKS[10] = (char)(MASKS[10] | 4);
        MASKS[13] = (char)(MASKS[13] | 4);
        int nameStartMask = 120;
        MASKS[58] = (char)(MASKS[58] | nameStartMask);
        MASKS[95] = (char)(MASKS[95] | nameStartMask);
        int i3 = 65;
        while (i3 <= 90) {
            int n4 = i3++;
            MASKS[n4] = (char)(MASKS[n4] | nameStartMask);
        }
        i3 = 97;
        while (i3 <= 122) {
            int n5 = i3++;
            MASKS[n5] = (char)(MASKS[n5] | nameStartMask);
        }
        i3 = 192;
        while (i3 <= 214) {
            int n6 = i3++;
            MASKS[n6] = (char)(MASKS[n6] | nameStartMask);
        }
        i3 = 216;
        while (i3 <= 246) {
            int n7 = i3++;
            MASKS[n7] = (char)(MASKS[n7] | nameStartMask);
        }
        i3 = 248;
        while (i3 <= 767) {
            int n8 = i3++;
            MASKS[n8] = (char)(MASKS[n8] | nameStartMask);
        }
        i3 = 880;
        while (i3 <= 893) {
            int n9 = i3++;
            MASKS[n9] = (char)(MASKS[n9] | nameStartMask);
        }
        i3 = 895;
        while (i3 <= 8191) {
            int n10 = i3++;
            MASKS[n10] = (char)(MASKS[n10] | nameStartMask);
        }
        i3 = 8204;
        while (i3 <= 8205) {
            int n11 = i3++;
            MASKS[n11] = (char)(MASKS[n11] | nameStartMask);
        }
        i3 = 8304;
        while (i3 <= 8591) {
            int n12 = i3++;
            MASKS[n12] = (char)(MASKS[n12] | nameStartMask);
        }
        i3 = 11264;
        while (i3 <= 12271) {
            int n13 = i3++;
            MASKS[n13] = (char)(MASKS[n13] | nameStartMask);
        }
        i3 = 12289;
        while (i3 <= 55295) {
            int n14 = i3++;
            MASKS[n14] = (char)(MASKS[n14] | nameStartMask);
        }
        i3 = 63744;
        while (i3 <= 64975) {
            int n15 = i3++;
            MASKS[n15] = (char)(MASKS[n15] | nameStartMask);
        }
        i3 = 65008;
        while (i3 <= 65533) {
            int n16 = i3++;
            MASKS[n16] = (char)(MASKS[n16] | nameStartMask);
        }
        int nameMask = 80;
        MASKS[45] = (char)(MASKS[45] | nameMask);
        MASKS[46] = (char)(MASKS[46] | nameMask);
        MASKS[183] = (char)(MASKS[183] | nameMask);
        int i4 = 48;
        while (i4 <= 57) {
            int n17 = i4++;
            MASKS[n17] = (char)(MASKS[n17] | nameMask);
        }
        i4 = 768;
        while (i4 <= 879) {
            int n18 = i4++;
            MASKS[n18] = (char)(MASKS[n18] | nameStartMask);
        }
        i4 = 8255;
        while (i4 <= 8256) {
            int n19 = i4++;
            MASKS[n19] = (char)(MASKS[n19] | nameStartMask);
        }
        MASKS[58] = (char)(MASKS[58] & 0xFFFFFF9F);
        MASKS[32] = (char)(MASKS[32] | 0x80);
        MASKS[10] = (char)(MASKS[10] | 0x80);
        MASKS[13] = (char)(MASKS[13] | 0x80);
        i4 = 65;
        while (i4 <= 90) {
            int n20 = i4++;
            MASKS[n20] = (char)(MASKS[n20] | 0x80);
        }
        i4 = 97;
        while (i4 <= 122) {
            int n21 = i4++;
            MASKS[n21] = (char)(MASKS[n21] | 0x80);
        }
        i4 = 48;
        while (i4 <= 57) {
            int n22 = i4++;
            MASKS[n22] = (char)(MASKS[n22] | 0x80);
        }
        MASKS[45] = (char)(MASKS[45] | 0x80);
        MASKS[39] = (char)(MASKS[39] | 0x80);
        MASKS[40] = (char)(MASKS[40] | 0x80);
        MASKS[41] = (char)(MASKS[41] | 0x80);
        MASKS[43] = (char)(MASKS[43] | 0x80);
        MASKS[44] = (char)(MASKS[44] | 0x80);
        MASKS[46] = (char)(MASKS[46] | 0x80);
        MASKS[47] = (char)(MASKS[47] | 0x80);
        MASKS[58] = (char)(MASKS[58] | 0x80);
        MASKS[61] = (char)(MASKS[61] | 0x80);
        MASKS[63] = (char)(MASKS[63] | 0x80);
        MASKS[59] = (char)(MASKS[59] | 0x80);
        MASKS[33] = (char)(MASKS[33] | 0x80);
        MASKS[42] = (char)(MASKS[42] | 0x80);
        MASKS[35] = (char)(MASKS[35] | 0x80);
        MASKS[64] = (char)(MASKS[64] | 0x80);
        MASKS[36] = (char)(MASKS[36] | 0x80);
        MASKS[95] = (char)(MASKS[95] | 0x80);
        MASKS[37] = (char)(MASKS[37] | 0x80);
    }
}

