/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.util;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.ConnectException;
import io.debezium.annotation.ThreadSafe;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
@ThreadSafe
public interface SchemaNameAdjuster {
    public static final Logger LOGGER = LoggerFactory.getLogger(SchemaNameAdjuster.class);
    public static final SchemaNameAdjuster NO_OP = proposedName -> proposedName;
    public static final SchemaNameAdjuster AVRO = SchemaNameAdjuster.create();

    public String adjust(String var1);

    public static SchemaNameAdjuster avroAdjuster() {
        return AVRO;
    }

    public static SchemaNameAdjuster create() {
        return SchemaNameAdjuster.create((original, replacement, conflict) -> {
            String msg = "The Kafka Connect schema name '" + original + "' is not a valid Avro schema name and its replacement '" + replacement + "' conflicts with another different schema '" + conflict + "'";
            throw new ConnectException(msg);
        });
    }

    public static SchemaNameAdjuster create(ReplacementOccurred uponConflict) {
        ReplacementOccurred handler = (original, replacement, conflictsWith) -> {
            if (conflictsWith != null) {
                LOGGER.error("The Kafka Connect schema name '{}' is not a valid Avro schema name and its replacement '{}' conflicts with another different schema '{}'", new Object[]{original, replacement, conflictsWith});
                if (uponConflict != null) {
                    uponConflict.accept(original, replacement, conflictsWith);
                }
            } else {
                LOGGER.warn("The Kafka Connect schema name '{}' is not a valid Avro schema name, so replacing with '{}'", (Object)original, (Object)replacement);
            }
        };
        return SchemaNameAdjuster.create("_", handler.firstTimeOnly());
    }

    public static SchemaNameAdjuster create(char replacement, ReplacementOccurred uponReplacement) {
        String replacementStr = "" + replacement;
        return original -> SchemaNameAdjuster.validFullname(original, c2 -> replacementStr, uponReplacement);
    }

    public static SchemaNameAdjuster create(String replacement, ReplacementOccurred uponReplacement) {
        return original -> SchemaNameAdjuster.validFullname(original, c2 -> replacement, uponReplacement);
    }

    public static SchemaNameAdjuster create(ReplacementFunction function, ReplacementOccurred uponReplacement) {
        return original -> SchemaNameAdjuster.validFullname(original, function, uponReplacement);
    }

    public static boolean isValidFullname(String fullname) {
        if (fullname.length() == 0) {
            return true;
        }
        char c2 = fullname.charAt(0);
        if (!SchemaNameAdjuster.isValidFullnameFirstCharacter(c2)) {
            return false;
        }
        for (int i2 = 1; i2 != fullname.length(); ++i2) {
            c2 = fullname.charAt(i2);
            if (SchemaNameAdjuster.isValidFullnameNonFirstCharacter(c2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidFullnameFirstCharacter(char c2) {
        return c2 == '_' || c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z';
    }

    public static boolean isValidFullnameNonFirstCharacter(char c2) {
        return c2 == '.' || SchemaNameAdjuster.isValidFullnameFirstCharacter(c2) || c2 >= '0' && c2 <= '9';
    }

    public static String validFullname(String proposedName) {
        return SchemaNameAdjuster.validFullname(proposedName, "_");
    }

    public static String validFullname(String proposedName, String replacement) {
        return SchemaNameAdjuster.validFullname(proposedName, (char c2) -> replacement);
    }

    public static String validFullname(String proposedName, ReplacementFunction replacement) {
        return SchemaNameAdjuster.validFullname(proposedName, replacement, null);
    }

    public static String validFullname(String proposedName, ReplacementFunction replacement, ReplacementOccurred uponReplacement) {
        if (proposedName.length() == 0) {
            return proposedName;
        }
        StringBuilder sb = new StringBuilder();
        char c2 = proposedName.charAt(0);
        boolean changed = false;
        if (SchemaNameAdjuster.isValidFullnameFirstCharacter(c2)) {
            sb.append(c2);
        } else {
            sb.append(replacement.replace(c2));
            changed = true;
        }
        for (int i2 = 1; i2 != proposedName.length(); ++i2) {
            c2 = proposedName.charAt(i2);
            if (SchemaNameAdjuster.isValidFullnameNonFirstCharacter(c2)) {
                sb.append(c2);
                continue;
            }
            sb.append(replacement.replace(c2));
            changed = true;
        }
        if (!changed) {
            return proposedName;
        }
        String result = sb.toString();
        if (uponReplacement != null) {
            uponReplacement.accept(proposedName, result, null);
        }
        return result;
    }

    @FunctionalInterface
    @ThreadSafe
    public static interface ReplacementOccurred {
        public void accept(String var1, String var2, String var3);

        default public ReplacementOccurred firstTimeOnly() {
            ReplacementOccurred delegate = this;
            Set alreadySeen = Collections.newSetFromMap(new ConcurrentHashMap());
            ConcurrentHashMap originalByReplacement = new ConcurrentHashMap();
            return (original, replacement, conflictsWith) -> {
                if (alreadySeen.add(original)) {
                    String replacementsOriginal = originalByReplacement.put(replacement, original);
                    if (replacementsOriginal == null || original.equals(replacementsOriginal)) {
                        delegate.accept(original, replacement, null);
                    } else {
                        delegate.accept(original, replacement, replacementsOriginal);
                    }
                }
            };
        }

        default public ReplacementOccurred andThen(ReplacementOccurred next) {
            if (next == null) {
                return this;
            }
            return (original, replacement, conflictsWith) -> {
                this.accept(original, replacement, conflictsWith);
                next.accept(original, replacement, conflictsWith);
            };
        }
    }

    @FunctionalInterface
    @ThreadSafe
    public static interface ReplacementFunction {
        public String replace(char var1);
    }
}

