/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ons.CreatePermission;
import oracle.ons.Message;
import oracle.ons.NoServersAvailable;
import oracle.ons.Node;
import oracle.ons.NodeAddress;
import oracle.ons.Notification;
import oracle.ons.NotificationException;
import oracle.ons.NotificationManager;
import oracle.ons.ONSConfiguration;
import oracle.ons.ONSException;
import oracle.ons.PublishPermission;
import oracle.ons.Publisher;
import oracle.ons.Subscriber;
import oracle.ons.SubscriptionProxy;

public class NotificationNetwork {
    protected ONSConfiguration config;
    protected NotificationManager master;
    protected volatile int messageReceived = 0;
    protected volatile int messagePublished = 0;
    protected volatile int messageDropped = 0;
    private static final int STATE_NETWORK_DOWN = 0;
    private static final int STATE_STARTING_UP = 1;
    private static final int STATE_NETWORK_UP = 2;
    private static final long FAILOVER_COOLDOWN = 3000L;
    private AtomicInteger state = new AtomicInteger(0);
    private final AtomicInteger usageCount = new AtomicInteger(0);
    protected Logger logger;
    private final Semaphore networkStatusLock = new Semaphore(0, false);
    private final List<ONSConfiguration.NodeList> nodeLists = new ArrayList<ONSConfiguration.NodeList>();
    private final Set<Node> nodes = new HashSet<Node>();
    private RefreshConnectionsTask localRefreshTask = new RefreshConnectionsTask();
    private final Map<String, SubscriptionProxy> networkSubscriptions = new HashMap<String, SubscriptionProxy>();

    Iterable<? extends Node> getNodes() {
        return this.nodes;
    }

    NotificationNetwork(ONSConfiguration configuration) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new CreatePermission("ONSUser"));
        }
        this.master = NotificationManager.getNotificationManager();
        this.config = configuration;
        this.logger = this.master.logger;
        this.nodeLists.addAll(configuration.getTopologies());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilOnline(long timeout, boolean throwOnTimeout) throws ONSException, InterruptedException {
        if (this.networkStatusLock.availablePermits() > 0) {
            NotificationNetwork notificationNetwork = this;
            synchronized (notificationNetwork) {
                return !this.nodes.isEmpty();
            }
        }
        if (this.networkStatusLock.tryAcquire(timeout, TimeUnit.MILLISECONDS)) {
            this.networkStatusLock.release();
        } else {
            this.state.compareAndSet(1, 0);
            if (throwOnTimeout) {
                throw new NoServersAvailable("Subscription time out");
            }
        }
        NotificationNetwork notificationNetwork = this;
        synchronized (notificationNetwork) {
            return !this.nodes.isEmpty();
        }
    }

    public boolean waitUntilOnline() throws ONSException, InterruptedException {
        return this.waitUntilOnline(this.config.getSocketTimeout(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ping() {
        NotificationNetwork notificationNetwork = this;
        synchronized (notificationNetwork) {
            for (Node n2 : this.nodes) {
                n2.ping(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ping(long timeout) throws InterruptedException {
        LinkedBlockingQueue<Node> answers = new LinkedBlockingQueue<Node>();
        this.lazyDemand();
        if (!this.waitUntilOnline(timeout, false)) {
            return false;
        }
        HashSet<Node> activeNodeSet = new HashSet<Node>();
        NotificationNetwork notificationNetwork = this;
        synchronized (notificationNetwork) {
            for (Node n2 : this.nodes) {
                if (!activeNodeSet.add(n2)) continue;
                n2.ping(answers);
            }
        }
        while (!activeNodeSet.isEmpty()) {
            Node n3 = (Node)answers.poll(timeout, TimeUnit.MILLISECONDS);
            if (n3 == null) {
                return false;
            }
            activeNodeSet.remove(n3);
        }
        return true;
    }

    protected void checkPublisherPerimission() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PublishPermission("ONSUser"));
        }
    }

    public synchronized boolean publish(Message message) {
        this.checkPublisherPerimission();
        if (this.nodes.isEmpty()) {
            throw new NotificationException("Network is down");
        }
        Iterator<Node> i$ = this.nodes.iterator();
        if (i$.hasNext()) {
            Node n2 = i$.next();
            n2.publish(message);
            return true;
        }
        return false;
    }

    public synchronized boolean publishNotification(Notification notification, Publisher author) {
        this.checkPublisherPerimission();
        if (this.nodes.isEmpty()) {
            throw new NotificationException("Network is down");
        }
        Message v4 = null;
        Message v5 = null;
        Iterator<Node> i$ = this.nodes.iterator();
        if (i$.hasNext()) {
            Node n2 = i$.next();
            try {
                if (n2.getProtocolVersion() >= 5) {
                    n2.publish(v5 != null ? v5 : (v5 = notification.toMessage(author)));
                } else {
                    n2.publish(v4 != null ? v4 : (v4 = notification.toMessageVersion4(author)));
                }
                return true;
            }
            catch (IOException e2) {
                throw new ONSException("Notification publish failed for client internal error");
            }
        }
        return false;
    }

    protected void scanExpandNodeList(Collection<NodeAddress> nodeListIn, Collection<NodeAddress> nodeListOut) {
        if (this.config.ignoreScan) {
            nodeListOut.addAll(nodeListIn);
        } else {
            for (NodeAddress hp : nodeListIn) {
                try {
                    for (InetAddress address : InetAddress.getAllByName(hp.hostname)) {
                        NodeAddress nhp = new NodeAddress(address.getHostAddress(), hp.port);
                        this.logger.finest(String.format("%s resolves to %s", hp.toString(), nhp.toString()));
                        nodeListOut.add(nhp);
                    }
                }
                catch (UnknownHostException e2) {
                    NotificationManager.getNotificationManager().logger.warning(String.format("ONS failed to resolve host : %s", hp.toString()));
                }
            }
        }
    }

    synchronized void onNodeUp(Node node) {
        if (node.isConnected()) {
            for (SubscriptionProxy proxy : this.networkSubscriptions.values()) {
                this.master.getWorkloadManager().schedule(new RegisterSubscriptionTask(node, proxy));
            }
            this.nodes.add(node);
            this.state.set(2);
            this.networkStatusLock.release();
        }
    }

    synchronized void onNodeDown(Node node) {
        if (this.nodes.contains(node)) {
            this.nodes.remove(node);
            if (this.nodes.isEmpty()) {
                this.state.compareAndSet(2, 1);
            }
            if (!this.networkStatusLock.tryAcquire()) {
                this.logger.severe("Node consistency broken");
            }
        }
        if (this.state.get() != 0) {
            this.master.getWorkloadManager().schedule(this.localRefreshTask);
        }
    }

    private synchronized void shutdown() {
        this.logger.log(Level.FINE, "ONS network real shutdown");
        for (Node n2 : this.nodes) {
            n2.unregister(this);
            this.networkStatusLock.tryAcquire();
        }
        this.nodes.clear();
        this.state.set(0);
    }

    void release() {
        if (this.usageCount.decrementAndGet() == 0) {
            this.shutdown();
            this.master.onNetworkDown(this);
        }
        this.logger.log(Level.FINE, "ONS network down request : " + this.usageCount.toString());
    }

    NotificationNetwork demand() {
        this.logger.log(Level.FINE, "ONS network up request : " + this.usageCount.toString());
        if (this.usageCount.getAndIncrement() == 0) {
            this.startup();
        }
        return this;
    }

    public NotificationNetwork lazyDemand() {
        this.startup();
        return this;
    }

    public void releaseIfUnused() {
        if (this.usageCount.get() == 0) {
            this.shutdown();
            this.master.onNetworkDown(this);
        }
    }

    private void startup() {
        if (this.state.compareAndSet(0, 1)) {
            this.master.onNetworkUp(this);
            this.master.getWorkloadManager().schedule(this.localRefreshTask);
        }
    }

    synchronized void registerSubscriber(Subscriber subscriber) {
        String key = subscriber.getSubscriptionKey();
        SubscriptionProxy proxy = this.networkSubscriptions.get(key);
        if (proxy == null) {
            proxy = new SubscriptionProxy(this, subscriber);
            this.networkSubscriptions.put(key, proxy);
            for (Node node : this.getNodes()) {
                this.master.getWorkloadManager().schedule(new RegisterSubscriptionTask(node, proxy));
            }
        } else {
            proxy.add(subscriber);
        }
    }

    synchronized void unregisterSubscriber(Subscriber subscriber) {
        String key = subscriber.getSubscriptionKey();
        SubscriptionProxy proxy = this.networkSubscriptions.get(key);
        proxy.remove(subscriber);
        if (proxy.isEmpty()) {
            this.networkSubscriptions.remove(key);
            for (Node node : this.getNodes()) {
                this.master.getWorkloadManager().schedule(new RemoveSubscriptionTask(node, proxy));
            }
        }
    }

    private class RemoveSubscriptionTask
    implements Runnable {
        Node node;
        SubscriptionProxy proxy;

        private RemoveSubscriptionTask(Node node, SubscriptionProxy proxy) {
            this.node = node;
            this.proxy = proxy;
        }

        @Override
        public void run() {
            try {
                this.node.removeSubscriber(this.proxy);
            }
            catch (Exception e2) {
                NotificationNetwork.this.master.logger.finest(e2.getLocalizedMessage());
            }
        }
    }

    private class RegisterSubscriptionTask
    implements Runnable {
        Node node;
        SubscriptionProxy proxy;

        private RegisterSubscriptionTask(Node node, SubscriptionProxy proxy) {
            this.node = node;
            this.proxy = proxy;
        }

        @Override
        public void run() {
            try {
                this.node.addSubscriber(this.proxy);
            }
            catch (Exception e2) {
                NotificationNetwork.this.master.logger.warning(e2.getLocalizedMessage());
            }
        }
    }

    private class RefreshConnectionsTask
    implements Runnable {
        private volatile long lastRun = 0L;
        private volatile boolean scheduled = false;

        private RefreshConnectionsTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RefreshConnectionsTask refreshConnectionsTask = this;
            synchronized (refreshConnectionsTask) {
                long tNow = System.currentTimeMillis();
                long dT = tNow - this.lastRun;
                if (3000L > dT) {
                    if (!this.scheduled) {
                        NotificationNetwork.this.master.getWorkloadManager().scheduleDelayed(this, 3000L - dT);
                        this.scheduled = true;
                    }
                    return;
                }
                this.scheduled = false;
                HashSet<NodeAddress> standbyAddressList = new HashSet<NodeAddress>();
                for (ONSConfiguration.NodeList nl : NotificationNetwork.this.nodeLists) {
                    if (nl.active) continue;
                    NotificationNetwork.this.scanExpandNodeList(nl.nodeList, standbyAddressList);
                }
                for (ONSConfiguration.NodeList nl : NotificationNetwork.this.nodeLists) {
                    if (!nl.active) continue;
                    HashSet<NodeAddress> localAddressList = new HashSet<NodeAddress>();
                    NotificationNetwork.this.scanExpandNodeList(nl.nodeList, localAddressList);
                    NotificationNetwork.this.master.connect(localAddressList, standbyAddressList, nl.maxConnections, NotificationNetwork.this);
                }
                this.lastRun = System.currentTimeMillis();
            }
        }
    }
}

