/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import oracle.ons.spi.WorkloadManager;

public class ThreadPoolWorkloadManager
implements WorkloadManager {
    public static final int DEFAULT_POOL_SIZE = 12;
    public static final int POOL_TIMEOUT = 2000;
    private final int maxPoolSize;
    private final AtomicInteger poolSize = new AtomicInteger(0);
    private final AtomicInteger freePool = new AtomicInteger(0);
    private final DelayQueue<SimpleDelayedTask> queue = new DelayQueue();

    private void createWorker() {
        int id = this.poolSize.incrementAndGet();
        if (id > this.maxPoolSize) {
            this.poolSize.decrementAndGet();
        } else {
            new ExecutorThread().start();
        }
    }

    public ThreadPoolWorkloadManager() {
        this.maxPoolSize = 12;
    }

    @Override
    public void scheduleDelayed(Runnable command, long delay_ms) {
        SimpleDelayedTask task = new SimpleDelayedTask(command, delay_ms);
        this.queue.offer(task);
        if (this.poolSize.get() < this.maxPoolSize && (this.freePool.get() == 0 || delay_ms == 0L || this.poolSize.get() == 0)) {
            this.createWorker();
        }
    }

    @Override
    public void schedule(Runnable command) {
        this.scheduleDelayed(command, 0L);
    }

    private class ExecutorThread
    extends Thread {
        public ExecutorThread() {
            this.setDaemon(true);
            this.setName(String.format("ONS-task-thread-%d", this.getId()));
        }

        @Override
        public void run() {
            SimpleDelayedTask task = null;
            long delay = 2000L;
            try {
                boolean noMoreTasks;
                do {
                    ThreadPoolWorkloadManager.this.freePool.incrementAndGet();
                    noMoreTasks = true;
                    while (null != (task = (SimpleDelayedTask)ThreadPoolWorkloadManager.this.queue.poll(delay, TimeUnit.MILLISECONDS))) {
                        SimpleDelayedTask tt;
                        if (ThreadPoolWorkloadManager.this.poolSize.get() < ThreadPoolWorkloadManager.this.maxPoolSize && (tt = (SimpleDelayedTask)ThreadPoolWorkloadManager.this.queue.peek()) != null && tt.getDelay(TimeUnit.MILLISECONDS) <= 0L) {
                            ThreadPoolWorkloadManager.this.createWorker();
                        }
                        ThreadPoolWorkloadManager.this.freePool.decrementAndGet();
                        task.action.run();
                        delay = 2000L;
                    }
                    if (ThreadPoolWorkloadManager.this.poolSize.decrementAndGet() != 0 || (task = (SimpleDelayedTask)ThreadPoolWorkloadManager.this.queue.peek()) == null) continue;
                    delay = task.getDelay(TimeUnit.MILLISECONDS);
                    if (ThreadPoolWorkloadManager.this.poolSize.incrementAndGet() <= ThreadPoolWorkloadManager.this.maxPoolSize) {
                        noMoreTasks = false;
                        continue;
                    }
                    ThreadPoolWorkloadManager.this.poolSize.decrementAndGet();
                } while (!noMoreTasks);
            }
            catch (InterruptedException e2) {
                this.interrupt();
            }
        }
    }

    private static class SimpleDelayedTask
    implements Delayed {
        long runAt;
        Runnable action;

        SimpleDelayedTask(Runnable action, long delay) {
            this.action = action;
            this.runAt = System.currentTimeMillis() + delay;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.runAt - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o2) {
            return (int)(this.runAt - ((SimpleDelayedTask)o2).runAt);
        }
    }
}

