/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Serializable;
import java.util.Date;

public class CertificateStatus
implements Serializable {
    public static final int UNKNOWN = 0;
    public static final int VALID = 1;
    public static final int INVALID = 2;
    public static final int REVOKED = 3;
    public static final int EXPIRED = 4;
    public static final int ON_HOLD = 5;
    protected static final String[] statusCodeStrs = new String[]{"UNKNOWN", "VALID", "INVALID", "REVOKED", "EXPIRED", "ON_HOLD"};
    protected int statusCode = 0;
    protected String reason;
    protected Date revocationDate;

    public CertificateStatus() {
    }

    public CertificateStatus(int statusCode) {
        this.statusCode = statusCode;
    }

    public CertificateStatus(int statusCode, String reason) {
        this(statusCode);
        this.reason = reason;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusCodeString() {
        if (this.statusCode >= 0 && this.statusCode < statusCodeStrs.length) {
            return statusCodeStrs[this.statusCode];
        }
        return "UNKNOWN";
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public void setStatusCode(String s2) {
        int i2;
        int len = statusCodeStrs.length;
        for (i2 = 0; i2 < len && !s2.equals(statusCodeStrs[i2]); ++i2) {
        }
        this.statusCode = i2 >= statusCodeStrs.length ? 0 : i2;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public Date getRevocationDate() {
        return this.revocationDate;
    }

    public void setRevocationDate(Date revocationDate) {
        this.revocationDate = revocationDate;
    }

    public String toString() {
        String s2 = "";
        s2 = s2 + this.getStatusCodeString();
        if (this.reason != null && this.reason.length() > 0) {
            s2 = s2 + ", reason = " + this.reason;
        }
        if (this.revocationDate != null) {
            s2 = s2 + ", revocationDate = " + this.revocationDate;
        }
        return s2;
    }
}

