/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1Set;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.CRL;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.core.RSAPublicKey;
import oracle.security.crypto.core.SignatureException;
import oracle.security.crypto.provider.JCEUtil;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class PKCS7
implements ASN1Object,
Externalizable {
    private ArrayList<X509> certificates;
    private ArrayList<CRL> crls;
    private X500Name issuer;
    private BigInteger serialNo;
    private RSAPublicKey pubKey;
    private Signature sig;
    private byte[] aaBytes;
    private byte[] hashBytes;
    private byte[] docHash;
    private byte[] sigBytes;
    private byte[] doc;
    private AlgorithmIdentifier mdAlg;
    private ASN1Sequence contents;
    protected static final int[] pkcs7 = new int[]{1, 2, 840, 113549, 1, 7};

    public PKCS7() {
    }

    public PKCS7(Vector<X509> certificates, Vector<CRL> crls) {
        this((List<X509>)certificates, (List<CRL>)crls);
    }

    public PKCS7(List<X509> certificates, List<CRL> crls) {
        ArrayList<Object> arrayList = certificates == null ? null : (this.certificates = certificates instanceof ArrayList ? (ArrayList<Object>)certificates : new ArrayList<X509>(certificates));
        this.crls = crls == null ? null : (crls instanceof ArrayList ? (ArrayList<Object>)crls : new ArrayList<CRL>(crls));
    }

    public PKCS7(X509 cert) {
        this.certificates = new ArrayList();
        this.certificates.add(cert);
    }

    public PKCS7(CRL crl) {
        this.crls = new ArrayList();
        this.crls.add(crl);
    }

    public PKCS7(X509 signer, oracle.security.crypto.core.RSAPrivateKey k2, byte[] doc) throws SignatureException {
        this();
        this.sign(signer, k2, doc);
    }

    public PKCS7(X509Certificate signer, RSAPrivateKey k2, AlgorithmIdentifier sigAlg, byte[] doc) throws SignatureException {
        this();
        this.sign(signer, k2, sigAlg, doc);
    }

    public PKCS7(InputStream is) throws IOException {
        this.input(is);
    }

    public PKCS7(ASN1Sequence s2) throws IOException {
        this.input(s2);
    }

    @Deprecated
    public Vector<X509> getCertificates() {
        return this.certificates == null ? null : new VectorOverArrayList<X509>(this.certificates);
    }

    public ArrayList<X509> getCertificatesAsList() {
        return this.certificates;
    }

    @Deprecated
    public Vector<CRL> getCRLs() {
        return this.crls == null ? null : new VectorOverArrayList<CRL>(this.crls);
    }

    public ArrayList<CRL> getCRLsAsList() {
        return this.crls;
    }

    public void addCertificate(X509 cert) {
        if (this.certificates == null) {
            this.certificates = new ArrayList();
        }
        this.certificates.add(cert);
    }

    public void addCRL(CRL crl) {
        if (this.crls == null) {
            this.crls = new ArrayList();
        }
        this.crls.add(crl);
    }

    public X500Name getIssuer() {
        return this.issuer;
    }

    public BigInteger getSerialNo() {
        return this.serialNo;
    }

    public void setPublicKey(RSAPublicKey pk) {
        this.setPublicKey((java.security.interfaces.RSAPublicKey)pk);
    }

    public void setPublicKey(java.security.interfaces.RSAPublicKey pk) {
        this.pubKey = (RSAPublicKey)CryptoUtils.fromJCEPublicKey(pk);
        try {
            this.sig = JCEUtil.getSignatureInstance(CryptoUtils.getSignatureAlg(PKCS7.getSigAlgID(this.mdAlg)));
            this.sig.initVerify(this.pubKey);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException(ex);
        }
        catch (InvalidKeyException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void setSigner(X509 signer) {
    }

    public void setSigner(X509Certificate signer) {
        if (this.issuer == null) {
            this.issuer = X500Name.toX500Name(signer.getIssuerX500Principal());
        } else if (!this.issuer.equals(signer.getIssuerX500Principal())) {
            throw new RuntimeException("The issuer is " + this.issuer + ", which is not " + signer.getIssuerX500Principal());
        }
        if (this.serialNo == null) {
            this.serialNo = signer.getSerialNumber();
        } else if (!this.serialNo.equals(signer.getSerialNumber())) {
            throw new RuntimeException("The serial number is " + this.serialNo + ", which is not " + signer.getSerialNumber());
        }
        this.setPublicKey((java.security.interfaces.RSAPublicKey)signer.getPublicKey());
    }

    public void setDocument(byte[] doc) {
        if (this.pubKey == null) {
            throw new IllegalStateException("The public key is not set");
        }
        this.doc = doc;
    }

    public void sign(X509 signer, oracle.security.crypto.core.RSAPrivateKey privKey, byte[] doc) throws SignatureException {
        this.sign(signer, privKey, AlgID.md5WithRSAEncryption, doc);
    }

    public void sign(X509 signer, oracle.security.crypto.core.RSAPrivateKey privKey, AlgorithmIdentifier sigAlg, byte[] doc) throws SignatureException {
        this.sign(signer.toX509Certificate(), (RSAPrivateKey)privKey, sigAlg, doc);
    }

    public void sign(X509Certificate signer, RSAPrivateKey privKey, AlgorithmIdentifier sigAlg, byte[] doc) throws SignatureException {
        this.issuer = X500Name.toX500Name(signer.getIssuerX500Principal());
        this.serialNo = signer.getSerialNumber();
        if (!signer.getPublicKey().getAlgorithm().equals("RSA")) {
            throw new SignatureException("Only RSA signatures are supported");
        }
        this.pubKey = (RSAPublicKey)signer.getPublicKey();
        this.mdAlg = PKCS7.getDigestAlgID(sigAlg);
        try {
            this.sig = JCEUtil.getSignatureInstance(CryptoUtils.getSignatureAlg(sigAlg));
            this.sig.initSign(privKey);
            this.sig.update(doc);
            this.sigBytes = this.sig.sign();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SignatureException(ex);
        }
        catch (InvalidKeyException ex) {
            throw new SignatureException(ex);
        }
        catch (java.security.SignatureException ex) {
            throw new SignatureException(ex);
        }
    }

    public boolean verify() throws AuthenticationException {
        if (this.aaBytes == null) {
            try {
                this.sig.update(this.doc);
                return this.sig.verify(this.sigBytes);
            }
            catch (java.security.SignatureException ex) {
                throw new AuthenticationException(ex);
            }
        }
        try {
            this.sig.update(this.doc);
            MessageDigest hash = JCEUtil.getMessageDigestInstance(CryptoUtils.getDigestAlg(this.mdAlg));
            hash.update(this.doc);
            this.docHash = hash.digest();
            return this.sig.verify(this.sigBytes) && Utils.areEqual(this.docHash, this.hashBytes);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationException(ex);
        }
        catch (java.security.SignatureException ex) {
            throw new AuthenticationException(ex);
        }
    }

    @Override
    public void output(OutputStream os) throws IOException {
        this.outputASN1().output(os);
    }

    private ASN1Sequence outputASN1() {
        if (this.contents != null) {
            return this.contents;
        }
        ASN1Sequence s2 = new ASN1Sequence();
        s2.addElement(new ASN1ObjectID(pkcs7, 2));
        ASN1Sequence sd = new ASN1Sequence();
        sd.addElement(new ASN1Integer(1L));
        sd.addElement(new ASN1Set());
        ASN1Sequence ci = new ASN1Sequence();
        ci.addElement(new ASN1ObjectID(pkcs7, 1));
        sd.addElement(ci);
        if (this.certificates != null) {
            sd.addElement(new ASN1GenericConstructed(this.certificates, 0));
        }
        if (this.crls != null) {
            sd.addElement(new ASN1GenericConstructed(this.crls, 1));
        }
        if (this.sig == null) {
            sd.addElement(new ASN1Set());
        } else {
            ASN1Sequence si = new ASN1Sequence();
            si.addElement(new ASN1Integer(1L));
            ASN1Sequence iasn = new ASN1Sequence();
            iasn.addElement(this.issuer);
            iasn.addElement(new ASN1Integer(this.serialNo));
            si.addElement(iasn);
            si.addElement(this.mdAlg);
            si.addElement(AlgID.rsaEncryption);
            si.addElement(new ASN1OctetString(this.sigBytes));
            sd.addElement(new ASN1Set(si));
        }
        s2.addElement(new ASN1GenericConstructed(sd, 0));
        this.contents = s2;
        return s2;
    }

    private static AlgorithmIdentifier getDigestAlgID(AlgorithmIdentifier sigAlgID) {
        if (sigAlgID.getOID().equals(AlgID.md2WithRSAEncryption.getOID())) {
            return AlgID.md2;
        }
        if (sigAlgID.getOID().equals(AlgID.md5WithRSAEncryption.getOID())) {
            return AlgID.md5;
        }
        if (sigAlgID.getOID().equals(AlgID.sha_1WithRSAEncryption.getOID())) {
            return AlgID.sha_1;
        }
        throw new IllegalStateException("Unsupported signature algorithm identifier");
    }

    private static AlgorithmIdentifier getSigAlgID(AlgorithmIdentifier mdAlgID) {
        if (mdAlgID.getOID().equals(AlgID.md2.getOID())) {
            return AlgID.md2WithRSAEncryption;
        }
        if (mdAlgID.getOID().equals(AlgID.md5.getOID())) {
            return AlgID.md5WithRSAEncryption;
        }
        if (mdAlgID.getOID().equals(AlgID.sha_1.getOID()) || mdAlgID.getOID().equals(AlgID.sha.getOID())) {
            return AlgID.sha_1WithRSAEncryption;
        }
        throw new IllegalStateException("Unsupported message digest algorithm identifier");
    }

    @Override
    public void input(InputStream is) throws IOException {
        this.input(new ASN1Sequence(is));
    }

    public void input(ASN1Sequence s2) throws IOException {
        try {
            this.contents = s2;
            ASN1ObjectID ct = (ASN1ObjectID)s2.elementAt(0);
            if (!ct.equals(pkcs7, 2)) {
                throw new IOException("contentType has to be signedData");
            }
            if (s2.elementsAsList().size() < 2) {
                throw new IOException("No content");
            }
            ASN1Sequence sd = (ASN1Sequence)((ASN1GenericConstructed)s2.elementAt(1)).elementAt(0);
            this.certificates = null;
            this.crls = null;
            int i2 = 3;
            while (!(sd.elementAt(i2) instanceof ASN1Set)) {
                ASN1GenericConstructed set = (ASN1GenericConstructed)sd.elementAt(i2);
                switch (set.getTag()) {
                    case 0: {
                        int c2;
                        this.certificates = new ArrayList();
                        int size = set.size();
                        for (c2 = 0; c2 < size; ++c2) {
                            this.certificates.add(new X509(Utils.toStream(set.elementAt(c2))));
                        }
                        break;
                    }
                    case 1: {
                        int c2;
                        this.crls = new ArrayList();
                        int size = set.size();
                        for (c2 = 0; c2 < size; ++c2) {
                            this.crls.add(new CRL(Utils.toStream(set.elementAt(c2))));
                        }
                        break;
                    }
                }
                ++i2;
            }
            ASN1Set sis = (ASN1Set)sd.elementAt(i2);
            if (sis.elementsAsList().size() > 0) {
                ASN1ObjectID deaID;
                i2 = 0;
                ASN1Sequence si = (ASN1Sequence)sis.elementAt(0);
                int n2 = ++i2;
                ASN1Sequence iasn = (ASN1Sequence)si.elementAt(n2);
                this.issuer = new X500Name((ASN1Sequence)iasn.elementAt(0));
                this.serialNo = ((ASN1Integer)iasn.elementAt(1)).getValue();
                int n3 = ++i2;
                this.mdAlg = new AlgorithmIdentifier(Utils.toStream((ASN1Sequence)si.elementAt(n3)));
                if (si.elementAt(++i2) instanceof ASN1GenericConstructed) {
                    ASN1Set aa2 = new ASN1Set(((ASN1GenericConstructed)si.elementAt(i2++)).elementsAsList());
                    this.aaBytes = Utils.toBytes(aa2);
                    this.hashBytes = null;
                    ArrayList<ASN1Object> v2 = aa2.elementsAsList();
                    int size = v2.size();
                    for (int j2 = 0; j2 < size; ++j2) {
                        ASN1Sequence a2 = (ASN1Sequence)v2.get(j2);
                        ASN1ObjectID at = (ASN1ObjectID)a2.elementAt(0);
                        if (!at.equals(ASN1Utils.pkcsID, 9, 4)) continue;
                        this.hashBytes = ((ASN1OctetString)((ASN1Set)a2.elementAt(1)).elementAt(0)).getValue();
                    }
                    if (this.hashBytes == null) {
                        throw new IOException("No message digest found in authenticatedAttributes");
                    }
                }
                if (!(deaID = (ASN1ObjectID)((ASN1Sequence)si.elementAt(i2++)).elementAt(0)).equals(AlgID.rsaEncryption.getOID())) {
                    throw new IOException("Unsupported encryption algorithm " + deaID);
                }
                this.sigBytes = ((ASN1OctetString)si.elementAt(i2++)).getValue();
            }
        }
        catch (ClassCastException ex) {
            throw new ASN1FormatException(ex.toString());
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ASN1FormatException(ex.toString());
        }
    }

    @Override
    public int length() {
        return this.outputASN1().length();
    }

    public byte[] getEncoded() {
        return Utils.toBytes(this.outputASN1());
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data;
        try {
            data = (byte[])is.readObject();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException(ex);
        }
        this.input(new UnsyncByteArrayInputStream(data));
    }
}

