/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.cert.X509PolicyInformation;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class CertificatePoliciesExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_certificatePolicies;
    private ArrayList<X509PolicyInformation> certPolicies;

    public CertificatePoliciesExtension() {
        super(TYPE);
    }

    public CertificatePoliciesExtension(X509PolicyInformation policy) {
        this(policy, false);
    }

    public CertificatePoliciesExtension(X509PolicyInformation policy, boolean critical) {
        super(TYPE, critical);
        this.certPolicies = new ArrayList();
        this.certPolicies.add(policy);
        this.setValue(this.toByteArray());
    }

    public CertificatePoliciesExtension(Vector<X509PolicyInformation> policies) {
        this((List<X509PolicyInformation>)policies);
    }

    public CertificatePoliciesExtension(List<X509PolicyInformation> policies) {
        this(policies, false);
    }

    public CertificatePoliciesExtension(Vector<X509PolicyInformation> policies, boolean critical) {
        this((List<X509PolicyInformation>)policies, critical);
    }

    public CertificatePoliciesExtension(List<X509PolicyInformation> policies, boolean critical) {
        super(TYPE, critical);
        this.certPolicies = policies == null ? null : (policies instanceof ArrayList ? (ArrayList<Object>)policies : new ArrayList<X509PolicyInformation>(policies));
        this.setValue(this.toByteArray());
    }

    public CertificatePoliciesExtension(InputStream is) throws IOException {
        super(is);
    }

    public void addCertificatePolicy(X509PolicyInformation policy) {
        if (this.certPolicies == null) {
            this.certPolicies = new ArrayList();
        }
        this.certPolicies.add(policy);
        this.setValue(this.toByteArray());
    }

    public Vector<X509PolicyInformation> getCertificatePolicies() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.certPolicies == null ? null : new VectorOverArrayList<X509PolicyInformation>(this.certPolicies);
    }

    public ArrayList<X509PolicyInformation> getCertificatePoliciesAsList() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.certPolicies;
    }

    private byte[] toByteArray() {
        byte[] b2 = Utils.toBytes(new ASN1Sequence((List<? extends ASN1Object>)this.certPolicies));
        this.isDecoded = true;
        return b2;
    }

    private void decodeValue() {
        try {
            UnsyncByteArrayInputStream is = new UnsyncByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream sis = new ASN1SequenceInputStream(is);
            this.certPolicies = new ArrayList();
            while (sis.hasMoreData()) {
                this.certPolicies.add(new X509PolicyInformation(sis));
            }
            sis.terminate();
            if (this.certPolicies.size() == 0) {
                throw new ASN1FormatException("Malformed extension contents");
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer s2 = new StringBuffer("certificatePoliciesExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        if (this.getCertificatePoliciesAsList() != null) {
            s2.append("certificatePolicies = {");
            boolean mid = false;
            int size = this.getCertificatePoliciesAsList().size();
            for (int i2 = 0; i2 < size; ++i2) {
                if (mid) {
                    s2.append(", ");
                }
                s2.append(this.getCertificatePoliciesAsList().get(i2).toString());
                mid = true;
            }
            s2.append("}");
        }
        s2.append("]}");
        return s2.toString();
    }
}

