/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericPrimitive;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class PolicyConstraintsExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_policyConstraints;
    private BigInteger requireExplicit;
    private BigInteger inhibitMapping;

    public PolicyConstraintsExtension() {
        super(TYPE);
    }

    public PolicyConstraintsExtension(BigInteger requireExplicit, BigInteger inhibitMapping) {
        this(requireExplicit, inhibitMapping, false);
    }

    public PolicyConstraintsExtension(BigInteger requireExplicit, BigInteger inhibitMapping, boolean critical) {
        super(TYPE, critical);
        this.requireExplicit = requireExplicit;
        this.inhibitMapping = inhibitMapping;
        this.setValue(this.toByteArray());
    }

    public PolicyConstraintsExtension(InputStream is) throws IOException {
        super(is);
    }

    public BigInteger getRequireExplicitPolicy() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.requireExplicit;
    }

    public BigInteger getInhibitPolicyMapping() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.inhibitMapping;
    }

    private byte[] toByteArray() {
        ASN1Sequence seq = new ASN1Sequence();
        if (this.requireExplicit != null) {
            seq.addElement(new ASN1GenericPrimitive(new ASN1Integer(this.requireExplicit), 0));
        }
        if (this.inhibitMapping != null) {
            seq.addElement(new ASN1GenericPrimitive(new ASN1Integer(this.inhibitMapping), 1));
        }
        byte[] b2 = Utils.toBytes(seq);
        this.isDecoded = true;
        return b2;
    }

    private void decodeValue() {
        try {
            UnsyncByteArrayInputStream is = new UnsyncByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream sis = new ASN1SequenceInputStream(is);
            if (sis.hasMoreData() && sis.getCurrentTag() == 0) {
                sis.setCurrentTag(2);
                this.requireExplicit = ASN1Integer.inputValue(sis);
            } else {
                this.requireExplicit = null;
            }
            if (sis.hasMoreData() && sis.getCurrentTag() == 1) {
                sis.setCurrentTag(2);
                this.inhibitMapping = ASN1Integer.inputValue(sis);
            } else {
                this.inhibitMapping = null;
            }
            if (this.requireExplicit == null && this.inhibitMapping == null) {
                throw new ASN1FormatException("Malformed extension contents");
            }
            sis.terminate();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer s2 = new StringBuffer("policyConstraintsExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        boolean began = false;
        if (this.getRequireExplicitPolicy() != null) {
            s2.append("requireExplicit = " + this.getRequireExplicitPolicy());
            began = true;
        }
        if (this.getInhibitPolicyMapping() != null) {
            if (began) {
                s2.append(", ");
            }
            s2.append("inhibitMapping = " + this.getInhibitPolicyMapping());
        }
        s2.append("]}");
        return s2.toString();
    }
}

