/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.IOException;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.Cipher;
import oracle.security.crypto.core.CipherException;
import oracle.security.crypto.core.InvalidKeyException;
import oracle.security.crypto.core.Key;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.PrivateKeyPKCS8;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.SymmetricKey;
import oracle.security.crypto.core.a;
import oracle.security.crypto.core.c;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.provider.TransitionMode;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public final class Arcfour
extends Cipher {
    private int[] a;
    private int b;
    private int c;

    public Arcfour() {
        this.a();
    }

    @Override
    public void initialize(AlgorithmIdentifier algorithmIdentifier, Key key, RandomBitsSource randomBitsSource) throws AlgorithmIdentifierException, InvalidKeyException {
        if (!(key instanceof SymmetricKey)) {
            throw new InvalidKeyException("The key is not an instance of SymmetricKey");
        }
        if (!algorithmIdentifier.getOID().equals(AlgID.RC4.getOID())) {
            throw new AlgorithmIdentifierException("Unknown AlgorithmIdentifier for Arcfour");
        }
        this.f = randomBitsSource;
        this.initialize((SymmetricKey)key);
    }

    public void initialize(SymmetricKey symmetricKey) throws InvalidKeyException {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        if (symmetricKey == null) {
            throw new InvalidKeyException("Key cannot be null");
        }
        this.e = symmetricKey;
        this.a();
        this.a((SymmetricKey)this.e);
        this.c();
    }

    private void a() {
        if (this.a == null) {
            this.a = new int[256];
        }
        for (int i2 = 0; i2 < 256; ++i2) {
            this.a[i2] = i2;
        }
        this.b = 0;
        this.c = 0;
    }

    private void a(SymmetricKey symmetricKey) {
        oracle.security.crypto.core.a.a(symmetricKey, 2048);
        byte[] byArray = symmetricKey.d();
        int[] nArray = this.a;
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < 256; ++i2) {
            n3 = (byArray[n2] & 0xFF) + nArray[i2] + n3 & 0xFF;
            int n4 = nArray[i2];
            nArray[i2] = nArray[n3];
            nArray[n3] = n4;
            ++n2;
            n2 %= byArray.length;
        }
    }

    @Override
    public byte[] decrypt(byte[] byArray, int n2, int n3, boolean bl) throws CipherException {
        byte[] byArray2 = new byte[n3];
        this.decrypt(byArray, n2, n3, byArray2, 0);
        return byArray2;
    }

    @Override
    public void decrypt(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws CipherException {
        this.d();
        this.a(byArray, n2, n3, byArray2, n4);
    }

    private void a(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws CipherException {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        int n5 = n2 + n3;
        int[] nArray = this.a;
        int n6 = n2;
        int n7 = n4;
        while (n6 < n5) {
            int n8;
            ++this.b;
            this.b &= 0xFF;
            int n9 = nArray[this.b];
            this.c += n9;
            this.c &= 0xFF;
            nArray[this.b] = n8 = nArray[this.c];
            nArray[this.c] = n9;
            byArray2[n7] = (byte)(nArray[n9 + n8 & 0xFF] ^ byArray[n6]);
            ++n6;
            ++n7;
        }
    }

    @Override
    public byte[] encrypt(byte[] byArray, int n2, int n3, boolean bl) throws CipherException {
        byte[] byArray2 = new byte[n3];
        this.encrypt(byArray, n2, n3, byArray2, 0);
        return byArray2;
    }

    @Override
    public void encrypt(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws CipherException {
        this.e();
        this.b(byArray, n2, n3, byArray2, n4);
    }

    private void b(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws CipherException {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        int n5 = n2 + n3;
        int[] nArray = this.a;
        int n6 = n2;
        int n7 = n4;
        while (n6 < n5) {
            int n8;
            ++this.b;
            this.b &= 0xFF;
            int n9 = nArray[this.b];
            this.c += n9;
            this.c &= 0xFF;
            nArray[this.b] = n8 = nArray[this.c];
            nArray[this.c] = n9;
            byArray2[n7] = (byte)(nArray[n9 + n8 & 0xFF] ^ byArray[n6]);
            ++n6;
            ++n7;
        }
    }

    @Override
    public byte[] wrapKey(PrivateKey privateKey) throws CipherException {
        if (privateKey instanceof PrivateKeyPKCS8) {
            throw new CipherException("Cannot wrap encrypted key");
        }
        return this.a(oracle.security.crypto.core.c.a(privateKey));
    }

    @Override
    public byte[] wrapKey(SymmetricKey symmetricKey) throws CipherException {
        return this.a(symmetricKey.d());
    }

    private byte[] a(byte[] byArray) throws CipherException {
        this.f();
        byte[] byArray2 = new byte[byArray.length];
        this.b(byArray, 0, byArray.length, byArray2, 0);
        this.a();
        this.a((SymmetricKey)this.e);
        return byArray2;
    }

    @Override
    public PrivateKey unwrapPrivateKey(byte[] byArray) throws CipherException {
        byte[] byArray2 = this.b(byArray);
        PrivateKey privateKey = null;
        try {
            privateKey = CryptoUtils.inputPrivateKey(new UnsyncByteArrayInputStream(byArray2));
        }
        catch (IOException iOException) {
            throw new CipherException(iOException.toString());
        }
        Utils.setArray(byArray2, (byte)0);
        return privateKey;
    }

    @Override
    public SymmetricKey unwrapSymmetricKey(byte[] byArray, AlgorithmIdentifier algorithmIdentifier) throws CipherException {
        byte[] byArray2 = this.b(byArray);
        SymmetricKey symmetricKey = new SymmetricKey(byArray2, algorithmIdentifier);
        Utils.setArray(byArray2, (byte)0);
        return symmetricKey;
    }

    private byte[] b(byte[] byArray) throws CipherException {
        this.g();
        byte[] byArray2 = new byte[byArray.length];
        this.a(byArray, 0, byArray.length, byArray2, 0);
        this.a();
        this.a((SymmetricKey)this.e);
        return byArray2;
    }

    @Override
    public void erase() {
        this.a();
        super.erase();
    }

    @Override
    public String algName() {
        return "Arcfour";
    }

    @Override
    public AlgorithmIdentifier getAlgID() {
        return AlgID.RC4;
    }

    @Override
    public final int getBlockSize() {
        return 1;
    }

    private byte a(byte by) {
        int n2;
        int[] nArray = this.a;
        ++this.b;
        this.b &= 0xFF;
        int n3 = nArray[this.b];
        this.c += n3;
        this.c &= 0xFF;
        nArray[this.b] = n2 = nArray[this.c];
        nArray[this.c] = n3;
        return (byte)(nArray[n3 + n2 & 0xFF] ^ by);
    }
}

