/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import oracle.security.crypto.core.MessageDigest;
import oracle.security.crypto.fips.FIPS_140_2;

public class DigestOutputStream
extends FilterOutputStream {
    protected MessageDigest a;

    public DigestOutputStream(OutputStream outputStream, MessageDigest messageDigest) {
        super(outputStream);
        this.a = messageDigest;
    }

    @Override
    public synchronized void write(int n2) throws IOException {
        this.a.update((byte)n2);
        this.out.write(n2);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = n2 + n3;
        for (int i2 = n2; i2 < n4; ++i2) {
            this.write(byArray[i2]);
        }
    }

    public byte[] computeCurrent() {
        this.a.computeCurrent();
        return this.a.getDigestBits();
    }

    public MessageDigest getMessageDigest() {
        return this.a;
    }

    public void setMessageDigest(MessageDigest messageDigest) {
        this.a = messageDigest;
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

