/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.util;

import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.fips.FIPS_140_2;

public class UnsyncByteArrayInputStream
extends InputStream {
    protected byte[] a;
    protected int b;
    protected int c;
    protected int d;
    private boolean e;

    public UnsyncByteArrayInputStream(byte[] byArray) {
        this.a = byArray;
        this.d = byArray.length;
    }

    public UnsyncByteArrayInputStream(byte[] byArray, int n2, int n3) {
        this.a = byArray;
        this.b = this.c = n2;
        this.d = Math.min(n2 + n3, byArray.length);
    }

    @Override
    public int read() throws IOException {
        this.a();
        return this.b < this.d ? this.a[this.b++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        this.a();
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.b >= this.d) {
            return -1;
        }
        if (this.b + n3 > this.d) {
            n3 = this.d - this.b;
        }
        if (n3 <= 0) {
            return 0;
        }
        System.arraycopy(this.a, this.b, byArray, n2, n3);
        this.b += n3;
        return n3;
    }

    @Override
    public long skip(long l2) throws IOException {
        this.a();
        if ((long)this.b + l2 > (long)this.d) {
            l2 = this.d - this.b;
        }
        if (l2 <= 0L) {
            return 0L;
        }
        this.b = (int)((long)this.b + l2);
        return l2;
    }

    @Override
    public int available() throws IOException {
        this.a();
        return this.d - this.b;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int n2) {
        this.c = this.b;
    }

    @Override
    public void reset() throws IOException {
        this.a();
        this.b = this.c;
    }

    @Override
    public void close() throws IOException {
        this.e = true;
    }

    private void a() throws IOException {
        if (this.e) {
            throw new IOException("input stream closed");
        }
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

