/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.binxml;

import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.namespace.QName;
import oracle.xml.binxml.BinXMLConstants;
import oracle.xml.binxml.BinXMLException;
import oracle.xml.binxml.BinXMLMetadataProvider;
import oracle.xml.binxml.BinXMLProperty;
import oracle.xml.binxml.BinXMLSchema;
import oracle.xml.binxml.BinXMLSchemaAnnotationBuilder;
import oracle.xml.binxml.BinXMLUtil;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XMLSchemaNode;
import oracle.xml.parser.schema.XSDAnnotation;
import oracle.xml.parser.schema.XSDAny;
import oracle.xml.parser.schema.XSDAttribute;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDConstantValues;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.util.XMLError;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

class BinXMLSchemaAnnotator
implements XSDConstantValues,
BinXMLConstants {
    URL schemaurl;
    Reader reader;
    Reader[] readers;
    XMLDocument root = null;
    BinXMLProperty rootprop = null;
    String rootprefix;
    int propId = 0;
    int typeId = 101;
    private static int DEFAULT_COMPLEX_TYPE_ID = 47;
    private static int UNDEFINED_COMPLEX_TYPE_ID = -99;
    BinXMLSchema bxschema;
    EntityResolver entResolver;
    XMLError err;
    BinXMLMetadataProvider metaProvider;
    boolean debug = false;

    BinXMLSchemaAnnotator() {
    }

    void setXMLError(XMLError xMLError) {
        this.err = xMLError;
    }

    void setEntityResolver(EntityResolver entityResolver) {
        this.entResolver = entityResolver;
    }

    void setBinXMLSchema(BinXMLSchema binXMLSchema) {
        this.bxschema = binXMLSchema;
    }

    void setSchemaURL(URL uRL) {
        this.schemaurl = uRL;
    }

    void setSchemaReader(Reader reader) {
        this.reader = reader;
    }

    void setSchemaReaders(Reader[] readerArray) {
        this.readers = readerArray;
    }

    void init() {
        this.propId = 0;
        this.typeId = 101;
    }

    void reset() {
        this.propId = 0;
        this.typeId = 101;
    }

    void setDebugMode(boolean bl) {
        this.debug = bl;
    }

    boolean getDebugMode() {
        return this.debug;
    }

    void setMetadataProvider(BinXMLMetadataProvider binXMLMetadataProvider) {
        this.metaProvider = binXMLMetadataProvider;
    }

    XMLDocument processBinXMLSchemaAnnotations(String[] stringArray) throws XSDException, IOException, SAXException, XMLParseException, BinXMLException {
        XMLSchemaNode[] xMLSchemaNodeArray = this.getSchemaNodes(stringArray);
        if (xMLSchemaNodeArray == null) {
            return null;
        }
        this.processSystemLevelAnnotations(xMLSchemaNodeArray);
        return this.root;
    }

    private int generateCSXEncodingTypeID(XMLElement xMLElement) {
        NodeList nodeList = xMLElement.getElementsByTagNameNS("http://xmlns.oracle.com/2004/CSX", "encodingType");
        if (nodeList == null || nodeList.getLength() == 0) {
            return -1;
        }
        if (nodeList.getLength() > 1) {
            return -1;
        }
        XMLElement xMLElement2 = (XMLElement)nodeList.item(0);
        String string = xMLElement2.getText();
        for (int i2 = 0; i2 < BinXMLConstants.ENCODING_TYPES.length; ++i2) {
            if (!BinXMLConstants.ENCODING_TYPES[i2].equals(string)) continue;
            return i2 + 1;
        }
        return -1;
    }

    private void processSystemLevelAnnotations(XMLSchemaNode[] xMLSchemaNodeArray) {
        int n2;
        for (n2 = 0; n2 < xMLSchemaNodeArray.length; ++n2) {
            this.processAnnotatedSimpleTypeSet(xMLSchemaNodeArray[n2]);
        }
        for (n2 = 0; n2 < xMLSchemaNodeArray.length; ++n2) {
            this.processAnnotatedComplexTypeSet(xMLSchemaNodeArray[n2]);
        }
        for (n2 = 0; n2 < xMLSchemaNodeArray.length; ++n2) {
            this.processAnnotatedAttributeSet(xMLSchemaNodeArray[n2]);
        }
        for (n2 = 0; n2 < xMLSchemaNodeArray.length; ++n2) {
            this.processAnnotatedElementSet(xMLSchemaNodeArray[n2]);
        }
        this.assignKidsVec2ElemBasedOnType();
        this.resolveKidNumMap();
    }

    private void resolveKidNumMap() {
        Vector vector = this.bxschema.getBinXMLProperties();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            short s2;
            BinXMLProperty binXMLProperty = (BinXMLProperty)vector.get(i2);
            short s3 = binXMLProperty.getKidNum();
            HashMap hashMap = binXMLProperty.getKidNumMap();
            if (hashMap == null) continue;
            if (hashMap.size() == 1) {
                binXMLProperty.setKidNumMap(null);
                continue;
            }
            Collection collection = hashMap.values();
            Iterator iterator = collection.iterator();
            Short s4 = (Short)iterator.next();
            short s5 = s2 = s4.shortValue();
            int n2 = 1;
            while (iterator.hasNext()) {
                s4 = (Short)iterator.next();
                s2 = s4;
                if (s2 != s5) continue;
                ++n2;
            }
            if (n2 != hashMap.size()) continue;
            binXMLProperty.setKidNumMap(null);
        }
    }

    private void assignKidsVec2ElemBasedOnType() {
        Vector vector = this.bxschema.getBinXMLProperties();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            BinXMLProperty binXMLProperty;
            BinXMLProperty binXMLProperty2 = (BinXMLProperty)vector.get(i2);
            XSDNode xSDNode = binXMLProperty2.getXSDNode();
            if (!(xSDNode instanceof XSDElement)) continue;
            Vector vector2 = binXMLProperty2.getKidProperties();
            XSDNode xSDNode2 = binXMLProperty2.getTypeNode();
            if (vector2 != null || xSDNode2 == null || !(xSDNode2 instanceof XSDComplexType)) continue;
            BinXMLProperty binXMLProperty3 = this.bxschema.locateProperty(xSDNode2);
            if (binXMLProperty3 != null) {
                vector2 = binXMLProperty3.getKidProperties();
                binXMLProperty2.setKidProperties(vector2);
                binXMLProperty2.setKidNumMap(binXMLProperty3.getKidNumMap());
                continue;
            }
            if (xSDNode.getRefLocalname() == null || (binXMLProperty = this.getBaseProperty(binXMLProperty2, vector)) == null) continue;
            vector2 = binXMLProperty.getKidProperties();
            binXMLProperty2.setKidProperties(vector2);
            binXMLProperty2.setKidNumMap(binXMLProperty.getKidNumMap());
        }
    }

    private BinXMLProperty getBaseProperty(BinXMLProperty binXMLProperty, Vector vector) {
        QName qName = binXMLProperty.getQName();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            BinXMLProperty binXMLProperty2 = (BinXMLProperty)vector.get(i2);
            if (binXMLProperty2.getXSDNode().getRefLocalname() != null || !binXMLProperty2.getQName().equals(qName)) continue;
            return binXMLProperty2;
        }
        return null;
    }

    private void processAnnotatedAttributeSet(XMLSchemaNode xMLSchemaNode) {
        XSDNode[] xSDNodeArray = xMLSchemaNode.getAttributeDeclarations();
        if (xSDNodeArray == null || xSDNodeArray.length == 0) {
            return;
        }
        this.processAnnotatedAttributeNodes(xSDNodeArray);
    }

    private void processAnnotatedElementSet(XMLSchemaNode xMLSchemaNode) {
        XSDNode[] xSDNodeArray = xMLSchemaNode.getElementSet();
        if (xSDNodeArray == null || xSDNodeArray.length == 0) {
            return;
        }
        this.processAnnotatedElementNodes(xSDNodeArray);
    }

    private void processAnnotatedSimpleTypeSet(XMLSchemaNode xMLSchemaNode) {
        XSDNode[] xSDNodeArray = xMLSchemaNode.getSimpleTypeSet();
        if (xSDNodeArray == null || xSDNodeArray.length == 0) {
            return;
        }
        this.processAnnotatedSimpleTypeNodes(xSDNodeArray);
    }

    private void processAnnotatedComplexTypeSet(XMLSchemaNode xMLSchemaNode) {
        XSDNode[] xSDNodeArray = xMLSchemaNode.getComplexTypeSet();
        if (xSDNodeArray == null || xSDNodeArray.length == 0) {
            return;
        }
        this.processAnnotatedComplexTypeNodes(xSDNodeArray);
    }

    private void processAnnotatedElementNodes(XSDNode[] xSDNodeArray) {
        int n2;
        if (this.bxschema.getDebugMode()) {
            for (n2 = 0; n2 < xSDNodeArray.length; ++n2) {
                System.out.println(xSDNodeArray[n2].getName());
            }
        }
        for (n2 = 0; n2 < xSDNodeArray.length; ++n2) {
            this.processAnnotatedElementNode(xSDNodeArray[n2]);
        }
    }

    private void processAnnotatedSimpleTypeNodes(XSDNode[] xSDNodeArray) {
        int n2;
        if (this.bxschema.getDebugMode()) {
            for (n2 = 0; n2 < xSDNodeArray.length; ++n2) {
                if (BinXMLSchemaAnnotator.isBuiltinSimpleType((XSDSimpleType)xSDNodeArray[n2])) continue;
                System.out.println(xSDNodeArray[n2].getName());
            }
        }
        for (n2 = 0; n2 < xSDNodeArray.length; ++n2) {
            if (BinXMLSchemaAnnotator.isBuiltinSimpleType((XSDSimpleType)xSDNodeArray[n2])) continue;
            this.processAnnotatedSimpleTypeNode(xSDNodeArray[n2]);
        }
    }

    private void processAnnotatedComplexTypeNodes(XSDNode[] xSDNodeArray) {
        int n2;
        if (this.bxschema.getDebugMode()) {
            for (n2 = 0; n2 < xSDNodeArray.length; ++n2) {
                System.out.println(xSDNodeArray[n2].getName());
            }
        }
        for (n2 = 0; n2 < xSDNodeArray.length; ++n2) {
            this.processAnnotatedComplexTypeNode(xSDNodeArray[n2]);
        }
    }

    private void processAnnotatedAttributeNodes(XSDNode[] xSDNodeArray) {
        int n2;
        if (this.bxschema.getDebugMode()) {
            for (n2 = 0; n2 < xSDNodeArray.length; ++n2) {
                System.out.println(xSDNodeArray[n2].getName());
            }
        }
        for (n2 = 0; n2 < xSDNodeArray.length; ++n2) {
            this.processAnnotatedAttributeNode(xSDNodeArray[n2]);
        }
    }

    private void processAnnotatedElementNode(XSDNode xSDNode) {
        boolean bl = false;
        if (this.bxschema.isWithKidList(xSDNode)) {
            bl = true;
        }
        if (!bl) {
            BinXMLProperty binXMLProperty = this.createProperty(xSDNode);
            this.bxschema.putProperty(binXMLProperty, xSDNode);
        } else {
            XSDNode[] xSDNodeArray;
            BinXMLProperty binXMLProperty;
            XSDAttribute[] xSDAttributeArray = ((XSDElement)xSDNode).getAttributeDeclarations();
            if (xSDAttributeArray != null) {
                for (int i2 = 0; i2 < xSDAttributeArray.length; ++i2) {
                    binXMLProperty = this.createProperty(xSDAttributeArray[i2]);
                    this.bxschema.putProperty(binXMLProperty, xSDAttributeArray[i2]);
                }
            }
            if ((xSDNodeArray = ((XSDElement)xSDNode).getChildElements()) != null) {
                for (int i3 = 0; i3 < xSDNodeArray.length; ++i3) {
                    Vector vector;
                    boolean bl2;
                    binXMLProperty = this.createProperty(xSDNodeArray[i3]);
                    this.bxschema.putProperty(binXMLProperty, xSDNodeArray[i3]);
                    boolean bl3 = bl2 = xSDNodeArray[i3].getRefLocalname() != null;
                    if (!bl2) {
                        this.processAnnotatedElementNode(xSDNodeArray[i3]);
                        continue;
                    }
                    XSDNode xSDNode2 = ((XSDElement)xSDNodeArray[i3]).getType();
                    if (!(xSDNode2 instanceof XSDComplexType)) continue;
                    BinXMLProperty binXMLProperty2 = this.bxschema.locateProperty(xSDNode2);
                    if (binXMLProperty2 != null) {
                        vector = binXMLProperty2.getKidProperties();
                        if (vector == null) {
                            binXMLProperty2 = this.createProperty(xSDNode2);
                            vector = binXMLProperty2.getKidProperties();
                        }
                        binXMLProperty.setKidProperties(vector);
                        continue;
                    }
                    binXMLProperty2 = this.createProperty(xSDNode2);
                    if (binXMLProperty2 == null) continue;
                    vector = binXMLProperty2.getKidProperties();
                    binXMLProperty.setKidProperties(vector);
                }
            }
        }
        this.processAnnotatedKidList(xSDNode);
    }

    private void processAnnotatedKidList(XSDNode xSDNode) {
        XSDAnnotation xSDAnnotation;
        if (xSDNode instanceof XSDElement) {
            xSDAnnotation = ((XSDElement)xSDNode).getType().getAnnotation();
        } else if (xSDNode instanceof XSDComplexType) {
            xSDAnnotation = xSDNode.getAnnotation();
        } else {
            return;
        }
        if (xSDAnnotation == null) {
            return;
        }
        Vector vector = xSDAnnotation.getApplicationInformation();
        this.processAnnotatedKidList(xSDNode, vector);
    }

    private void processAnnotatedComplexTypeNode(XSDNode xSDNode) {
        boolean bl = false;
        if (this.bxschema.isWithKidList(xSDNode)) {
            bl = true;
        }
        if (!bl) {
            BinXMLProperty binXMLProperty = this.createProperty(xSDNode);
            this.bxschema.putProperty(binXMLProperty, xSDNode);
        } else {
            XSDNode[] xSDNodeArray;
            BinXMLProperty binXMLProperty;
            XSDAttribute[] xSDAttributeArray = ((XSDComplexType)xSDNode).getAttributeDeclarations();
            if (xSDAttributeArray != null) {
                for (int i2 = 0; i2 < xSDAttributeArray.length; ++i2) {
                    binXMLProperty = this.createProperty(xSDAttributeArray[i2]);
                    this.bxschema.putProperty(binXMLProperty, xSDAttributeArray[i2]);
                }
            }
            if ((xSDNodeArray = ((XSDComplexType)xSDNode).getChildElements()) != null) {
                for (int i3 = 0; i3 < xSDNodeArray.length; ++i3) {
                    Vector vector;
                    boolean bl2;
                    binXMLProperty = this.createProperty(xSDNodeArray[i3]);
                    this.bxschema.putProperty(binXMLProperty, xSDNodeArray[i3]);
                    boolean bl3 = bl2 = xSDNodeArray[i3].getRefLocalname() != null;
                    if (!bl2) {
                        this.processAnnotatedElementNode(xSDNodeArray[i3]);
                        continue;
                    }
                    XSDNode xSDNode2 = ((XSDElement)xSDNodeArray[i3]).getType();
                    if (!(xSDNode2 instanceof XSDComplexType)) continue;
                    BinXMLProperty binXMLProperty2 = this.bxschema.locateProperty(xSDNode2);
                    if (binXMLProperty2 != null) {
                        vector = binXMLProperty2.getKidProperties();
                        if (vector == null) {
                            binXMLProperty2 = this.createProperty(xSDNode2);
                            vector = binXMLProperty2.getKidProperties();
                        }
                        binXMLProperty.setKidProperties(vector);
                        continue;
                    }
                    binXMLProperty2 = this.createProperty(xSDNode2);
                    if (binXMLProperty2 == null) continue;
                    vector = binXMLProperty2.getKidProperties();
                    binXMLProperty.setKidProperties(vector);
                }
            }
            this.processAnnotatedKidList(xSDNode);
        }
    }

    private void processAnnotatedSimpleTypeNode(XSDNode xSDNode) {
        BinXMLProperty binXMLProperty = this.createProperty(xSDNode);
        this.bxschema.putProperty(binXMLProperty, xSDNode);
    }

    private void processAnnotatedAttributeNode(XSDNode xSDNode) {
        BinXMLProperty binXMLProperty = this.createProperty((XSDAttribute)xSDNode);
        this.bxschema.putProperty(binXMLProperty, xSDNode);
    }

    private void processAnnotatedKidList(XSDNode xSDNode, Vector vector) {
        for (int i2 = 0; vector != null && i2 < vector.size(); ++i2) {
            XMLElement xMLElement = (XMLElement)vector.get(i2);
            NodeList nodeList = xMLElement.getElementsByTagNameNS("http://xmlns.oracle.com/2004/CSX", "kidList");
            if (nodeList == null || nodeList.getLength() < 1) continue;
            XMLElement xMLElement2 = (XMLElement)nodeList.item(0);
            if (this.bxschema.getDebugMode()) {
                try {
                    xMLElement2.print(System.out);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            NodeList nodeList2 = xMLElement2.getChildNodes();
            this.processAllKidAnnotation(xSDNode, nodeList2);
        }
    }

    private Vector processAllKidAnnotation(XSDNode xSDNode, NodeList nodeList) {
        int n2 = nodeList.getLength();
        BinXMLProperty binXMLProperty = this.bxschema.locateProperty(xSDNode);
        if (binXMLProperty == null) {
            binXMLProperty = this.createProperty(xSDNode);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = nodeList.item(i2);
            if (!(node instanceof XMLElement)) continue;
            XMLElement xMLElement = (XMLElement)node;
            if (this.bxschema.getDebugMode()) {
                try {
                    xMLElement.print(System.out);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            BinXMLProperty binXMLProperty2 = this.createKidProperty(binXMLProperty, xMLElement);
        }
        this.bxschema.putProperty(binXMLProperty, xSDNode);
        return binXMLProperty.getKidProperties();
    }

    private BinXMLProperty createProperty(XSDNode xSDNode) {
        BinXMLProperty binXMLProperty = new BinXMLProperty();
        if (xSDNode instanceof XSDComplexType) {
            XMLElement xMLElement = ((XSDComplexType)xSDNode).getDomNode();
            if (xMLElement == null) {
                return null;
            }
            String string = xMLElement.getAttributeNS("http://xmlns.oracle.com/2004/CSX", "typeID");
            int n2 = -1;
            if (string != null && string.length() > 0) {
                n2 = Integer.parseInt(string);
            }
            binXMLProperty.setTypeId(n2);
            binXMLProperty.setPropId(-1);
            binXMLProperty.setTypeNode((XSDComplexType)xSDNode);
            binXMLProperty.setXSDTypeCode(4);
            boolean bl = BinXMLUtil.canBeInSeqMode((XSDComplexType)xSDNode);
            if (bl) {
                binXMLProperty.setIsSequential(true);
            }
        } else if (xSDNode instanceof XSDSimpleType) {
            XMLElement xMLElement = ((XSDSimpleType)xSDNode).getDomNode();
            String string = xMLElement.getAttributeNS("http://xmlns.oracle.com/2004/CSX", "typeID");
            binXMLProperty.setTypeId(Integer.parseInt(string));
            binXMLProperty.setPropId(-1);
            binXMLProperty.setTypeNode((XSDSimpleType)xSDNode);
            binXMLProperty.setXSDTypeCode(8);
        } else if (xSDNode instanceof XSDElement) {
            boolean bl;
            XMLElement xMLElement = ((XSDElement)xSDNode).getDomNode();
            String string = xMLElement.getAttributeNS("http://xmlns.oracle.com/2004/CSX", "propertyID");
            binXMLProperty.setPropId(Integer.parseInt(string));
            XSDNode xSDNode2 = ((XSDElement)xSDNode).getType();
            binXMLProperty.setTypeNode(xSDNode2);
            if (xSDNode2 instanceof XSDComplexType && (bl = BinXMLUtil.canBeInSeqMode((XSDComplexType)xSDNode2))) {
                binXMLProperty.setIsSequential(true);
            }
            binXMLProperty.setXSDTypeCode(1);
        } else {
            if (xSDNode instanceof XSDAny) {
                QName qName = xSDNode.getQName();
                binXMLProperty.setXSDTypeCode(1);
                binXMLProperty.setXSDNode(xSDNode);
                binXMLProperty.setQName(qName);
                return binXMLProperty;
            }
            if (xSDNode instanceof XSDAttribute) {
                XMLElement xMLElement = ((XSDAttribute)xSDNode).getDomNode();
                String string = xMLElement.getAttributeNS("http://xmlns.oracle.com/2004/CSX", "propertyID");
                binXMLProperty.setPropId(Integer.parseInt(string));
                XSDNode xSDNode3 = ((XSDAttribute)xSDNode).getType();
                binXMLProperty.setTypeNode(xSDNode3);
                binXMLProperty.setXSDTypeCode(2);
            } else {
                return null;
            }
        }
        binXMLProperty.setXSDNode(xSDNode);
        binXMLProperty.setQName(xSDNode.getQName());
        binXMLProperty.setCSXEncodingType(this.getCSXEncodingType(xSDNode, binXMLProperty.enums != null));
        return binXMLProperty;
    }

    int getCSXEncodingType(XSDNode xSDNode, boolean bl) {
        int n2 = this.processUserDefinedAnnotations(xSDNode);
        if (n2 == -1) {
            n2 = bl ? 12 : BinXMLUtil.bindXMLTypeToEncodingType(this.getXMLTypeId(xSDNode));
        } else if (!BinXMLUtil.validateCSXEncodingType(this.getXMLTypeId(xSDNode), n2)) {
            n2 = BinXMLUtil.bindXMLTypeToEncodingType(this.getXMLTypeId(xSDNode));
        }
        return n2;
    }

    int getXMLTypeId(XSDNode xSDNode) {
        if (xSDNode instanceof XSDSimpleType) {
            return ((XSDSimpleType)xSDNode).getBuiltInId();
        }
        if (xSDNode instanceof XSDElement && ((XSDElement)xSDNode).getType() instanceof XSDSimpleType) {
            return ((XSDSimpleType)((XSDElement)xSDNode).getType()).getBuiltInId();
        }
        if (xSDNode instanceof XSDAttribute && ((XSDAttribute)xSDNode).getType() instanceof XSDSimpleType) {
            return ((XSDSimpleType)((XSDAttribute)xSDNode).getType()).getBuiltInId();
        }
        if (xSDNode instanceof XSDComplexType && ((XSDComplexType)xSDNode).isSimpleContent()) {
            return ((XSDComplexType)xSDNode).getSimpleType().getBuiltInId();
        }
        return -1;
    }

    private BinXMLProperty createKidProperty(BinXMLProperty binXMLProperty, XMLElement xMLElement) {
        String string = xMLElement.getAttributeNS("", "kidNum");
        String string2 = xMLElement.getAttributeNS("http://xmlns.oracle.com/2004/CSX", "propertyID");
        int n2 = Integer.parseInt(string2);
        BinXMLProperty binXMLProperty2 = this.bxschema.getProperty(n2);
        if (binXMLProperty2 == null) {
            binXMLProperty2 = new BinXMLProperty();
            binXMLProperty2.setPropId(n2);
        }
        short s2 = Short.parseShort(string);
        binXMLProperty2.setKidNum(binXMLProperty, s2);
        binXMLProperty.addKid(binXMLProperty2, s2);
        return binXMLProperty2;
    }

    private int processUserDefinedAnnotations(XSDNode xSDNode) {
        int n2 = -1;
        XSDAnnotation xSDAnnotation = xSDNode.getAnnotation();
        if (xSDAnnotation == null) {
            return n2;
        }
        Vector vector = xSDAnnotation.getApplicationInformation();
        if (vector == null || vector.size() == 0) {
            return n2;
        }
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            XMLElement xMLElement = (XMLElement)vector.get(i2);
            if (n2 != -1) continue;
            n2 = this.generateCSXEncodingTypeID(xMLElement);
        }
        return n2;
    }

    private XMLDocument[] getXMLDocuments(Reader[] readerArray) throws IOException, SAXException, XMLParseException {
        DOMParser dOMParser = new DOMParser();
        int n2 = readerArray.length;
        XMLDocument[] xMLDocumentArray = new XMLDocument[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dOMParser.parse(readerArray[i2]);
            xMLDocumentArray[i2] = dOMParser.getDocument();
        }
        return xMLDocumentArray;
    }

    private XMLDocument getXMLDocument(Reader reader) throws IOException, SAXException, XMLParseException {
        DOMParser dOMParser = new DOMParser();
        dOMParser.parse(reader);
        XMLDocument xMLDocument = dOMParser.getDocument();
        return xMLDocument;
    }

    private XMLSchemaNode[] getSchemaNodes(String[] stringArray) throws XSDException, IOException, SAXException, XMLParseException, BinXMLException {
        XMLSchemaNode[] xMLSchemaNodeArray;
        int n2;
        XMLSchema xMLSchema;
        Object[] objectArray;
        XSDBuilder xSDBuilder = new XSDBuilder();
        if (this.entResolver != null) {
            xSDBuilder.setEntityResolver(this.entResolver);
        }
        if (this.reader != null) {
            objectArray = this.getXMLDocument(this.reader);
            this.root = objectArray;
            if (this.bxschema.getDebugMode()) {
                objectArray.print(System.out);
            }
            xMLSchema = xSDBuilder.build((XMLDocument)objectArray, this.schemaurl);
        } else if (this.readers != null) {
            objectArray = this.getXMLDocuments(this.readers);
            if (stringArray != null) {
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    xMLSchemaNodeArray = objectArray[n2].getDocumentElement().getAttribute("targetNamespace");
                    if (stringArray[n2].equals(xMLSchemaNodeArray)) continue;
                    throw new BinXMLException(this.err.getMessage0(35009));
                }
            }
            xMLSchema = xSDBuilder.build((XMLDocument[])objectArray, (URL)null);
        } else {
            if (this.schemaurl == null) {
                return null;
            }
            XMLSchema xMLSchema2 = xSDBuilder.build(this.schemaurl);
            this.bxschema.setXMLSchema(xMLSchema2);
            BinXMLSchemaAnnotationBuilder binXMLSchemaAnnotationBuilder = new BinXMLSchemaAnnotationBuilder(this.schemaurl, xMLSchema2);
            binXMLSchemaAnnotationBuilder.setDebugMode(this.debug);
            return binXMLSchemaAnnotationBuilder.build();
        }
        this.bxschema.setXMLSchema(xMLSchema);
        objectArray = xMLSchema.getAllTargetNS();
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        n2 = objectArray.length;
        xMLSchemaNodeArray = new XMLSchemaNode[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            xMLSchemaNodeArray[i2] = xMLSchema.getSchemaByTargetNS((String)objectArray[i2]);
        }
        return xMLSchemaNodeArray;
    }

    static boolean isBuiltinSimpleType(XSDSimpleType xSDSimpleType) {
        if (xSDSimpleType.getDomNode() == null) {
            return true;
        }
        XSDSimpleType[] xSDSimpleTypeArray = XSDSimpleType.getBuiltInArray();
        for (int i2 = 0; i2 < xSDSimpleTypeArray.length; ++i2) {
            if (xSDSimpleTypeArray[i2] != xSDSimpleType) continue;
            return true;
        }
        return false;
    }
}

