/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.binxml;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import oracle.xml.binxml.BinXMLDecodeReader;
import oracle.xml.binxml.BinXMLDecoder;
import oracle.xml.binxml.BinXMLDecoderImpl;
import oracle.xml.binxml.BinXMLEncoder;
import oracle.xml.binxml.BinXMLEncoderImpl;
import oracle.xml.binxml.BinXMLException;
import oracle.xml.binxml.BinXMLProcessor;
import oracle.xml.binxml.BinXMLProcessorImpl;
import oracle.xml.binxml.BinXMLStream;
import oracle.xml.scalable.BinaryStream;
import oracle.xml.scalable.InfosetReader;
import oracle.xml.util.XMLError;

public class BinXMLStreamImpl
extends BinaryStream
implements BinXMLStream {
    boolean isURLStream = false;
    URL url = null;
    BinXMLProcessorImpl binXMLProcessor;
    String streamURI;
    XMLError err;

    @Override
    public BinXMLEncoder getEncoder() throws BinXMLException {
        BinXMLEncoderImpl binXMLEncoderImpl = new BinXMLEncoderImpl(this);
        binXMLEncoderImpl.setXMLError(this.err);
        if (this.isURLStream && this.pagedio == null) {
            this.pagedio = new BinaryStream.StreamPagedIO();
            try {
                ((BinaryStream.StreamPagedIO)this.pagedio).setInputStream(this.url.openStream());
            }
            catch (IOException iOException) {
                throw new BinXMLException(iOException);
            }
        }
        return binXMLEncoderImpl;
    }

    @Override
    public BinXMLDecoder getDecoder() throws BinXMLException {
        BinXMLDecoderImpl binXMLDecoderImpl = new BinXMLDecoderImpl(this);
        binXMLDecoderImpl.setXMLError(this.err);
        if (this.isURLStream && this.pagedio == null) {
            this.pagedio = new BinaryStream.StreamPagedIO();
            try {
                ((BinaryStream.StreamPagedIO)this.pagedio).setOutputStream(this.url.openConnection().getOutputStream());
            }
            catch (IOException iOException) {
                throw new BinXMLException(iOException);
            }
        }
        return binXMLDecoderImpl;
    }

    @Override
    public InfosetReader getInfosetReader() {
        try {
            return this.getDecoder().getReader();
        }
        catch (BinXMLException binXMLException) {
            throw new RuntimeException(binXMLException);
        }
    }

    public void setStreamURI(String string) {
        this.streamURI = string;
    }

    public String getStreamURI() {
        return this.streamURI;
    }

    BinXMLStreamImpl(BinXMLProcessor binXMLProcessor) {
        this.binXMLProcessor = (BinXMLProcessorImpl)binXMLProcessor;
        this.err = this.binXMLProcessor.getXMLError();
    }

    public BinXMLProcessor getBinXMLProcessor() {
        return this.binXMLProcessor;
    }

    void setURL(URL uRL) throws IOException {
        if (this.readers.size() > 0) {
            throw new RuntimeException();
        }
        this.isURLStream = true;
        this.url = uRL;
        if (uRL.getProtocol().equals("file")) {
            String string = uRL.getPath();
            this.pagedio = new BinaryStream.FilePagedIO(new File(string));
        }
    }

    long readBytes(BinXMLDecodeReader binXMLDecodeReader, byte[] byArray, long l2) throws BinXMLException {
        return binXMLDecodeReader.readBytes(this, byArray, l2);
    }

    long skipBytes(BinXMLDecodeReader binXMLDecodeReader, long l2) throws BinXMLException {
        return binXMLDecodeReader.skipBytes(this, l2);
    }

    static void writeNum2(int n2, byte[] byArray, int n3) {
        byArray[n3 + 1] = (byte)(n2 & 0xFF);
        byArray[n3] = (byte)((n2 >>= 8) & 0xFF);
    }

    static int readNum2(byte[] byArray, int n2) {
        int n3 = byArray[n2++] & 0xFF;
        n3 <<= 8;
        return n3 |= byArray[n2] & 0xFF;
    }

    static void writeNum4(long l2, byte[] byArray, int n2) {
        n2 += 3;
        byArray[n2--] = (byte)(l2 & 0xFFL);
        byArray[n2--] = (byte)((l2 >>= 8) & 0xFFL);
        byArray[n2--] = (byte)((l2 >>= 8) & 0xFFL);
        byArray[n2] = (byte)((l2 >>= 8) & 0xFFL);
    }

    static long readNum4(byte[] byArray, int n2) {
        long l2 = byArray[n2++] & 0xFF;
        l2 <<= 8;
        l2 |= (long)(byArray[n2++] & 0xFF);
        l2 <<= 8;
        l2 |= (long)(byArray[n2++] & 0xFF);
        l2 <<= 8;
        return l2 |= (long)(byArray[n2] & 0xFF);
    }

    static void writeNum8(long l2, byte[] byArray, int n2) {
        n2 += 7;
        byArray[n2--] = (byte)(l2 & 0xFFL);
        byArray[n2--] = (byte)((l2 >>= 8) & 0xFFL);
        byArray[n2--] = (byte)((l2 >>= 8) & 0xFFL);
        byArray[n2--] = (byte)((l2 >>= 8) & 0xFFL);
        byArray[n2--] = (byte)((l2 >>= 8) & 0xFFL);
        byArray[n2--] = (byte)((l2 >>= 8) & 0xFFL);
        byArray[n2--] = (byte)((l2 >>= 8) & 0xFFL);
        byArray[n2] = (byte)((l2 >>= 8) & 0xFFL);
    }

    static long readNum8(byte[] byArray, int n2) {
        long l2 = byArray[n2++] & 0xFF;
        l2 <<= 8;
        l2 |= (long)(byArray[n2++] & 0xFF);
        l2 <<= 8;
        l2 |= (long)(byArray[n2++] & 0xFF);
        l2 <<= 8;
        l2 |= (long)(byArray[n2++] & 0xFF);
        l2 <<= 8;
        l2 |= (long)(byArray[n2++] & 0xFF);
        l2 <<= 8;
        l2 |= (long)(byArray[n2++] & 0xFF);
        l2 <<= 8;
        l2 |= (long)(byArray[n2++] & 0xFF);
        l2 <<= 8;
        return l2 |= (long)(byArray[n2] & 0xFF);
    }

    static void copyByteArray(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        while (n3 > 0) {
            byArray2[n4++] = byArray[n2++];
            --n3;
        }
    }
}

