/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.binxml;

import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import oracle.xml.binxml.BinXMLException;
import oracle.xml.binxml.BinXMLMetadataProvider;
import oracle.xml.binxml.BinXMLProperty;
import oracle.xml.binxml.BinXMLSchema;
import oracle.xml.binxml.BinXMLSchemaAnnotator;
import oracle.xml.binxml.BinXMLStream;
import oracle.xml.binxml.BinXMLVocabId;
import oracle.xml.binxml.DBBinXMLMetadataProviderImpl;
import oracle.xml.util.XMLError;
import org.xml.sax.EntityResolver;

public class BinXMLVocabularyManager {
    Hashtable URLVocabId;
    Hashtable vocabIdBinXMLSchema;
    Hashtable vocabIdBinDTD;
    BinXMLMetadataProvider metaProvider;
    EntityResolver entresolver;
    boolean isSchemaAware;
    BinXMLSchema curbxschema;
    boolean debug = false;
    XMLError err;

    void setIsSchemaAware(boolean bl) {
        this.isSchemaAware = bl;
    }

    void setMetadataProvider(BinXMLMetadataProvider binXMLMetadataProvider) {
        this.metaProvider = binXMLMetadataProvider;
    }

    void setXMLError(XMLError xMLError) {
        this.err = xMLError;
    }

    BinXMLMetadataProvider getMetadataProvider() {
        return this.metaProvider;
    }

    public void setDebugMode(boolean bl) {
        this.debug = bl;
    }

    private void setCurrentBinXMLSchema(BinXMLSchema binXMLSchema) {
        BinXMLSchemaAnnotator binXMLSchemaAnnotator;
        this.curbxschema = binXMLSchema;
        if (this.entresolver != null && this.metaProvider != null && this.metaProvider instanceof DBBinXMLMetadataProviderImpl && this.curbxschema != null && (binXMLSchemaAnnotator = this.curbxschema.getSchemaAnnotator()) != null) {
            binXMLSchemaAnnotator.setEntityResolver(this.entresolver);
        }
    }

    BinXMLSchema getCurrentBinXMLSchema() {
        return this.curbxschema;
    }

    BinXMLVocabId saveSchema(URL uRL) throws BinXMLException {
        return this.saveSchema(uRL.toExternalForm());
    }

    BinXMLVocabId saveSchema(String string) throws BinXMLException {
        return this.metaProvider.saveSchema(string);
    }

    public BinXMLVocabId registerSchema(URL uRL) throws BinXMLException {
        BinXMLVocabId binXMLVocabId = this.getBinXMLVocabIdfromURL(uRL);
        if (binXMLVocabId != null) {
            return binXMLVocabId;
        }
        BinXMLSchema binXMLSchema = this.annotateSchema(uRL);
        this.setCurrentBinXMLSchema(binXMLSchema);
        binXMLVocabId = this.createVocabID(binXMLSchema);
        this.URLVocabId.put(uRL.toExternalForm(), binXMLVocabId);
        if (this.vocabIdBinXMLSchema == null) {
            this.vocabIdBinXMLSchema = new Hashtable(20, 0.5f);
        }
        this.vocabIdBinXMLSchema.put(binXMLVocabId, binXMLSchema);
        binXMLSchema.setSchemaId(binXMLVocabId);
        return binXMLVocabId;
    }

    BinXMLVocabId registerSchema(URL uRL, Reader reader) throws BinXMLException {
        return this.registerSchema(uRL, reader, null);
    }

    BinXMLVocabId registerSchema(String string, Reader reader, String[] stringArray) throws BinXMLException {
        return this.registerSchema((Object)string, reader, stringArray);
    }

    private BinXMLVocabId registerSchema(Object object, Reader reader, String[] stringArray) throws BinXMLException {
        String string;
        BinXMLSchema binXMLSchema;
        BinXMLVocabId binXMLVocabId = this.getBinXMLVocabIdfromURL(object);
        if (binXMLVocabId != null) {
            return binXMLVocabId;
        }
        if (object instanceof URL) {
            binXMLSchema = this.annotateSchema((URL)object, reader, null);
            string = ((URL)object).toExternalForm();
        } else {
            binXMLSchema = this.annotateSchema(null, reader, stringArray);
            string = (String)object;
        }
        this.setCurrentBinXMLSchema(binXMLSchema);
        if (this.metaProvider instanceof DBBinXMLMetadataProviderImpl) {
            binXMLVocabId = ((DBBinXMLMetadataProviderImpl)this.metaProvider).getSchemaID(string);
            if (binXMLVocabId == null) {
                binXMLVocabId = this.createVocabID(binXMLSchema);
            }
        } else {
            binXMLVocabId = this.createVocabID(binXMLSchema);
        }
        this.URLVocabId.put(string, binXMLVocabId);
        if (this.vocabIdBinXMLSchema == null) {
            this.vocabIdBinXMLSchema = new Hashtable(20, 0.5f);
        }
        this.vocabIdBinXMLSchema.put(binXMLVocabId, binXMLSchema);
        binXMLSchema.setSchemaId(binXMLVocabId);
        return binXMLVocabId;
    }

    private BinXMLSchema registerSchema(String[] stringArray, Reader[] readerArray, String[] stringArray2) throws BinXMLException {
        BinXMLSchema binXMLSchema = this.annotateSchema(readerArray, stringArray2);
        this.setCurrentBinXMLSchema(binXMLSchema);
        return binXMLSchema;
    }

    private void registerSchema(Reader reader, BinXMLVocabId binXMLVocabId) throws BinXMLException {
        BinXMLSchema binXMLSchema = this.annotateSchema(null, reader, null);
        this.setCurrentBinXMLSchema(binXMLSchema);
        if (this.vocabIdBinXMLSchema == null) {
            this.vocabIdBinXMLSchema = new Hashtable(20, 0.5f);
        }
        this.vocabIdBinXMLSchema.put(binXMLVocabId, binXMLSchema);
        binXMLSchema.setSchemaId(binXMLVocabId);
    }

    private boolean setVocabIdBinXMLSchemaMapping(BinXMLVocabId binXMLVocabId) throws BinXMLException {
        if (this.metaProvider == null) {
            return false;
        }
        Reader reader = ((DBBinXMLMetadataProviderImpl)this.metaProvider).getCompiledSchema(binXMLVocabId);
        this.registerSchema(reader, binXMLVocabId);
        return true;
    }

    BinXMLVocabId registerDTD(URL uRL) throws BinXMLException {
        return null;
    }

    BinXMLVocabId createVocabID(BinXMLSchema binXMLSchema) {
        byte[] byArray = new byte[16];
        int n2 = binXMLSchema.hashCode();
        byArray[0] = (byte)(n2 >> 0);
        byArray[1] = (byte)(n2 >> 4);
        byArray[2] = (byte)(n2 >> 8);
        byArray[3] = (byte)(n2 >> 12);
        BinXMLVocabId binXMLVocabId = new BinXMLVocabId();
        binXMLVocabId.setVocabID(byArray);
        return binXMLVocabId;
    }

    public BinXMLSchema getBinXMLSchema(BinXMLVocabId binXMLVocabId) {
        return (BinXMLSchema)this.vocabIdBinXMLSchema.get(binXMLVocabId);
    }

    public BinXMLSchema getBinXMLSchema(byte[] byArray) throws BinXMLException {
        Object object;
        if (this.vocabIdBinXMLSchema == null) {
            object = new BinXMLVocabId();
            ((BinXMLVocabId)object).setVocabID(byArray);
            boolean bl = this.setVocabIdBinXMLSchemaMapping((BinXMLVocabId)object);
            if (!bl) {
                return null;
            }
        }
        if (this.vocabIdBinXMLSchema.size() == 1) {
            object = (BinXMLSchema)this.vocabIdBinXMLSchema.elements().nextElement();
            return object;
        }
        object = this.vocabIdBinXMLSchema.keys();
        while (object.hasMoreElements()) {
            BinXMLVocabId binXMLVocabId = (BinXMLVocabId)object.nextElement();
            if (!this.compareByteArray(binXMLVocabId.getVocabID(), byArray)) continue;
            return (BinXMLSchema)this.vocabIdBinXMLSchema.get(binXMLVocabId);
        }
        return null;
    }

    private boolean compareByteArray(byte[] byArray, byte[] byArray2) {
        int n2;
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (n2 = 0; n2 < byArray.length && byArray[n2] == byArray2[n2]; ++n2) {
        }
        return n2 == byArray.length;
    }

    public BinXMLSchema getBinXMLSchema(URL uRL) {
        BinXMLVocabId binXMLVocabId = (BinXMLVocabId)this.URLVocabId.get(uRL.toExternalForm());
        if (binXMLVocabId != null) {
            return this.getBinXMLSchema(binXMLVocabId);
        }
        return null;
    }

    public BinXMLSchema getBinXMLSchema(String[] stringArray, String[] stringArray2) throws BinXMLException {
        if (this.metaProvider == null) {
            return null;
        }
        int n2 = stringArray.length;
        Reader[] readerArray = new Reader[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            readerArray[i2] = this.metaProvider.getCompiledSchema(stringArray[i2]);
            if (readerArray[i2] != null) continue;
            return null;
        }
        return this.registerSchema(stringArray, readerArray, stringArray2);
    }

    public BinXMLSchema getBinXMLSchema(String string, String[] stringArray) throws BinXMLException {
        Object object;
        if (this.URLVocabId == null && this.metaProvider != null && this.metaProvider instanceof DBBinXMLMetadataProviderImpl) {
            object = this.metaProvider.getCompiledSchema(string);
            this.registerSchema(string, (Reader)object, stringArray);
        }
        if ((object = (BinXMLVocabId)this.URLVocabId.get(string)) != null) {
            return this.getBinXMLSchema((BinXMLVocabId)object);
        }
        if (object == null && this.metaProvider != null && this.metaProvider instanceof DBBinXMLMetadataProviderImpl && stringArray != null) {
            Reader reader = this.metaProvider.getCompiledSchema(string);
            if (reader == null) {
                return null;
            }
            this.registerSchema(string, reader, stringArray);
        }
        return null;
    }

    public BinXMLSchema getBinXMLSchema(QName qName) {
        Enumeration enumeration = this.vocabIdBinXMLSchema.elements();
        while (enumeration.hasMoreElements()) {
            BinXMLSchema binXMLSchema = (BinXMLSchema)enumeration.nextElement();
            BinXMLProperty binXMLProperty = binXMLSchema.getRootElemProperty();
            if (!binXMLProperty.getQName().getNamespaceURI().equals(qName.getNamespaceURI()) || !binXMLProperty.getQName().getLocalPart().equals(qName.getLocalPart())) continue;
            return binXMLSchema;
        }
        return null;
    }

    BinXMLStream getBinaryDTD(BinXMLVocabId binXMLVocabId) {
        return null;
    }

    void setEntityResolver(EntityResolver entityResolver) {
        BinXMLSchemaAnnotator binXMLSchemaAnnotator;
        this.entresolver = entityResolver;
        if (entityResolver != null && this.metaProvider != null && this.metaProvider instanceof DBBinXMLMetadataProviderImpl && this.curbxschema != null && (binXMLSchemaAnnotator = this.curbxschema.getSchemaAnnotator()) != null) {
            binXMLSchemaAnnotator.setEntityResolver(entityResolver);
        }
    }

    private BinXMLSchema annotateSchema(URL uRL) {
        BinXMLSchema binXMLSchema = new BinXMLSchema(uRL);
        binXMLSchema.setXMLError(this.err);
        binXMLSchema.setDebugMode(this.debug);
        binXMLSchema.setMetadataProvider(this.metaProvider);
        binXMLSchema.annotate(null);
        return binXMLSchema;
    }

    private BinXMLSchema annotateSchema(URL uRL, Reader reader, String[] stringArray) {
        BinXMLSchema binXMLSchema = new BinXMLSchema(uRL, reader);
        binXMLSchema.setXMLError(this.err);
        binXMLSchema.setDebugMode(this.debug);
        binXMLSchema.setMetadataProvider(this.metaProvider);
        BinXMLSchemaAnnotator binXMLSchemaAnnotator = binXMLSchema.getSchemaAnnotator();
        binXMLSchemaAnnotator.setEntityResolver(this.entresolver);
        binXMLSchema.annotate(stringArray);
        return binXMLSchema;
    }

    private BinXMLSchema annotateSchema(Reader[] readerArray, String[] stringArray) {
        BinXMLSchema binXMLSchema = new BinXMLSchema(readerArray);
        binXMLSchema.setXMLError(this.err);
        binXMLSchema.setDebugMode(this.debug);
        binXMLSchema.setMetadataProvider(this.metaProvider);
        binXMLSchema.annotate(stringArray);
        return binXMLSchema;
    }

    private BinXMLVocabId getBinXMLVocabIdfromURL(Object object) {
        if (this.URLVocabId == null) {
            this.URLVocabId = new Hashtable(20, 0.5f);
            return null;
        }
        String string = object instanceof URL ? ((URL)object).toExternalForm() : (String)object;
        return (BinXMLVocabId)this.URLVocabId.get(string);
    }
}

