/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.common.format;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import oracle.xml.common.format.IntegerFormatter;

public abstract class DateTimeFormatter<E extends Exception>
extends IntegerFormatter<E> {
    private static String[] WeekDayShort = new String[]{"", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static String[] WeekDayFull = new String[]{"", "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    private static String[] YearMonthShort = new String[]{"", "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private String[] YearMonthFull = new String[]{"", "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static String MilitaryTimeZones = "YXWVUTSRQPONZABCDEFGHIKLM";
    private static int MilitaryTimeZonesZulu = MilitaryTimeZones.indexOf(90);

    @Override
    protected abstract E createInvalidPictureStringException(String var1);

    protected abstract E createComponentNotAvailableException(String var1);

    @Override
    protected abstract E notSupported(String var1);

    @Override
    boolean ignoreWhitespace() {
        return true;
    }

    public String format(Calendar calendar, String string, String string2, String string3, String string4, int n2, boolean bl) throws E {
        StringBuilder stringBuilder = new StringBuilder();
        PictureParseString pictureParseString = new PictureParseString(string);
        if (string2 != null && !string2.toLowerCase().equals("en")) {
            stringBuilder = stringBuilder.append("[Language: en]");
        }
        boolean bl2 = false;
        if (string3 != null) {
            if (string3.equals("ISO")) {
                calendar = (GregorianCalendar)calendar.clone();
                calendar.setFirstDayOfWeek(2);
                calendar.setMinimalDaysInFirstWeek(4);
                bl2 = true;
            } else if (!(string3.equals("AD") || string3.equals("BC") || string3.toLowerCase().equals("gregorian"))) {
                stringBuilder = stringBuilder.append("[Calendar: AD]");
            }
        }
        boolean bl3 = true;
        while (bl3) {
            bl3 = pictureParseString.nextLiteralString(stringBuilder);
        }
        while (pictureParseString.nextVarMarker()) {
            int n3 = pictureParseString.getComponentSpecifier();
            int n4 = pictureParseString.getMinWidth();
            int n5 = pictureParseString.getMaxWidth();
            if (n5 != -1 && (n4 > n5 || n5 < 1)) {
                throw this.createInvalidPictureStringException(string);
            }
            if (n4 != -1 && n4 < 1) {
                throw this.createInvalidPictureStringException(string);
            }
            block0 : switch (n3) {
                case 89: {
                    int n6;
                    int n7;
                    if (n2 < 2) {
                        throw this.createComponentNotAvailableException("Y");
                    }
                    int n8 = calendar.get(1);
                    if (n5 != -1) {
                        n8 = this.truncateYear(n8, n5);
                    } else if (pictureParseString.isDecimalDigitPattern()) {
                        n7 = 0;
                        n6 = pictureParseString.p1StartIdx;
                        while (n6 < pictureParseString.p1EndIdx) {
                            int n9 = string.codePointAt(n6);
                            n6 += Character.charCount(n9);
                            if (!Character.isDigit(n9) && n9 != 35) continue;
                            ++n7;
                        }
                        if (n7 > 1) {
                            n8 = this.truncateYear(n8, n7);
                        }
                    }
                    this.formatInteger(n8, string, pictureParseString, "1", stringBuilder);
                    break;
                }
                case 77: {
                    String string5;
                    if (n2 < 2) {
                        throw this.createComponentNotAvailableException("M");
                    }
                    int n8 = calendar.get(2) + 1;
                    String string6 = string5 = n5 != -1 && n5 < 8 ? YearMonthShort[n8] : this.YearMonthFull[n8];
                    if (pictureParseString.firstModifierIs("N")) {
                        stringBuilder.append(this.upper(string5));
                        break;
                    }
                    if (pictureParseString.firstModifierIs("n")) {
                        stringBuilder.append(this.lower(string5));
                        break;
                    }
                    if (pictureParseString.firstModifierIs("Nn")) {
                        stringBuilder.append(string5);
                        break;
                    }
                    this.formatInteger(n8, string, pictureParseString, "1", stringBuilder);
                    break;
                }
                case 68: {
                    if (n2 < 2) {
                        throw this.createComponentNotAvailableException("D");
                    }
                    int n8 = calendar.get(5);
                    this.formatInteger(n8, string, pictureParseString, "1", stringBuilder);
                    break;
                }
                case 100: {
                    if (n2 < 2) {
                        throw this.createComponentNotAvailableException("d");
                    }
                    int n7 = calendar.get(6);
                    this.formatInteger(n7, string, pictureParseString, "1", stringBuilder);
                    break;
                }
                case 70: {
                    String string7;
                    if (n2 < 2) {
                        throw this.createComponentNotAvailableException("F");
                    }
                    int n6 = calendar.get(7);
                    if (bl2) {
                        n6 = n6 == 1 ? 7 : --n6;
                    }
                    String string8 = string7 = n5 != -1 && n5 < 8 ? WeekDayShort[n6] : WeekDayFull[n6];
                    if (pictureParseString.firstModifierIs("N")) {
                        stringBuilder.append(this.upper(string7));
                        break;
                    }
                    if (pictureParseString.firstModifierIs("n") || !pictureParseString.hasFirstPresentationModifier()) {
                        stringBuilder.append(this.lower(string7));
                        break;
                    }
                    if (pictureParseString.firstModifierIs("Nn")) {
                        stringBuilder.append(string7);
                        break;
                    }
                    this.formatInteger(n6, string, pictureParseString, "n", stringBuilder);
                    break;
                }
                case 87: {
                    if (n2 < 2) {
                        throw this.createComponentNotAvailableException("W");
                    }
                    int n6 = calendar.get(3);
                    this.formatInteger(n6, string, pictureParseString, "1", stringBuilder);
                    break;
                }
                case 119: {
                    int n10;
                    if (n2 < 2) {
                        throw this.createComponentNotAvailableException("w");
                    }
                    int n11 = calendar.get(4);
                    if (n11 == 0) {
                        n10 = 0;
                        while (n11 == 0) {
                            ++n10;
                            calendar.add(5, -1);
                            n11 = calendar.get(4);
                        }
                        calendar.add(5, n10);
                    }
                    this.formatInteger(n11, string, pictureParseString, "1", stringBuilder);
                    break;
                }
                case 72: {
                    if (n2 == 2) {
                        throw this.createComponentNotAvailableException("H");
                    }
                    int n10 = calendar.get(11);
                    this.formatInteger(n10, string, pictureParseString, "1", stringBuilder);
                    break;
                }
                case 104: {
                    if (n2 == 2) {
                        throw this.createComponentNotAvailableException("h");
                    }
                    int n12 = calendar.get(10);
                    if (n12 == 0) {
                        n12 = 12;
                    }
                    this.formatInteger(n12, string, pictureParseString, "1", stringBuilder);
                    break;
                }
                case 80: {
                    if (n2 == 2) {
                        throw this.createComponentNotAvailableException("P");
                    }
                    int n13 = calendar.get(9);
                    if (pictureParseString.firstModifierIs("N")) {
                        stringBuilder.append(n13 == 0 ? "AM" : "PM");
                        break;
                    }
                    if (pictureParseString.firstModifierIs("Nn")) {
                        stringBuilder.append(n13 == 0 ? "Am" : "Pm");
                        break;
                    }
                    stringBuilder.append(n13 == 0 ? "am" : "pm");
                    break;
                }
                case 109: {
                    if (n2 == 2) {
                        throw this.createComponentNotAvailableException("m");
                    }
                    int n13 = calendar.get(12);
                    this.formatInteger(n13, string, pictureParseString, "01", stringBuilder);
                    break;
                }
                case 115: {
                    if (n2 == 2) {
                        throw this.createComponentNotAvailableException("s");
                    }
                    int n14 = calendar.get(13);
                    this.formatInteger(n14, string, pictureParseString, "01", stringBuilder);
                    break;
                }
                case 102: {
                    int n15;
                    int n16;
                    int n17;
                    int n18;
                    if (n2 == 2) {
                        throw this.createComponentNotAvailableException("f");
                    }
                    int n19 = -1;
                    StringBuilder stringBuilder2 = null;
                    int[] nArray = new int[]{0, 0};
                    if (pictureParseString.hasFirstPresentationModifier()) {
                        stringBuilder2 = new StringBuilder(pictureParseString.p1EndIdx - pictureParseString.p1StartIdx);
                        for (n17 = pictureParseString.p1StartIdx; n17 < pictureParseString.p1EndIdx; n17 += Character.charCount(n18)) {
                            n18 = string.codePointAt(n17);
                            stringBuilder2.appendCodePoint(n18);
                            if (!Character.isDigit(n18)) continue;
                            n19 = n18;
                            nArray[0] = nArray[0] + 1;
                        }
                    }
                    if (n19 == -1) {
                        stringBuilder2 = new StringBuilder("1");
                        n19 = 49;
                        nArray[0] = 1;
                    }
                    if (n5 == -1 && n4 == -1 && stringBuilder2.length() == 1) {
                        stringBuilder2.append("##");
                        nArray[1] = 2;
                    } else if (n5 != -1 || n4 != -1) {
                        stringBuilder2 = this.adjustFracSecPatternToWidth(stringBuilder2, n4, n5, nArray, n19);
                    }
                    stringBuilder2.reverse();
                    n17 = calendar.get(14);
                    n18 = 99 * (n17 % 10) + n17 % 100 + n17 / 100;
                    StringBuilder stringBuilder3 = new StringBuilder(stringBuilder2.length());
                    this.formatInteger(n18, stringBuilder2.toString(), stringBuilder3);
                    stringBuilder3.reverse();
                    int n20 = nArray[0] + nArray[1];
                    for (n15 = 0; n15 < stringBuilder3.length(); n15 += Character.charCount(n16)) {
                        n16 = stringBuilder3.codePointAt(n15);
                        if (Character.isDigit(n16) && --n20 < 0) break block0;
                        stringBuilder.appendCodePoint(n16);
                    }
                    break;
                }
                case 122: {
                    stringBuilder.append("GMT");
                }
                case 90: {
                    int n21;
                    int n19 = calendar.get(15);
                    if (pictureParseString.firstModifierIs("N")) {
                        TimeZone timeZone = calendar.getTimeZone();
                        boolean bl4 = timeZone.inDaylightTime(calendar.getTime());
                        stringBuilder.append(timeZone.getDisplayName(bl4, 0));
                        break;
                    }
                    if (!bl) {
                        if (!pictureParseString.firstModifierIs("Z")) break;
                        stringBuilder.append("J");
                        break;
                    }
                    if (n19 == 0 && pictureParseString.isTraditional() && pictureParseString.firstModifierIs("Z")) {
                        stringBuilder.append("Z");
                        break;
                    }
                    int n22 = n19 / 3600000;
                    int n23 = (n19 - n22 * 60 * 60 * 1000) / 60000;
                    int n17 = Math.abs(n23);
                    int n18 = Math.abs(n22);
                    int n24 = n18 * 100 + n17;
                    if (pictureParseString.firstModifierIs("Z")) {
                        if (n23 == 0 && n18 <= 12) {
                            stringBuilder.append(MilitaryTimeZones.charAt(n22 + MilitaryTimeZonesZulu));
                            break;
                        }
                        this.writeSign(stringBuilder, n19);
                        this.defaultTimeZone(stringBuilder, n24);
                        break;
                    }
                    if (n19 == 0 && pictureParseString.isTraditional()) {
                        stringBuilder.append("Z");
                        break;
                    }
                    this.writeSign(stringBuilder, n19);
                    if (!pictureParseString.hasFirstPresentationModifier()) {
                        this.defaultTimeZone(stringBuilder, n24);
                        break;
                    }
                    int n20 = 0;
                    int n15 = 0;
                    int n16 = -1;
                    int n25 = -1;
                    for (int i2 = pictureParseString.p1StartIdx; i2 < pictureParseString.p1EndIdx; i2 += Character.charCount(n21)) {
                        n21 = string.codePointAt(i2);
                        if (Character.isDigit(n21)) {
                            if (n25 == -1) {
                                n25 = n21 - Character.getNumericValue(n21);
                            } else if (n25 != n21 - Character.getNumericValue(n21)) {
                                throw this.createInvalidPictureStringException(string);
                            }
                            if (n16 == -1) {
                                ++n20;
                                continue;
                            }
                            ++n15;
                            continue;
                        }
                        if (DateTimeFormatter.isGroupingSeparator(n21) && n16 == -1) {
                            n16 = i2;
                            continue;
                        }
                        if (DateTimeFormatter.isWhitespace(n21)) continue;
                        n20 = -1;
                        break;
                    }
                    if (n20 == -1) {
                        throw this.createInvalidPictureStringException(string);
                    }
                    if (n16 == -1) {
                        if (n20 <= 2) {
                            this.formatPattern(n18, string, pictureParseString.p1StartIdx, pictureParseString.p1EndIdx - 1, stringBuilder);
                            if (n17 == 0) break;
                            stringBuilder.append(":");
                            this.formatPattern(n17, string, pictureParseString.p1StartIdx, pictureParseString.p1EndIdx - 1, stringBuilder);
                            break;
                        }
                        this.formatPattern(n24, string, pictureParseString.p1StartIdx, pictureParseString.p1EndIdx - 1, stringBuilder);
                        break;
                    }
                    if (n15 == -1) {
                        this.defaultTimeZone(stringBuilder, n24);
                        break;
                    }
                    this.formatPattern(n18, string, pictureParseString.p1StartIdx, n16 - 1, stringBuilder);
                    stringBuilder.appendCodePoint(string.codePointAt(n16));
                    this.formatPattern(n17, string, n16 + 1, pictureParseString.p1EndIdx - 1, stringBuilder);
                    break;
                }
                case 67: {
                    throw this.notSupported(string);
                }
                case 69: {
                    if (n2 < 2) {
                        throw this.createComponentNotAvailableException("E");
                    }
                    int n20 = calendar.get(0);
                    if (n20 == 1) {
                        stringBuilder.append("AD");
                        break;
                    }
                    stringBuilder.append("BC");
                    break;
                }
                default: {
                    throw this.createInvalidPictureStringException(string);
                }
            }
            bl3 = true;
            while (bl3) {
                bl3 = pictureParseString.nextLiteralString(stringBuilder);
            }
        }
        return stringBuilder.toString();
    }

    private StringBuilder adjustFracSecPatternToWidth(StringBuilder stringBuilder, int n2, int n3, int[] nArray, int n4) {
        if (n2 > nArray[0]) {
            int n5;
            StringBuilder stringBuilder2 = new StringBuilder();
            int n6 = n2;
            for (int i2 = 0; i2 < stringBuilder.length(); i2 += Character.charCount(n5)) {
                n5 = stringBuilder.codePointAt(i2);
                if (Character.isDigit(n5)) {
                    --n6;
                    stringBuilder2.appendCodePoint(n5);
                    continue;
                }
                if (n5 == 35) {
                    if (n6 > 0) {
                        stringBuilder2.appendCodePoint(n4);
                        nArray[1] = nArray[1] - 1;
                        --n6;
                        continue;
                    }
                    nArray[0] = nArray[0] + 1;
                    stringBuilder2.appendCodePoint(n5);
                    continue;
                }
                stringBuilder2.appendCodePoint(n5);
            }
            while (n6 > 0) {
                --n6;
                nArray[0] = nArray[0] + 1;
                stringBuilder2.appendCodePoint(n4);
            }
            stringBuilder = stringBuilder2;
        }
        if (n3 != -1) {
            for (int i3 = Math.min(n3, 3) - (nArray[0] + nArray[1]); i3 > 0; --i3) {
                stringBuilder.appendCodePoint(35);
                nArray[1] = nArray[1] + 1;
            }
        }
        return stringBuilder;
    }

    private void defaultTimeZone(StringBuilder stringBuilder, int n2) throws E {
        this.formatPattern(n2, "01:01", 0, 4, stringBuilder);
    }

    private void writeSign(StringBuilder stringBuilder, int n2) {
        if (n2 < 0) {
            stringBuilder.append("-");
        } else {
            stringBuilder.append("+");
        }
    }

    private String upper(String string) {
        return string.toUpperCase(Locale.US);
    }

    private String lower(String string) {
        return string.toLowerCase(Locale.US);
    }

    private void formatInteger(int n2, String string, PictureParseString pictureParseString, String string2, StringBuilder stringBuilder) throws E {
        if (pictureParseString.hasFirstPresentationModifier()) {
            this.formatInteger(n2, string, pictureParseString.p1StartIdx, pictureParseString.p1EndIdx, pictureParseString.isOrdinal(), pictureParseString.getMinWidth(), pictureParseString.getMaxWidth(), stringBuilder);
        } else {
            this.formatInteger(n2, string2, 0, string2.length(), false, pictureParseString.getMinWidth(), pictureParseString.getMaxWidth(), stringBuilder);
        }
    }

    private void formatInteger(int n2, String string, int n3, int n4, boolean bl, int n5, int n6, StringBuilder stringBuilder) throws E {
        int n7 = this.charsBetween(n3, n4, string);
        int n8 = stringBuilder.length();
        int n9 = string.codePointAt(n3);
        switch (n9) {
            case 65: {
                if (n7 != 1 || bl) {
                    throw this.createInvalidPictureStringException(string);
                }
                DateTimeFormatter.formatNumberA(n2, true, stringBuilder);
                this.pad(n8, n5, stringBuilder);
                return;
            }
            case 97: {
                if (n7 != 1 || bl) {
                    throw this.createInvalidPictureStringException(string);
                }
                DateTimeFormatter.formatNumberA(n2, false, stringBuilder);
                this.pad(n8, n5, stringBuilder);
                return;
            }
            case 73: {
                if (n7 != 1 || bl) {
                    throw this.createInvalidPictureStringException(string);
                }
                DateTimeFormatter.formatRoman(n2, true, stringBuilder);
                this.pad(n8, n5, stringBuilder);
                return;
            }
            case 105: {
                if (n7 != 1 || bl) {
                    throw this.createInvalidPictureStringException(string);
                }
                DateTimeFormatter.formatRoman(n2, false, stringBuilder);
                this.pad(n8, n5, stringBuilder);
                return;
            }
            case 87: {
                if (n7 == 2 && string.charAt(n3 + 1) == 'w') {
                    this.formatNumberName(n2, bl, null, stringBuilder);
                } else if (n7 == 1) {
                    this.formatNumberName(n2, bl, true, stringBuilder);
                } else {
                    throw this.createInvalidPictureStringException(string);
                }
                this.pad(n8, n5, stringBuilder);
                return;
            }
            case 119: {
                if (n7 != 1) {
                    throw this.createInvalidPictureStringException(string);
                }
                this.formatNumberName(n2, bl, false, stringBuilder);
                this.pad(n8, n5, stringBuilder);
                return;
            }
        }
        if (!DateTimeFormatter.isDigitPattern(string, n3, n4)) {
            throw this.createInvalidPictureStringException(string);
        }
        if (n5 == -1) {
            this.formatPattern(n2, string, n3, n4 - 1, stringBuilder);
            if (bl) {
                DateTimeFormatter.formatNumberOrdinal(n2, stringBuilder);
            }
            return;
        }
        StringBuilder stringBuilder2 = new StringBuilder(n4 - n3);
        int n10 = this.getZero(string, n3, n4);
        for (int i2 = n4 - 1; i2 >= n3; --i2) {
            int n11 = string.charAt(i2);
            if (i2 > 0 && Character.isSurrogatePair((char)n11, string.charAt(i2 - 1))) {
                n11 = string.codePointAt(--i2);
            }
            if (Character.isDigit(n11)) {
                --n5;
                stringBuilder2.appendCodePoint(n11);
                continue;
            }
            if (n11 == 35 && n5 > 0) {
                --n5;
                stringBuilder2.appendCodePoint(n10);
                continue;
            }
            stringBuilder2.appendCodePoint(n11);
        }
        while (n5 > 0) {
            stringBuilder2.appendCodePoint(n10);
            --n5;
        }
        stringBuilder2.reverse();
        this.formatPattern(n2, stringBuilder2.toString(), 0, stringBuilder2.length() - 1, stringBuilder);
        if (bl) {
            DateTimeFormatter.formatNumberOrdinal(n2, stringBuilder);
        }
    }

    private int getZero(String string, int n2, int n3) {
        int n4;
        int n5 = 48;
        for (int i2 = n2; i2 < n3; i2 += Character.charCount(n4)) {
            n4 = string.codePointAt(i2);
            if (!Character.isDigit(n4)) continue;
            n5 = n4 - Character.getNumericValue(n4);
            break;
        }
        return n5;
    }

    private void pad(int n2, int n3, StringBuilder stringBuilder) {
        if (n3 == -1) {
            return;
        }
        int n4 = stringBuilder.length() - n2;
        n3 -= n4;
        while (n3 > 0) {
            stringBuilder.append(" ");
            --n3;
        }
    }

    private int charsBetween(int n2, int n3, String string) {
        int n4 = 0;
        while (n2 < n3) {
            int n5 = string.codePointAt(n2);
            if (!Character.isWhitespace(n5)) {
                ++n4;
            }
            n2 += Character.charCount(n5);
        }
        return n4;
    }

    private static boolean isDigitPattern(String string, int n2, int n3) {
        int n4;
        for (int i2 = n2; i2 < n3; i2 += Character.charCount(n4)) {
            n4 = string.codePointAt(i2);
            if (!Character.isDigit(n4)) continue;
            return true;
        }
        return false;
    }

    private int truncateYear(int n2, int n3) {
        if (n3 == Integer.MAX_VALUE) {
            return n2;
        }
        int n4 = 1;
        while (n3 > 0) {
            n4 *= 10;
            --n3;
        }
        return n2 % n4;
    }

    class PictureParseString {
        String pic;
        int index;
        int componentSpecifierIdx;
        int p1StartIdx;
        int p1EndIdx;
        int p2Idx;
        int endOfModifiers;
        int minWidthIdx;
        int maxWidthIdx;

        PictureParseString(String string) {
            this.pic = string;
            this.index = 0;
            this.reset();
        }

        private void reset() {
            this.componentSpecifierIdx = -1;
            this.endOfModifiers = -1;
            this.p1StartIdx = -1;
            this.p1EndIdx = -1;
            this.p2Idx = -1;
            this.minWidthIdx = -1;
            this.maxWidthIdx = -1;
        }

        boolean nextLiteralString(StringBuilder stringBuilder) {
            int n2;
            if (this.index == this.pic.length()) {
                return false;
            }
            for (n2 = this.index; n2 < this.pic.length() && this.pic.codePointAt(n2) != 91 && this.pic.codePointAt(n2) != 93; n2 += Character.charCount(this.pic.codePointAt(n2))) {
            }
            stringBuilder.append(this.pic, this.index, n2);
            this.index = n2;
            if (this.index == this.pic.length()) {
                return true;
            }
            int n3 = this.pic.codePointAt(n2);
            if (n2 < this.pic.length() - 1 && this.pic.codePointAt(n2 + 1) == n3) {
                stringBuilder.appendCodePoint(n3);
                this.index += 2;
                return true;
            }
            return false;
        }

        int getComponentSpecifier() {
            return this.pic.codePointAt(this.componentSpecifierIdx);
        }

        boolean hasFirstPresentationModifier() {
            return this.p1StartIdx != -1;
        }

        public boolean isDecimalDigitPattern() {
            if (this.p1StartIdx == -1) {
                return false;
            }
            return DateTimeFormatter.isDigitPattern(this.pic, this.p1StartIdx, this.p1EndIdx);
        }

        boolean isOrdinal() {
            return this.p2Idx != -1 && this.pic.charAt(this.p2Idx) == 'o';
        }

        boolean isTraditional() {
            return this.p2Idx != -1 && this.pic.charAt(this.p2Idx) == 't';
        }

        public int getMaxWidth() throws Exception {
            if (this.maxWidthIdx == -1) {
                return -1;
            }
            String string = this.pic.substring(this.maxWidthIdx, this.index - 1);
            if (string.equals("*")) {
                return Integer.MAX_VALUE;
            }
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw DateTimeFormatter.this.createInvalidPictureStringException(string);
            }
        }

        public int getMinWidth() throws Exception {
            if (this.minWidthIdx == -1) {
                return -1;
            }
            int n2 = this.maxWidthIdx == -1 ? this.index - 1 : this.maxWidthIdx - 1;
            String string = this.pic.substring(this.minWidthIdx, n2);
            if (string.equals("*")) {
                return -1;
            }
            try {
                return Integer.parseInt(string);
            }
            catch (Exception exception) {
                Object e2 = DateTimeFormatter.this.createInvalidPictureStringException(this.pic);
                ((Throwable)e2).initCause(exception);
                throw e2;
            }
        }

        public boolean firstModifierIs(String string) {
            if (this.p1StartIdx == -1) {
                return false;
            }
            if (this.p1EndIdx - this.p1StartIdx != string.length()) {
                return false;
            }
            for (int i2 = this.p1StartIdx; i2 < this.p1EndIdx; ++i2) {
                if (this.pic.charAt(i2) == string.charAt(i2 - this.p1StartIdx)) continue;
                return false;
            }
            return true;
        }

        boolean nextVarMarker() throws Exception {
            int n2;
            this.reset();
            this.skipSpace();
            if (this.index >= this.pic.length()) {
                return false;
            }
            ++this.index;
            this.skipSpace();
            this.componentSpecifierIdx = this.index++;
            this.skipSpace();
            boolean bl = false;
            while (this.index < this.pic.length()) {
                n2 = this.pic.codePointAt(this.index);
                if (n2 == 93) {
                    if (this.endOfModifiers == -1) {
                        this.endOfModifiers = this.index;
                    }
                    ++this.index;
                    bl = true;
                    break;
                }
                if (n2 == 44) {
                    this.endOfModifiers = this.index;
                    this.minWidthIdx = this.index + 1;
                    this.maxWidthIdx = -1;
                } else if (n2 == 45 && this.minWidthIdx != -1) {
                    this.maxWidthIdx = this.index + 1;
                }
                this.index += Character.charCount(n2);
            }
            if (!bl) {
                throw DateTimeFormatter.this.createInvalidPictureStringException(this.pic);
            }
            while (IntegerFormatter.isWhitespace(this.pic.charAt(this.endOfModifiers - 1))) {
                --this.endOfModifiers;
            }
            n2 = DateTimeFormatter.this.charsBetween(this.componentSpecifierIdx + 1, this.endOfModifiers, this.pic);
            if (n2 == 1) {
                this.p1StartIdx = this.componentSpecifierIdx + 1;
                this.p1EndIdx = this.endOfModifiers;
            } else if (n2 > 1) {
                switch (this.pic.charAt(this.endOfModifiers - 1)) {
                    case 'a': 
                    case 'c': 
                    case 'o': 
                    case 't': {
                        this.p2Idx = this.endOfModifiers - 1;
                        this.p1StartIdx = this.componentSpecifierIdx + 1;
                        this.p1EndIdx = this.p2Idx;
                        break;
                    }
                    default: {
                        this.p1StartIdx = this.componentSpecifierIdx + 1;
                        this.p1EndIdx = this.endOfModifiers;
                    }
                }
            }
            return true;
        }

        private void skipSpace() {
            while (this.index < this.pic.length() && IntegerFormatter.isWhitespace(this.pic.charAt(this.index))) {
                ++this.index;
            }
        }
    }
}

