/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.common.format;

import java.util.Locale;

public abstract class IntegerFormatter<E extends Exception> {
    private static final byte MODIFIER_ORDINAL = 1;
    private static final byte MODIFIER_TRADITIONAL = 2;
    private static String[] NUMBER_WORDS = new String[]{"Zero", "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine", "Ten", "Eleven", "Twelve", "Thirteen", "Fourteen", "Fifteen", "Sixteen", "Seventeen", "Eighteen", "Nineteen"};
    private static String[] NUMBER_TENS = new String[]{"Twent", "Thirt", "Fort", "Fift", "Sixt", "Sevent", "Eight", "Ninet"};
    private static String[] NUMBER_WORDS_ORD = new String[]{"Zeroth", "First", "Second", "Third", "Fourth", "Fifth", "Sixth", "Seventh", "Eighth", "Ninth", "Tenth", "Eleventh", "Twelfth", "Thirteenth", "Fourteenth", "Fifteenth", "Sixteenth", "Seventeenth", "Eighteenth", "Nineteenth"};

    protected abstract E createInvalidPictureStringException(String var1);

    protected abstract E notSupported(String var1);

    public void formatInteger(long l2, String string, StringBuilder stringBuilder) throws E {
        byte by;
        int n2;
        int n3 = string.length();
        boolean bl = false;
        for (by = 0; by < string.length(); by += Character.charCount(n2)) {
            n2 = string.codePointAt(by);
            if (n2 == 59) {
                n3 = by;
                if (by != 0) continue;
                throw this.createInvalidPictureStringException(string);
            }
            if (!Character.isDigit(n2)) continue;
            bl = true;
        }
        if (n3 == 0) {
            throw this.createInvalidPictureStringException(string);
        }
        by = this.parseModifier(string, n3 + 1);
        if (l2 < 0L) {
            l2 = Math.abs(l2);
            stringBuilder.append("-");
        }
        if (bl) {
            this.formatPattern(l2, string, 0, n3 - 1, stringBuilder);
            if (IntegerFormatter.ordinal(by)) {
                IntegerFormatter.formatNumberOrdinal(l2, stringBuilder);
            }
            return;
        }
        n2 = string.charAt(0);
        switch (n2) {
            case 65: {
                IntegerFormatter.formatNumberA(l2, true, stringBuilder);
                return;
            }
            case 97: {
                IntegerFormatter.formatNumberA(l2, false, stringBuilder);
                return;
            }
            case 73: {
                IntegerFormatter.formatRoman(l2, true, stringBuilder);
                return;
            }
            case 105: {
                IntegerFormatter.formatRoman(l2, false, stringBuilder);
                return;
            }
            case 87: {
                if (string.length() > 1 && string.charAt(1) == 'w') {
                    this.formatNumberName(l2, IntegerFormatter.ordinal(by), null, stringBuilder);
                } else {
                    this.formatNumberName(l2, IntegerFormatter.ordinal(by), true, stringBuilder);
                }
                return;
            }
            case 119: {
                this.formatNumberName(l2, IntegerFormatter.ordinal(by), false, stringBuilder);
                return;
            }
        }
        stringBuilder.append(Long.toString(l2));
        if (IntegerFormatter.ordinal(by)) {
            IntegerFormatter.formatNumberOrdinal(l2, stringBuilder);
        }
    }

    private static boolean ordinal(byte by) {
        return (by & 1) != 0;
    }

    private byte parseModifier(String string, int n2) throws E {
        if (n2 >= string.length()) {
            return 0;
        }
        byte by = 0;
        char c2 = string.charAt(n2);
        if (c2 == 'c' || c2 == 'o') {
            if (c2 == 'o') {
                by = (byte)(by | 1);
            }
            if (++n2 >= string.length()) {
                return by;
            }
            c2 = string.charAt(n2);
            if (c2 == '(') {
                int n3;
                for (n3 = ++n2; n3 < string.length() && string.charAt(n3) != ')'; ++n3) {
                }
                if (n3 == string.length()) {
                    throw this.createInvalidPictureStringException(string);
                }
                String string2 = string.substring(n2, n3);
                if (!"".equals(string2) && !"-en".equals(string2)) {
                    throw this.createInvalidPictureStringException(string);
                }
                n2 = n3 + 1;
                if (n2 >= string.length()) {
                    return by;
                }
                c2 = string.charAt(n2);
            }
        }
        if (c2 == 't' || c2 == 'a') {
            if (c2 == 't') {
                by = (byte)(by | 2);
            }
            if (++n2 == string.length()) {
                return by;
            }
        }
        throw this.createInvalidPictureStringException(string);
    }

    protected void formatNumberName(long l2, boolean bl, Boolean bl2, StringBuilder stringBuilder) throws E {
        long l3 = 0L;
        boolean bl3 = false;
        if (l2 == 0L) {
            if (bl) {
                stringBuilder.append(IntegerFormatter.upper(NUMBER_WORDS_ORD[0], bl2));
            } else {
                stringBuilder.append(IntegerFormatter.upper(NUMBER_WORDS[0], bl2));
            }
            return;
        }
        long l4 = stringBuilder.length();
        if (l2 >= 1000L) {
            l3 = l2 / 1000L;
            if (l3 > (long)NUMBER_WORDS.length) {
                throw this.notSupported(String.valueOf(l2));
            }
            stringBuilder.append(IntegerFormatter.upper(NUMBER_WORDS[(int)l3], bl2)).append(' ').append(IntegerFormatter.upper("Thousand", bl2));
            if ((l2 %= 1000L) == 0L && bl) {
                stringBuilder.append(IntegerFormatter.upper("th", bl2));
            }
            bl3 = true;
        }
        if (l2 >= 100L) {
            l3 = l2 / 100L;
            if ((long)stringBuilder.length() > l4) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(IntegerFormatter.upper(NUMBER_WORDS[(int)l3], bl2)).append(IntegerFormatter.upper(" Hundred", bl2));
            if ((l2 %= 100L) == 0L && bl) {
                stringBuilder.append(IntegerFormatter.upper("th", bl2));
            }
            bl3 = true;
        }
        if (l2 >= 20L) {
            if (bl3) {
                stringBuilder.append(IntegerFormatter.upper(" and", bl2));
            }
            l3 = l2 / 10L;
            if ((long)stringBuilder.length() > l4) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(IntegerFormatter.upper(NUMBER_TENS[(int)(l3 - 2L)], bl2));
            if ((l2 %= 10L) == 0L && bl) {
                stringBuilder.append(IntegerFormatter.upper("ieth", bl2));
            } else {
                stringBuilder.append(IntegerFormatter.upper("y", bl2));
            }
            bl3 = false;
        }
        if (l2 == 0L) {
            return;
        }
        if (!bl) {
            if (bl3) {
                stringBuilder.append(IntegerFormatter.upper(" and", bl2));
            }
            if ((long)stringBuilder.length() > l4) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(IntegerFormatter.upper(NUMBER_WORDS[(int)l2], bl2));
        } else {
            if (bl3) {
                stringBuilder.append(IntegerFormatter.upper(" and", bl2));
            }
            if ((long)stringBuilder.length() > l4) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(IntegerFormatter.upper(NUMBER_WORDS_ORD[(int)l2], bl2));
        }
    }

    private static Object upper(String string, Boolean bl) {
        if (bl == null) {
            return string;
        }
        if (bl.booleanValue()) {
            return string.toUpperCase(Locale.US);
        }
        return string.toLowerCase(Locale.US);
    }

    protected static void formatNumberOrdinal(long l2, StringBuilder stringBuilder) {
        long l3 = l2 % 10L;
        long l4 = l2 % 100L;
        if (l3 == 1L && l4 != 11L) {
            stringBuilder.append("st");
        } else if (l3 == 2L && l4 != 12L) {
            stringBuilder.append("nd");
        } else if (l3 == 3L && l4 != 13L) {
            stringBuilder.append("rd");
        } else {
            stringBuilder.append("th");
        }
    }

    protected static void formatRoman(long l2, boolean bl, StringBuilder stringBuilder) {
        while (l2 > 0L) {
            if (l2 >= 1000L) {
                stringBuilder.append(bl ? "M" : "m");
                l2 -= 1000L;
                continue;
            }
            if (l2 >= 900L) {
                stringBuilder.append(bl ? "CM" : "cm");
                l2 -= 900L;
                continue;
            }
            if (l2 >= 500L) {
                stringBuilder.append(bl ? "D" : "d");
                l2 -= 500L;
                continue;
            }
            if (l2 >= 400L) {
                stringBuilder.append(bl ? "CD" : "cd");
                l2 -= 400L;
                continue;
            }
            if (l2 >= 100L) {
                stringBuilder.append(bl ? "C" : "c");
                l2 -= 100L;
                continue;
            }
            if (l2 >= 90L) {
                stringBuilder.append(bl ? "XC" : "xc");
                l2 -= 90L;
                continue;
            }
            if (l2 >= 50L) {
                stringBuilder.append(bl ? "L" : "l");
                l2 -= 50L;
                continue;
            }
            if (l2 >= 40L) {
                stringBuilder.append(bl ? "XL" : "xl");
                l2 -= 40L;
                continue;
            }
            if (l2 >= 10L) {
                stringBuilder.append(bl ? "X" : "x");
                l2 -= 10L;
                continue;
            }
            if (l2 >= 9L) {
                stringBuilder.append(bl ? "IX" : "ix");
                l2 -= 9L;
                continue;
            }
            if (l2 >= 5L) {
                stringBuilder.append(bl ? "V" : "v");
                l2 -= 5L;
                continue;
            }
            if (l2 >= 4L) {
                stringBuilder.append(bl ? "IV" : "iv");
                l2 -= 4L;
                continue;
            }
            stringBuilder.append(bl ? "I" : "i");
            --l2;
        }
    }

    protected static void formatNumberA(long l2, boolean bl, StringBuilder stringBuilder) {
        int n2;
        if (l2 == 0L) {
            stringBuilder.append("0");
            return;
        }
        int n3 = stringBuilder.length();
        int n4 = n2 = bl ? 65 : 97;
        while (l2 > 0L) {
            char c2;
            long l3 = l2 % 26L;
            l2 /= 26L;
            if (l3 > 0L) {
                c2 = (char)((long)n2 + (l3 - 1L));
            } else {
                c2 = (char)(n2 + 25);
                --l2;
            }
            stringBuilder.append(c2);
        }
        int n5 = n3;
        for (int i2 = stringBuilder.length() - 1; n5 < i2; ++n5, --i2) {
            char c3 = stringBuilder.charAt(n5);
            char c4 = stringBuilder.charAt(i2);
            stringBuilder.setCharAt(n5, c4);
            stringBuilder.setCharAt(i2, c3);
        }
    }

    protected void formatPattern(long l2, String string, int n2, int n3, StringBuilder stringBuilder) throws E {
        char c2;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        String string2 = Long.toString(l2);
        int n9 = string2.length() - 1;
        int n10 = stringBuilder.length();
        int n11 = -1;
        int n12 = -1;
        int n13 = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n14 = -1;
        for (int i2 = n3; i2 >= n2; --i2) {
            if (Character.isLowSurrogate(string.charAt(i2)) && --i2 < 0) {
                throw this.createInvalidPictureStringException(string);
            }
            n8 = string.codePointAt(i2);
            if (Character.isDigit(n8)) {
                if (bl2) {
                    throw this.createInvalidPictureStringException(string);
                }
                bl = false;
                n7 = Character.getNumericValue(n8);
                n6 = n8 - n7;
                if (n14 == -1) {
                    n14 = n6;
                } else if (n14 != n6) {
                    throw this.createInvalidPictureStringException(string);
                }
                ++n13;
                if (n9 >= 0) {
                    n5 = string2.codePointAt(n9);
                    stringBuilder.appendCodePoint(Character.getNumericValue(n5) + n6);
                    --n9;
                    continue;
                }
                stringBuilder.appendCodePoint(n6);
                continue;
            }
            if (n8 == 35) {
                bl2 = true;
                bl = false;
                if (n9 < 0) break;
                n7 = string2.codePointAt(n9);
                n6 = n14 == -1 ? 0 : n14;
                stringBuilder.appendCodePoint(n6 + Character.getNumericValue(n7));
                --n9;
                if (++n13 <= n12) continue;
                n11 = -2;
                continue;
            }
            if (this.ignoreWhitespace() && IntegerFormatter.isWhitespace(n8)) continue;
            if (IntegerFormatter.isGroupingSeparator(n8)) {
                if (i2 == n3 || i2 == n2 || bl) {
                    throw this.createInvalidPictureStringException(string);
                }
                bl = true;
                if (n9 < 0 && !this.hasRemainingDigits(string, i2, n2)) break;
                stringBuilder.appendCodePoint(n8);
                if (n11 == -1) {
                    n11 = n8;
                    n12 = n13;
                } else if (n11 == n8) {
                    if (n12 == -1) {
                        n12 = n13;
                    } else if (n12 != n13) {
                        n11 = -2;
                    }
                } else {
                    n11 = -2;
                }
                n13 = 0;
                continue;
            }
            throw this.createInvalidPictureStringException(string);
        }
        int n15 = n8 = n14 == -1 ? 0 : n14;
        while (n9 >= 0) {
            if (n11 > 0 && n13 == n12) {
                stringBuilder.appendCodePoint(n11);
                n13 = 0;
            }
            n7 = string2.codePointAt(n9);
            stringBuilder.appendCodePoint(Character.getNumericValue(n7) + n8);
            ++n13;
            --n9;
        }
        n7 = n10;
        n5 = 0;
        for (n6 = stringBuilder.length() - 1; n7 < n6; ++n7, --n6) {
            n4 = stringBuilder.charAt(n7);
            c2 = stringBuilder.charAt(n6);
            stringBuilder.setCharAt(n6, (char)n4);
            stringBuilder.setCharAt(n7, c2);
            if (!IntegerFormatter.isSurrogate(n4) && !IntegerFormatter.isSurrogate(c2)) continue;
            n5 = 1;
        }
        if (n5 != 0) {
            for (n4 = n10; n4 < stringBuilder.length() - 1; ++n4) {
                c2 = stringBuilder.charAt(n4);
                char c3 = stringBuilder.charAt(n4 + '\u0001');
                if (!Character.isSurrogatePair(c3, c2)) continue;
                stringBuilder.setCharAt(n4, c3);
                stringBuilder.setCharAt(++n4, c2);
            }
        }
    }

    boolean ignoreWhitespace() {
        return false;
    }

    private boolean hasRemainingDigits(String string, int n2, int n3) {
        int n4;
        for (int i2 = n3; i2 < n2; i2 += Character.charCount(n4)) {
            n4 = string.codePointAt(i2);
            if (!Character.isDigit(n4)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSurrogate(int n2) {
        return n2 >= 55296 && n2 < 57344;
    }

    static boolean isGroupingSeparator(int n2) {
        int n3 = Character.getType(n2);
        return n3 != 9 && n3 != 10 && n3 != 11 && n3 != 1 && n3 != 2 && n3 != 3 && n3 != 4 && n3 != 5;
    }

    static boolean isWhitespace(int n2) {
        return n2 == 9 || n2 == 10 || n2 == 13 || n2 == 32;
    }
}

