/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.common.format;

import java.math.BigDecimal;
import java.math.RoundingMode;
import oracle.xml.common.format.DecimalFormatProperties;
import oracle.xml.common.format.Picture;
import oracle.xml.common.format.SubPicture;

public abstract class NumberFormatter<E extends Exception> {
    protected abstract E createInvalidPictureStringException(String var1);

    public Picture parsePicture(String string, DecimalFormatProperties<E> decimalFormatProperties) throws E {
        Picture picture = new Picture();
        SubPicture subPicture = picture.subPicture1 = new SubPicture(0);
        boolean bl = false;
        int n2 = 0;
        while (n2 < string.length()) {
            int n3;
            int n4 = string.codePointAt(n2);
            if (n4 == decimalFormatProperties.getPatternSeparator()) {
                if (picture.subPicture2 != null) {
                    throw this.createInvalidPictureStringException(string);
                }
                subPicture.end = n2;
                this.finishParsing(string, subPicture, bl, decimalFormatProperties);
                this.setMinMaxActiveCharacter(subPicture, n2);
                subPicture = picture.subPicture2 = new SubPicture(n2 += Character.charCount(n4));
                bl = false;
                continue;
            }
            if (n4 == decimalFormatProperties.getDecimalSeparator()) {
                if (subPicture.decimalSepPos != -1) {
                    throw this.createInvalidPictureStringException(string);
                }
                n3 = this.previousIndex(n2, string);
                if (n3 >= 0 && string.codePointAt(n3) == decimalFormatProperties.getGroupingSeparator()) {
                    throw this.createInvalidPictureStringException(string);
                }
                this.setMinMaxActiveCharacter(subPicture, n2);
                subPicture.decimalSepPos = n2;
            } else if (n4 == decimalFormatProperties.getPercent()) {
                if (subPicture.percentPos != -1 || subPicture.perMillePos != -1) {
                    throw this.createInvalidPictureStringException(string);
                }
                subPicture.percentPos = n2;
            } else if (n4 == decimalFormatProperties.getPerMille()) {
                if (subPicture.percentPos != -1 || subPicture.perMillePos != -1) {
                    throw this.createInvalidPictureStringException(string);
                }
                subPicture.perMillePos = n2;
            } else if (n4 == decimalFormatProperties.getGroupingSeparator()) {
                int n5;
                n3 = this.previousIndex(n2, string);
                if (n3 >= 0 && ((n5 = string.codePointAt(n3)) == decimalFormatProperties.getGroupingSeparator() || n5 == decimalFormatProperties.getDecimalSeparator())) {
                    throw this.createInvalidPictureStringException(string);
                }
                this.setMinMaxActiveCharacter(subPicture, n2);
            } else if (n4 == decimalFormatProperties.getDigit()) {
                bl = true;
                this.setMinMaxActiveCharacter(subPicture, n2);
            } else if (this.isMemberOfDecimalDigitFamily(n4, decimalFormatProperties)) {
                bl = true;
                this.setMinMaxActiveCharacter(subPicture, n2);
            } else if (subPicture.minActiveCharacter != -1 && subPicture.unknownCharPos == -1) {
                subPicture.unknownCharPos = n2;
            }
            n2 += Character.charCount(n4);
        }
        subPicture.end = string.length();
        this.finishParsing(string, subPicture, bl, decimalFormatProperties);
        return picture;
    }

    private void finishParsing(String string, SubPicture subPicture, boolean bl, DecimalFormatProperties<E> decimalFormatProperties) throws E {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (!bl) {
            throw this.createInvalidPictureStringException(string);
        }
        if (subPicture.unknownCharPos > subPicture.minActiveCharacter && subPicture.unknownCharPos < subPicture.maxActiveCharacter) {
            throw this.createInvalidPictureStringException(string);
        }
        boolean bl2 = false;
        for (n5 = subPicture.start; n5 < subPicture.integerPartEndPos(); n5 += Character.charCount(n6)) {
            n6 = string.codePointAt(n5);
            if (this.isMemberOfDecimalDigitFamily(n6, decimalFormatProperties)) {
                bl2 = true;
                ++subPicture.minimumIntegerPartSize;
                subPicture.addDigit();
                continue;
            }
            if (n6 == decimalFormatProperties.getDigit()) {
                if (bl2) {
                    throw this.createInvalidPictureStringException(string);
                }
                subPicture.addDigit();
                continue;
            }
            if (n6 != decimalFormatProperties.getGroupingSeparator()) continue;
            subPicture.integerPartGroupingPositions.add(0);
        }
        if (subPicture.integerPartGroupingPositions.size() > 0) {
            n5 = subPicture.integerPartGroupingPositions.size();
            n6 = subPicture.integerPartGroupingPositions.get(n5 - 1);
            for (n4 = n5 - 2; n4 >= 0; --n4) {
                n3 = subPicture.integerPartGroupingPositions.get(n4);
                if (n3 % n6 == 0 && n3 / n6 == n5 - n4) continue;
                n6 = -1;
                break;
            }
            n4 = 0;
            if (n6 != -1) {
                n2 = n3 = this.previousIndex(subPicture.integerPartEndPos(), string);
                while (n2 >= subPicture.start) {
                    int n7 = string.codePointAt(n2);
                    if (++n4 % (n6 + 1) == 0 && n7 != decimalFormatProperties.getGroupingSeparator()) {
                        n6 = -1;
                        break;
                    }
                    n2 = this.previousIndex(n2, string);
                }
            }
            subPicture.regularGroupingMultiple = n6;
        }
        n5 = 0;
        n6 = subPicture.fractionalPartBeginPos();
        for (n3 = n4 = this.nextIndex(n6, string.codePointAt(n6)); n3 < subPicture.mantissaPartEndPos(); n3 += Character.charCount(n2)) {
            n2 = string.codePointAt(n3);
            if (n2 == decimalFormatProperties.getDigit()) {
                n5 = 1;
                ++subPicture.maximumFractionalPartSize;
                continue;
            }
            if (this.isMemberOfDecimalDigitFamily(n2, decimalFormatProperties)) {
                if (n5 != 0) {
                    throw this.createInvalidPictureStringException(string);
                }
                ++subPicture.minimumFractionalPartSize;
                ++subPicture.maximumFractionalPartSize;
                continue;
            }
            if (n2 != decimalFormatProperties.getGroupingSeparator()) continue;
            subPicture.fractionalPartGroupingPositions.add(subPicture.maximumFractionalPartSize);
        }
        if (subPicture.decimalSepPos == -1 && (n3 = this.previousIndex(subPicture.integerPartEndPos(), string)) > 0 && string.codePointAt(n3) == decimalFormatProperties.getGroupingSeparator()) {
            throw this.createInvalidPictureStringException(string);
        }
        if (subPicture.minimumIntegerPartSize == 0 && subPicture.maximumFractionalPartSize == 0) {
            subPicture.minimumIntegerPartSize = 1;
        }
        if (subPicture.minimumIntegerPartSize == 0 && subPicture.minimumFractionalPartSize == 0) {
            subPicture.minimumFractionalPartSize = 1;
        }
    }

    private boolean isMemberOfDecimalDigitFamily(int n2, DecimalFormatProperties<E> decimalFormatProperties) {
        return n2 >= decimalFormatProperties.getZeroDigit() && n2 <= decimalFormatProperties.getNineDigit();
    }

    private int getCorrespondingDecimalDigit(char c2, int n2) {
        int n3 = c2 - 48;
        return n2 + n3;
    }

    private int previousIndex(int n2, String string) {
        int n3 = n2 - 1;
        if (n3 < 0) {
            return -1;
        }
        if (this.isSurrogate(string.charAt(n3))) {
            --n3;
        }
        return n3;
    }

    private int previousIndex(int n2, StringBuilder stringBuilder) {
        int n3 = n2 - 1;
        if (n3 < 0) {
            return -1;
        }
        if (this.isSurrogate(stringBuilder.charAt(n3))) {
            --n3;
        }
        return n3;
    }

    private int nextIndex(int n2, int n3) {
        return n2 + Character.charCount(n3);
    }

    private boolean isSurrogate(char c2) {
        return c2 >= '\ud800' && c2 <= '\udfff';
    }

    private void setMinMaxActiveCharacter(SubPicture subPicture, int n2) {
        if (subPicture.minActiveCharacter == -1) {
            subPicture.minActiveCharacter = n2;
        }
        subPicture.maxActiveCharacter = n2;
    }

    private void suffix(SubPicture subPicture, StringBuilder stringBuilder, String string) {
        int n2;
        int n3;
        int n4 = subPicture.maxActiveCharacter;
        for (int i2 = n2 = this.nextIndex(n4, string.codePointAt(n4)); i2 < subPicture.end; i2 += Character.charCount(n3)) {
            n3 = string.codePointAt(i2);
            stringBuilder.appendCodePoint(n3);
        }
    }

    private void prefix(SubPicture subPicture, SubPicture subPicture2, StringBuilder stringBuilder, boolean bl, String string, DecimalFormatProperties<E> decimalFormatProperties) {
        int n2;
        if (subPicture == subPicture2 && bl) {
            char[] cArray = Character.toChars(decimalFormatProperties.getMinusSign());
            stringBuilder.append(cArray);
        }
        for (int i2 = subPicture.start; i2 < subPicture.minActiveCharacter; i2 += Character.charCount(n2)) {
            n2 = string.codePointAt(i2);
            stringBuilder.appendCodePoint(n2);
        }
    }

    private boolean isNegativeZero(double d2) {
        return d2 == 0.0 && 1.0 / d2 == Double.NEGATIVE_INFINITY;
    }

    private void infinity(StringBuilder stringBuilder, boolean bl, SubPicture subPicture, SubPicture subPicture2, String string, DecimalFormatProperties<E> decimalFormatProperties) {
        this.prefix(subPicture, subPicture2, stringBuilder, bl, string, decimalFormatProperties);
        stringBuilder.append(decimalFormatProperties.getInfinity());
        this.suffix(subPicture, stringBuilder, string);
    }

    private BigDecimal roundHalfToEven(BigDecimal bigDecimal, int n2) {
        return n2 == 0 ? bigDecimal.setScale(0, RoundingMode.HALF_EVEN) : bigDecimal.movePointRight(n2).setScale(0, RoundingMode.HALF_EVEN).movePointLeft(n2);
    }

    public void formatDouble(double d2, Picture picture, DecimalFormatProperties<E> decimalFormatProperties, StringBuilder stringBuilder, String string) throws E {
        if (Double.isNaN(d2)) {
            stringBuilder.append(decimalFormatProperties.getNan());
            return;
        }
        this.formatDouble(d2, stringBuilder, picture, string, decimalFormatProperties);
    }

    public void formatFloat(float f2, Picture picture, DecimalFormatProperties<E> decimalFormatProperties, StringBuilder stringBuilder, String string) throws E {
        if (Float.isNaN(f2)) {
            stringBuilder.append(decimalFormatProperties.getNan());
            return;
        }
        this.formatDouble((double)f2, stringBuilder, picture, string, decimalFormatProperties);
    }

    public void formatDecimal(BigDecimal bigDecimal, Picture picture, DecimalFormatProperties<E> decimalFormatProperties, StringBuilder stringBuilder, String string) throws E {
        SubPicture subPicture;
        if (bigDecimal == null) {
            stringBuilder.append(decimalFormatProperties.getNan());
            return;
        }
        boolean bl = bigDecimal.compareTo(BigDecimal.ZERO) == -1;
        SubPicture subPicture2 = subPicture = picture.subPicture2 != null && bl ? picture.subPicture2 : picture.subPicture1;
        if (subPicture.percentPos != -1) {
            bigDecimal = bigDecimal.multiply(BigDecimal.valueOf(100L));
        } else if (subPicture.perMillePos != -1) {
            bigDecimal = bigDecimal.multiply(BigDecimal.valueOf(1000L));
        }
        BigDecimal bigDecimal2 = bigDecimal.abs();
        BigDecimal bigDecimal3 = this.roundHalfToEven(bigDecimal2, subPicture.maximumFractionalPartSize);
        String string2 = this.format(subPicture, bigDecimal3, decimalFormatProperties);
        this.prefix(subPicture, picture.subPicture1, stringBuilder, bl, string, decimalFormatProperties);
        stringBuilder.append(string2);
        this.suffix(subPicture, stringBuilder, string);
    }

    public void formatLong(long l2, Picture picture, DecimalFormatProperties<E> decimalFormatProperties, StringBuilder stringBuilder, String string) throws E {
        int n2;
        int n3;
        SubPicture subPicture;
        boolean bl = l2 < 0L;
        SubPicture subPicture2 = subPicture = picture.subPicture2 != null && bl ? picture.subPicture2 : picture.subPicture1;
        if (subPicture.percentPos != -1) {
            l2 *= 100L;
        } else if (subPicture.perMillePos != -1) {
            l2 *= 1000L;
        }
        if (l2 < 0L && !bl || l2 >= 0L && bl) {
            this.infinity(stringBuilder, bl, subPicture, picture.subPicture1, string, decimalFormatProperties);
            return;
        }
        int n4 = (l2 = Math.abs(l2)) > 0L ? (int)(Math.log10(l2) + 1.0) : 0;
        StringBuilder stringBuilder2 = new StringBuilder(n4 + (n3 > 0 ? n3 : 0));
        for (n3 = subPicture.minimumIntegerPartSize - n4; n3 > 0; --n3) {
            stringBuilder2.appendCodePoint(decimalFormatProperties.getZeroDigit());
        }
        if (l2 != 0L) {
            StringBuilder stringBuilder3 = new StringBuilder(n4);
            while (l2 != 0L) {
                n2 = (int)(l2 % 10L);
                stringBuilder3.appendCodePoint(decimalFormatProperties.getZeroDigit() + n2);
                l2 /= 10L;
            }
            int n5 = n2 = this.previousIndex(stringBuilder3.length(), stringBuilder3);
            while (n5 >= 0) {
                stringBuilder2.appendCodePoint(stringBuilder3.codePointAt(n5));
                n5 = this.previousIndex(n5, stringBuilder3);
            }
        }
        int n6 = -1;
        if (subPicture.minimumFractionalPartSize > 0 && subPicture.decimalSepPos != -1) {
            n6 = stringBuilder2.length();
            stringBuilder2.appendCodePoint(decimalFormatProperties.getDecimalSeparator());
            for (n2 = 0; n2 < subPicture.minimumFractionalPartSize; ++n2) {
                stringBuilder2.appendCodePoint(decimalFormatProperties.getZeroDigit());
            }
        }
        this.addGroupingSeparators(n6, stringBuilder2, subPicture, decimalFormatProperties);
        this.prefix(subPicture, picture.subPicture1, stringBuilder, bl, string, decimalFormatProperties);
        stringBuilder.append((CharSequence)stringBuilder2);
        this.suffix(subPicture, stringBuilder, string);
    }

    private void formatDouble(double d2, StringBuilder stringBuilder, Picture picture, String string, DecimalFormatProperties<E> decimalFormatProperties) {
        SubPicture subPicture;
        boolean bl = d2 < 0.0 || this.isNegativeZero(d2);
        SubPicture subPicture2 = subPicture = picture.subPicture2 != null && bl ? picture.subPicture2 : picture.subPicture1;
        if (subPicture.percentPos != -1) {
            d2 *= 100.0;
        } else if (subPicture.perMillePos != -1) {
            d2 *= 1000.0;
        }
        if (Double.isInfinite(d2)) {
            this.infinity(stringBuilder, bl, subPicture, picture.subPicture1, string, decimalFormatProperties);
            return;
        }
        double d3 = Math.abs(d2);
        BigDecimal bigDecimal = new BigDecimal(String.valueOf(d3));
        BigDecimal bigDecimal2 = this.roundHalfToEven(bigDecimal, subPicture.maximumFractionalPartSize);
        String string2 = this.format(subPicture, bigDecimal2, decimalFormatProperties);
        this.prefix(subPicture, picture.subPicture1, stringBuilder, bl, string, decimalFormatProperties);
        stringBuilder.append(string2);
        this.suffix(subPicture, stringBuilder, string);
    }

    private String format(SubPicture subPicture, BigDecimal bigDecimal, DecimalFormatProperties<E> decimalFormatProperties) {
        int n2;
        char c2;
        char c3;
        String string = bigDecimal.abs().toString();
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        boolean bl = true;
        int n6 = -1;
        int n7 = 0;
        for (c3 = '\u0000'; c3 < string.length(); ++c3) {
            c2 = string.charAt(c3);
            if (c2 >= '0' && c2 <= '9') {
                if (bl && c2 == '0') continue;
                bl = false;
                n2 = this.getCorrespondingDecimalDigit(c2, decimalFormatProperties.getZeroDigit());
                stringBuilder.appendCodePoint(n2);
                if (c2 != '0') {
                    n6 = stringBuilder.length();
                }
            } else if (c2 == '.') {
                n5 = stringBuilder.length();
                stringBuilder.append(Character.toChars(decimalFormatProperties.getDecimalSeparator()));
                bl = false;
                n6 = stringBuilder.length();
                continue;
            }
            if (n5 == -1) {
                ++n3;
                continue;
            }
            if (c2 != '0') {
                n4 += 1 + n7;
                n7 = 0;
                continue;
            }
            ++n7;
        }
        if (n5 == -1) {
            stringBuilder.append(Character.toChars(decimalFormatProperties.getDecimalSeparator()));
            n5 = stringBuilder.length() - Character.charCount(decimalFormatProperties.getDecimalSeparator());
        } else if (n7 > 0 && n6 >= 0 && n6 < stringBuilder.length()) {
            stringBuilder.setLength(n6);
        }
        while (n3 < subPicture.minimumIntegerPartSize) {
            stringBuilder.insert(0, Character.toChars(decimalFormatProperties.getZeroDigit()));
            n5 += Character.charCount(decimalFormatProperties.getZeroDigit());
            ++n3;
        }
        while (n4 < subPicture.minimumFractionalPartSize) {
            stringBuilder.append(Character.toChars(decimalFormatProperties.getZeroDigit()));
            ++n4;
        }
        this.addGroupingSeparators(n5, stringBuilder, subPicture, decimalFormatProperties);
        if (subPicture.decimalSepPos == -1 || n4 == 0) {
            c3 = stringBuilder.charAt(stringBuilder.length() - 1);
            c2 = (char)(this.isSurrogate(c3) ? 1 : 0);
            n2 = stringBuilder.length() - (c2 != '\u0000' ? 2 : 1);
            stringBuilder.setLength(n2);
        }
        return stringBuilder.toString();
    }

    private void addGroupingSeparators(int n2, StringBuilder stringBuilder, SubPicture subPicture, DecimalFormatProperties<E> decimalFormatProperties) {
        int n3;
        int n4;
        if (n2 == -1) {
            return;
        }
        int n5 = 0;
        int n6 = this.previousIndex(n2, stringBuilder);
        int n7 = subPicture.integerPartGroupingPositions.size() - 1;
        int n8 = subPicture.regularGroupingMultiple;
        if (n6 != -1) {
            for (n3 = n6; n3 >= 0 && (n8 != -1 || n7 >= 0); n3 -= Character.charCount(n4)) {
                n4 = stringBuilder.codePointAt(n3);
                if (!this.isMemberOfDecimalDigitFamily(n4, decimalFormatProperties)) continue;
                ++n5;
                if (n8 != -1) {
                    if (n5 % n8 != 0 || n3 == 0) continue;
                    stringBuilder.insert(n3, Character.toChars(decimalFormatProperties.getGroupingSeparator()));
                    n2 += Character.charCount(decimalFormatProperties.getGroupingSeparator());
                    continue;
                }
                if (n7 < 0 || n5 != subPicture.integerPartGroupingPositions.get(n7)) continue;
                stringBuilder.insert(n3, Character.toChars(decimalFormatProperties.getGroupingSeparator()));
                n2 += Character.charCount(decimalFormatProperties.getGroupingSeparator());
                --n7;
            }
        }
        n5 = 0;
        n7 = 0;
        for (n3 = n2; n3 < stringBuilder.length() && n7 < subPicture.fractionalPartGroupingPositions.size(); n3 += Character.charCount(n4)) {
            n4 = stringBuilder.codePointAt(n3);
            if (!this.isMemberOfDecimalDigitFamily(n4, decimalFormatProperties) || ++n5 != subPicture.fractionalPartGroupingPositions.get(n7)) continue;
            stringBuilder.insert(this.nextIndex(n3, n4), Character.toChars(decimalFormatProperties.getGroupingSeparator()));
            ++n7;
        }
    }
}

