/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.common.regex.xerces;

final class CaseInsensitiveMap {
    private static int CHUNK_SHIFT = 10;
    private static int CHUNK_SIZE = 1 << CHUNK_SHIFT;
    private static int CHUNK_MASK = CHUNK_SIZE - 1;
    private static int INITIAL_CHUNK_COUNT = 64;
    private static int[][][] caseInsensitiveMap;
    private static int LOWER_CASE_MATCH;
    private static int UPPER_CASE_MATCH;

    CaseInsensitiveMap() {
    }

    public static int[] get(int n2) {
        return n2 < 65536 ? CaseInsensitiveMap.getMapping(n2) : null;
    }

    private static int[] getMapping(int n2) {
        int n3 = n2 >>> CHUNK_SHIFT;
        int n4 = n2 & CHUNK_MASK;
        return caseInsensitiveMap[n3][n4];
    }

    private static void buildCaseInsensitiveMap() {
        caseInsensitiveMap = new int[INITIAL_CHUNK_COUNT][CHUNK_SIZE][];
        for (int i2 = 0; i2 < 65536; ++i2) {
            int[] nArray;
            char c2;
            int n2 = Character.toLowerCase((char)i2);
            if (n2 == (c2 = Character.toUpperCase((char)i2)) && n2 == i2) continue;
            int[] nArray2 = new int[2];
            int n3 = 0;
            if (n2 != i2) {
                nArray2[n3++] = n2;
                nArray2[n3++] = LOWER_CASE_MATCH;
                nArray = CaseInsensitiveMap.getMapping(n2);
                if (nArray != null) {
                    nArray2 = CaseInsensitiveMap.updateMap(i2, nArray2, n2, nArray, LOWER_CASE_MATCH);
                }
            }
            if (c2 != i2) {
                if (n3 == nArray2.length) {
                    nArray2 = CaseInsensitiveMap.expandMap(nArray2, 2);
                }
                nArray2[n3++] = c2;
                nArray2[n3++] = UPPER_CASE_MATCH;
                nArray = CaseInsensitiveMap.getMapping(c2);
                if (nArray != null) {
                    nArray2 = CaseInsensitiveMap.updateMap(i2, nArray2, c2, nArray, UPPER_CASE_MATCH);
                }
            }
            CaseInsensitiveMap.set(i2, nArray2);
        }
    }

    private static int[] expandMap(int[] nArray, int n2) {
        int n3 = nArray.length;
        int[] nArray2 = new int[n3 + n2];
        System.arraycopy(nArray, 0, nArray2, 0, n3);
        return nArray2;
    }

    private static void set(int n2, int[] nArray) {
        int n3 = n2 >>> CHUNK_SHIFT;
        int n4 = n2 & CHUNK_MASK;
        CaseInsensitiveMap.caseInsensitiveMap[n3][n4] = nArray;
    }

    private static int[] updateMap(int n2, int[] nArray, int n3, int[] nArray2, int n4) {
        for (int i2 = 0; i2 < nArray2.length; i2 += 2) {
            int n5 = nArray2[i2];
            int[] nArray3 = CaseInsensitiveMap.getMapping(n5);
            if (nArray3 == null || !CaseInsensitiveMap.contains(nArray3, n3, n4)) continue;
            if (!CaseInsensitiveMap.contains(nArray3, n2)) {
                nArray3 = CaseInsensitiveMap.expandAndAdd(nArray3, n2, n4);
                CaseInsensitiveMap.set(n5, nArray3);
            }
            if (CaseInsensitiveMap.contains(nArray, n5)) continue;
            nArray = CaseInsensitiveMap.expandAndAdd(nArray, n5, n4);
        }
        if (!CaseInsensitiveMap.contains(nArray2, n2)) {
            nArray2 = CaseInsensitiveMap.expandAndAdd(nArray2, n2, n4);
            CaseInsensitiveMap.set(n3, nArray2);
        }
        return nArray;
    }

    private static boolean contains(int[] nArray, int n2) {
        for (int i2 = 0; i2 < nArray.length; i2 += 2) {
            if (nArray[i2] != n2) continue;
            return true;
        }
        return false;
    }

    private static boolean contains(int[] nArray, int n2, int n3) {
        for (int i2 = 0; i2 < nArray.length; i2 += 2) {
            if (nArray[i2] != n2 || nArray[i2 + 1] != n3) continue;
            return true;
        }
        return false;
    }

    private static int[] expandAndAdd(int[] nArray, int n2, int n3) {
        int n4 = nArray.length;
        int[] nArray2 = new int[n4 + 2];
        System.arraycopy(nArray, 0, nArray2, 0, n4);
        nArray2[n4] = n2;
        nArray2[n4 + 1] = n3;
        return nArray2;
    }

    static {
        LOWER_CASE_MATCH = 1;
        UPPER_CASE_MATCH = 2;
        CaseInsensitiveMap.buildCaseInsensitiveMap();
    }
}

