/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jdwp;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import oracle.xml.jdwp.XSLJDWPConstants;
import oracle.xml.jdwp.XSLJDWPError;
import oracle.xml.jdwp.XSLJDWPEventRequestManager;
import oracle.xml.jdwp.XSLJDWPException;
import oracle.xml.jdwp.XSLJDWPOutQueue;
import oracle.xml.jdwp.XSLJDWPPacket;
import oracle.xml.jdwp.XSLJDWPSockReader;
import oracle.xml.jdwp.XSLJDWPSockWriter;
import oracle.xml.jdwp.XSLJDWPSocketConn;
import oracle.xml.jdwp.XSLJDWPUtil;
import oracle.xml.xslt.XSLStylesheet;

public class XSLJDWPDebugger
implements XSLJDWPConstants {
    Thread srt;
    Thread swt;
    Thread xslt;
    int transportType;
    boolean server;
    String hostname;
    int port;
    boolean suspend;
    OutputStreamWriter errOut;
    protected XSLJDWPSocketConn sockconn;
    protected XSLJDWPOutQueue outq;
    Socket clientSock;
    ServerSocket serverSock;
    XSLJDWPSockReader sockReader;
    XSLJDWPSockWriter sockWriter;
    protected XSLStylesheet xsl;
    XSLJDWPEventRequestManager evtReqManager;
    boolean disconnect = false;
    XSLJDWPError jdwpErr;

    public XSLJDWPDebugger(XSLStylesheet xSLStylesheet) {
        this.xsl = xSLStylesheet;
        this.outq = new XSLJDWPOutQueue();
        this.evtReqManager = new XSLJDWPEventRequestManager();
        this.errOut = new OutputStreamWriter(System.err);
        this.jdwpErr = new XSLJDWPError();
    }

    public void setTransportType(int n2) {
        this.transportType = n2;
    }

    public void setServer(boolean bl) {
        this.server = bl;
    }

    public void setSuspend(boolean bl) {
        this.suspend = bl;
    }

    public void setHostName(String string) {
        this.hostname = string;
    }

    public void setPort(int n2) {
        this.port = n2;
    }

    public void setErrorStream(OutputStream outputStream) {
        if (outputStream != null) {
            this.errOut = new OutputStreamWriter(outputStream);
        }
    }

    public void run() {
        Thread.currentThread().setName("XSLDebugger");
        try {
            this.connect();
            this.handshake();
            this.xsl.fireVMSTART();
            this.debug();
        }
        catch (XSLJDWPException xSLJDWPException) {
            this.reportError(xSLJDWPException);
        }
    }

    void connect() throws XSLJDWPException {
        try {
            if (!this.server) {
                if (this.hostname == null || this.port <= 0) {
                    this.reportError(new XSLJDWPException(this.jdwpErr.getMessage(1201, 0)));
                }
                XSLJDWPUtil.printForTest(this.xsl.getXSLDebugProp(), "Connecting to server...");
                this.clientSock = new Socket(this.hostname, this.port);
            } else {
                Thread.sleep(1000L);
                this.serverSock = new ServerSocket(this.port);
                XSLJDWPUtil.printForTest(this.xsl.getXSLDebugProp(), "Waiting for connection...");
                this.clientSock = this.serverSock.accept();
            }
            this.clientSock.setSoTimeout(200);
            this.sockconn = new XSLJDWPSocketConn(this.clientSock);
        }
        catch (Exception exception) {
            throw new XSLJDWPException(this.jdwpErr.getMessage(1202, 0, exception));
        }
    }

    void handshake() throws XSLJDWPException {
        try {
            String string = this.sockconn.receiveHandshake();
            XSLJDWPUtil.printTrace(this.xsl.getXSLDebugProp(), "Handshake, from debugger: " + string);
            if (string.compareTo("JDWP-Handshake") == 0) {
                this.sockconn.sendHandshake();
            } else {
                this.closeConnection();
            }
        }
        catch (Exception exception) {
            throw new XSLJDWPException(this.jdwpErr.getMessage(1204, 0, exception));
        }
    }

    void closeConnection() throws XSLJDWPException {
        XSLJDWPUtil.printTrace(this.xsl.getXSLDebugProp(), "VM connection closing");
        try {
            this.sockconn.close();
            if (this.serverSock != null) {
                this.serverSock.close();
            }
        }
        catch (IOException iOException) {
            throw new XSLJDWPException(this.jdwpErr.getMessage(1203, 2, iOException));
        }
    }

    void debug() {
        this.xslt = Thread.currentThread();
        this.sockReader = new XSLJDWPSockReader(this);
        this.srt = new Thread(this.sockReader);
        this.srt.setName("JDWP-Socket-Reader");
        this.srt.start();
        this.sockWriter = new XSLJDWPSockWriter(this);
        this.swt = new Thread(this.sockWriter);
        this.swt.setName("JDWP-Socket-Writer");
        this.swt.start();
    }

    public XSLJDWPEventRequestManager getEventRequestManager() {
        return this.evtReqManager;
    }

    Thread getSocketReaderThread() {
        return this.srt;
    }

    Thread getSocketWriterThread() {
        return this.swt;
    }

    Thread getXSLThread() {
        return this.xslt;
    }

    public XSLJDWPOutQueue getOutQueue() {
        return this.outq;
    }

    void disconnectReader() {
        this.disconnect = true;
        this.sockReader.disconnect();
    }

    void disconnectWriter() {
        this.disconnect = true;
        this.sockWriter.disconnect();
    }

    void joinThread(Thread thread) throws InterruptedException {
        while (thread.isAlive()) {
            thread.join(10L);
        }
    }

    public boolean getDispose() {
        return this.disconnect;
    }

    void setDispose(boolean bl) {
        this.disconnect = bl;
    }

    void reportError(XSLJDWPException xSLJDWPException) {
        try {
            String string = xSLJDWPException.getMessage();
            this.errOut.write(string + "\n");
            this.errOut.flush();
            this.xsl.setJDWPErrorMesg(string);
            this.xsl.decrSuspendCount();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void dumpPacket(XSLJDWPPacket xSLJDWPPacket, boolean bl) {
        String string;
        String string2 = string = bl ? "Sending" : "Receiving";
        if (!bl) {
            XSLJDWPUtil.printTrace("Receiving: Command. id=" + xSLJDWPPacket.id + ", length=" + xSLJDWPPacket.data.length + ", commandSet=" + xSLJDWPPacket.cmdSet + ", command=" + xSLJDWPPacket.cmd + ", flags=" + xSLJDWPPacket.flags);
        } else if ((xSLJDWPPacket.flags & 0x80) != 0) {
            XSLJDWPUtil.printTrace("Sending Reply. id=" + xSLJDWPPacket.id + ", length=" + xSLJDWPPacket.data.length + ", errorCode=" + xSLJDWPPacket.errorCode + ", flags=" + xSLJDWPPacket.flags);
        } else {
            XSLJDWPUtil.printTrace("Sending: Event. id=" + xSLJDWPPacket.id + ", length=" + xSLJDWPPacket.data.length + ", commandSet=" + xSLJDWPPacket.cmdSet + ", command=" + xSLJDWPPacket.cmd + ", flags=" + xSLJDWPPacket.flags);
        }
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append("0000: ");
        for (int i2 = 0; i2 < xSLJDWPPacket.data.length; ++i2) {
            String string3;
            int n2;
            if (i2 > 0 && i2 % 16 == 0) {
                XSLJDWPUtil.printTrace(stringBuffer.toString());
                stringBuffer.setLength(0);
                stringBuffer.append(String.valueOf(i2));
                stringBuffer.append(": ");
                n2 = stringBuffer.length();
                for (int i3 = 0; i3 < 6 - n2; ++i3) {
                    stringBuffer.insert(0, '0');
                }
            }
            if ((string3 = Integer.toHexString(n2 = 0xFF & xSLJDWPPacket.data[i2])).length() == 1) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string3);
            stringBuffer.append(' ');
        }
        if (stringBuffer.length() > 6) {
            XSLJDWPUtil.printTrace(stringBuffer.toString());
        }
    }
}

