/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import oracle.xml.parser.v2.SAXAttrList;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.scalable.BinaryNav;
import oracle.xml.util.QxName;
import oracle.xml.xpath.BinaryNode;
import oracle.xml.xpath.StreamingSequence;
import oracle.xml.xpath.XPathPredicate;
import oracle.xml.xpath.XPathRuntimeContext;
import oracle.xml.xpath.XPathStep;
import oracle.xml.xslt.XSLException;

class BinarySequence
implements StreamingSequence {
    long curIdx = -2L;
    BinaryNav binNav;
    BinarySequence ctxSeq = null;
    int axistype = -1;
    XPathStep step = null;
    XPathRuntimeContext context;
    int[] posArray = null;
    boolean started = false;
    BinaryNode curNode = null;

    BinarySequence(XPathStep xPathStep, XPathRuntimeContext xPathRuntimeContext, BinarySequence object, long l2) {
        if (xPathStep != null) {
            Object object2;
            this.step = xPathStep;
            this.axistype = xPathStep.getAxisType();
            if (this.step.prevSeparator == 6) {
                if (this.axistype == 2) {
                    object2 = new BinarySequence(null, xPathRuntimeContext, (BinarySequence)object, -2L);
                    ((BinarySequence)object2).axistype = 5;
                    object = object2;
                } else {
                    this.axistype = this.axistype == 11 ? 5 : 4;
                }
            }
            if ((object2 = xPathStep.predicates) != null && ((XPathPredicate)object2).checkPosLastFN() > 0) {
                int n2 = ((XPathPredicate)object2).predicateSize;
                this.posArray = new int[n2];
            }
        }
        this.context = xPathRuntimeContext;
        this.ctxSeq = object;
        this.binNav = this.context.getBinaryNav();
        this.curIdx = l2;
    }

    @Override
    public boolean isDone() {
        return this.started && this.curIdx == -2L;
    }

    void resetPosArray() {
        for (int i2 = 0; i2 < this.posArray.length; ++i2) {
            this.posArray[i2] = 0;
        }
    }

    long getIndex() {
        return this.curIdx;
    }

    @Override
    public XMLNode getNode() {
        if (!this.isDone() && this.curNode == null) {
            this.curNode = new BinaryNode(this.curIdx, this.binNav);
        }
        return this.curNode;
    }

    @Override
    public boolean next() throws XSLException {
        long l2 = -2L;
        this.curNode = null;
        boolean bl = false;
        switch (this.axistype) {
            case 4: 
            case 5: {
                if (!this.started) {
                    this.started = true;
                    this.ctxSeq.next();
                }
                l2 = this.ctxSeq.getIndex();
                while (l2 > -2L) {
                    boolean bl2;
                    if (this.curIdx == -2L) {
                        this.curIdx = l2;
                        this.binNav.seekToIndex(this.curIdx);
                        if (this.posArray != null) {
                            this.resetPosArray();
                        }
                    } else {
                        this.binNav.seekToIndex(this.curIdx);
                    }
                    while (this.curIdx != -2L && ((bl2 = this.binNav.firstChild()) || this.curIdx != l2)) {
                        while (!bl2) {
                            bl2 = this.binNav.nextSibling();
                            if (!bl2) {
                                this.binNav.parent();
                                this.curIdx = this.binNav.getCurrentIndex();
                                if (this.curIdx != l2) continue;
                                break;
                            }
                            this.curIdx = this.binNav.getCurrentIndex();
                        }
                        this.curIdx = this.binNav.getCurrentIndex();
                        if (bl2) {
                            if (this.step == null) {
                                return true;
                            }
                            if (!this.step.anyNode && !this.checkQName() || this.step.predicates != null && !this.step.predicates.filterIndex(this.curIdx, this.posArray, this.context)) continue;
                            return true;
                        }
                        this.curIdx = -2L;
                    }
                    this.ctxSeq.next();
                    l2 = this.ctxSeq.getIndex();
                }
                this.curIdx = -2L;
                return false;
            }
            case 3: {
                if (!this.started) {
                    this.started = true;
                    this.ctxSeq.next();
                }
                l2 = this.ctxSeq.getIndex();
                while (l2 != -2L) {
                    boolean bl3 = false;
                    if (this.curIdx == -2L) {
                        if (this.posArray != null) {
                            this.resetPosArray();
                        }
                        this.binNav.seekToIndex(l2);
                        bl3 = this.binNav.firstChild();
                    } else {
                        this.binNav.seekToIndex(this.curIdx);
                        bl3 = this.binNav.nextSibling();
                    }
                    while (bl3) {
                        this.curIdx = this.binNav.getCurrentIndex();
                        if ((this.step.anyNode || this.checkQName()) && (this.step.predicates == null || this.step.predicates.filterIndex(this.curIdx, this.posArray, this.context))) {
                            return true;
                        }
                        bl3 = this.binNav.nextSibling();
                    }
                    this.curIdx = -2L;
                    if (this.ctxSeq.next()) {
                        l2 = this.ctxSeq.getIndex();
                        continue;
                    }
                    l2 = -2L;
                }
                this.curIdx = -2L;
                return false;
            }
            case 2: {
                this.curNode = null;
                this.curIdx = -2L;
                if (!this.started) {
                    this.started = true;
                }
                this.ctxSeq.next();
                l2 = this.ctxSeq.getIndex();
                this.binNav.seekToIndex(l2);
                if (l2 == -2L) {
                    return false;
                }
                SAXAttrList sAXAttrList = this.binNav.getAttributes();
                if (sAXAttrList == null) {
                    return false;
                }
                int n2 = sAXAttrList.getLength();
                for (int i2 = 0; i2 < n2; ++i2) {
                    String string = sAXAttrList.getName(i2);
                    String string2 = sAXAttrList.getNamespace(i2);
                    if (string2 != "" && !string2.equals(this.step.nameSpace) || !string.equals(this.step.name)) continue;
                    QxName qxName = new QxName(string2, string, sAXAttrList.getPrefix(i2), sAXAttrList.getQualifiedName(i2));
                    this.curNode = new BinaryNode(qxName, 2, sAXAttrList.getValue(i2));
                    return true;
                }
                return false;
            }
            case -1: {
                if (this.started) {
                    this.curIdx = -2L;
                    return false;
                }
                this.started = true;
                return true;
            }
        }
        return false;
    }

    private boolean checkQName() {
        QxName qxName = (QxName)this.binNav.getQName();
        String string = this.step.name;
        String string2 = this.step.nameSpace;
        return !(string != null && string != qxName.getLocalPart() || string2 != null && string2 != qxName.getNamespaceURI());
    }
}

