/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import java.util.ArrayList;
import oracle.xml.util.FastVector;
import oracle.xml.util.NSNameImpl;
import oracle.xml.xpath.ExprSingle;
import oracle.xml.xpath.XPathCompileEvents;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathRuntimeContext;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xpath.XSLParseString;
import oracle.xml.xqxp.XQException;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLFunction;
import oracle.xml.xslt.XSLTContext;

class XPathXSLFunction
extends XSLExprBase {
    XSLFunction xslfunc;
    String ns;
    String funcname;
    FastVector exprVector;

    XPathXSLFunction() {
    }

    static XSLExprBase parse(XSLParseString xSLParseString) throws XSLException, XQException {
        int n2 = xSLParseString.peekToken();
        if (n2 != 113 || xSLParseString.getFunctionType() != 602) {
            return null;
        }
        XPathCompileEvents xPathCompileEvents = xSLParseString.getXPathCompileEvents();
        XPathXSLFunction xPathXSLFunction = new XPathXSLFunction();
        n2 = xSLParseString.nextToken();
        xPathXSLFunction.setExprType(0x2200000);
        xPathXSLFunction.ns = xSLParseString.getNamespace();
        xPathXSLFunction.funcname = xSLParseString.getLocalName();
        if (xPathCompileEvents != null) {
            xPathCompileEvents.reportEventsWithStringParam(302, 0, xPathXSLFunction.ns, xPathXSLFunction.funcname, null);
        }
        NSNameImpl nSNameImpl = new NSNameImpl("", xPathXSLFunction.funcname, xPathXSLFunction.ns);
        xPathXSLFunction.exprVector = new FastVector();
        int n3 = 0;
        if (xSLParseString.peekToken() != 26) {
            XSLExprBase xSLExprBase = ExprSingle.parse(xSLParseString);
            if (xSLParseString.isCachingExpr() && xSLExprBase.canCacheExpr()) {
                xSLExprBase = xSLExprBase.createCachedExpr();
            }
            xPathXSLFunction.exprVector.addElement(xSLExprBase);
            ++n3;
            while (xSLParseString.peekToken() != 26) {
                if (xSLParseString.nextToken() != 1) {
                    throw new XPathException(1020);
                }
                xSLExprBase = ExprSingle.parse(xSLParseString);
                if (xSLParseString.isCachingExpr() && xSLExprBase.canCacheExpr()) {
                    xSLExprBase = xSLExprBase.createCachedExpr();
                }
                xPathXSLFunction.exprVector.addElement(xSLExprBase);
                ++n3;
            }
        }
        xPathXSLFunction.xslfunc = xSLParseString.xss.getUserDefinedFunctionFromPool(nSNameImpl, n3);
        if (xPathXSLFunction.xslfunc == null) {
            throw new XPathException(1054, xPathXSLFunction.ns, xPathXSLFunction.funcname);
        }
        xSLParseString.nextToken();
        if (xPathCompileEvents != null) {
            xPathCompileEvents.reportEventsNoParam(302, 1);
            ArrayList arrayList = xPathCompileEvents.makeXSLExprBaseList(xPathXSLFunction.exprVector);
            xPathCompileEvents.reportEventsWithStringList(401, 2, xPathXSLFunction.ns, xPathXSLFunction.funcname, null, arrayList);
        }
        return xPathXSLFunction;
    }

    @Override
    void cacheSubExpr() {
    }

    @Override
    boolean canCacheExpr() {
        return false;
    }

    @Override
    public String getNormalizedExpr() throws XQException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.ns != null && this.ns.length() > 0) {
            stringBuffer.append("{");
            stringBuffer.append(this.ns);
            stringBuffer.append("}");
        }
        stringBuffer.append(this.funcname);
        for (int i2 = 0; i2 < this.exprVector.size(); ++i2) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.exprVector.elementAt(i2);
            stringBuffer.append(xSLExprBase.getNormalizedExpr());
        }
        return stringBuffer.toString();
    }

    @Override
    int checkPosLastFN() {
        for (int i2 = 0; i2 < this.exprVector.size(); ++i2) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.exprVector.elementAt(i2);
            this.flag |= xSLExprBase.checkPosLastFN();
        }
        return this.flag;
    }

    @Override
    public void evaluate(XPathRuntimeContext xPathRuntimeContext) throws XSLException, XQException {
        int n2 = this.exprVector.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.exprVector.elementAt(i2);
            xSLExprBase.evaluate(xPathRuntimeContext);
        }
        this.xslfunc.processAction((XSLTContext)xPathRuntimeContext);
    }
}

