/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import oracle.xml.util.FastVector;
import oracle.xml.util.XMLException;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XSLExprConstants;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequence;

class XSLExtFunctions
implements XSLExprConstants {
    XSLExtFunctions() {
    }

    static void callMethod(Method method, FastVector fastVector, OXMLSequence oXMLSequence) throws XPathException, XQException {
        Object object;
        Class<?> clazz = method.getDeclaringClass();
        Class<?>[] classArray = method.getParameterTypes();
        Object[] objectArray = new Object[classArray.length];
        Object object2 = null;
        Object object3 = XPathSequence.convertType((OXMLSequence)fastVector.elementAt(0), clazz);
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            object = (OXMLSequence)fastVector.elementAt(i2 + 1);
            objectArray[i2] = XPathSequence.convertType((OXMLSequence)object, classArray[i2]);
        }
        try {
            object2 = method.invoke(object3, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new XPathException(1044, method.getName(), invocationTargetException.getTargetException().toString());
        }
        catch (Exception exception) {
            object = new XPathException(1900, exception.getMessage());
            ((XMLException)object).setException(exception);
            throw object;
        }
        if (object2 != null) {
            XPathSequence.setExtensionValue(oXMLSequence, object2);
        } else {
            XPathSequence.setStringValue(oXMLSequence, "");
        }
    }

    static void callStaticMethod(Method method, FastVector fastVector, OXMLSequence oXMLSequence) throws XPathException, XQException {
        Class<?>[] classArray = method.getParameterTypes();
        Object[] objectArray = new Object[classArray.length];
        Object object = null;
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            objectArray[i2] = XPathSequence.convertType((OXMLSequence)fastVector.elementAt(i2), classArray[i2]);
        }
        try {
            object = method.invoke(null, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new XPathException(1044, method.getName(), invocationTargetException.getTargetException().toString());
        }
        catch (Exception exception) {
            XPathException xPathException = new XPathException(1900, exception.getMessage());
            xPathException.setException(exception);
            throw xPathException;
        }
        if (object != null) {
            XPathSequence.setExtensionValue(oXMLSequence, object);
        }
    }

    static void callConstructor(Constructor constructor, FastVector fastVector, OXMLSequence oXMLSequence) throws XPathException, XQException {
        Class<?>[] classArray = constructor.getParameterTypes();
        Object[] objectArray = new Object[classArray.length];
        Object var5_5 = null;
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            objectArray[i2] = XPathSequence.convertType((OXMLSequence)fastVector.elementAt(i2), classArray[i2]);
        }
        try {
            var5_5 = constructor.newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new XPathException(1039, constructor.getName());
        }
        catch (Exception exception) {
            XPathException xPathException = new XPathException(1900, exception.getMessage());
            xPathException.setException(exception);
            throw xPathException;
        }
        XPathSequence.setExtensionValue(oXMLSequence, var5_5);
    }

    static Constructor getConstructor(String string, FastVector fastVector) throws XPathException {
        Class clazz = null;
        try {
            clazz = XSLExtFunctions.getClass(string);
            if (!Modifier.isPublic(clazz.getModifiers())) {
                throw new XPathException(1045, string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new XPathException(1045, classNotFoundException.getMessage());
        }
        try {
            Constructor<?>[] constructorArray = clazz.getConstructors();
            Constructor[] constructorArray2 = new Constructor[constructorArray.length];
            int n2 = 0;
            for (int i2 = 0; i2 < constructorArray.length; ++i2) {
                Class<?>[] classArray = constructorArray[i2].getParameterTypes();
                int n3 = constructorArray[i2].getModifiers();
                if (!Modifier.isPublic(n3) || fastVector.size() != classArray.length) continue;
                boolean bl = true;
                for (int i3 = 0; i3 < classArray.length; ++i3) {
                    if (XPathSequence.checkType((OXMLSequence)fastVector.elementAt(i3), classArray[i3])) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                if (n2 == 0) {
                    constructorArray2[n2++] = constructorArray[i2];
                    continue;
                }
                throw new XPathException(1040, constructorArray[i2].getName());
            }
            if (n2 == 0) {
                throw new XPathException(1041, string);
            }
            return constructorArray2[0];
        }
        catch (XPathException xPathException) {
            throw xPathException;
        }
        catch (Exception exception) {
            XPathException xPathException = new XPathException(1900, exception.getMessage());
            xPathException.setException(exception);
            throw xPathException;
        }
    }

    static Method getMethod(String string, String string2, FastVector fastVector) throws XPathException {
        Class clazz = null;
        try {
            clazz = XSLExtFunctions.getClass(string);
            if (!Modifier.isPublic(clazz.getModifiers())) {
                throw new XPathException(1045, string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new XPathException(1045, classNotFoundException.getMessage());
        }
        try {
            Method[] methodArray = clazz.getMethods();
            Method[] methodArray2 = new Method[methodArray.length];
            int n2 = 0;
            String string3 = XSLExtFunctions.getJavaMethodName(string2);
            for (int i2 = 0; i2 < methodArray.length; ++i2) {
                int n3 = methodArray[i2].getModifiers();
                if (!Modifier.isPublic(n3) || !methodArray[i2].getName().equals(string3)) continue;
                boolean bl = Modifier.isStatic(n3);
                Class<?>[] classArray = methodArray[i2].getParameterTypes();
                int n4 = classArray.length;
                if ((!bl || fastVector.size() != n4) && (bl || fastVector.size() != n4 + 1)) continue;
                int n5 = bl ? 0 : 1;
                boolean bl2 = true;
                for (int i3 = 0; i3 < classArray.length; ++i3) {
                    if (XPathSequence.checkType((OXMLSequence)fastVector.elementAt(i3 + n5), classArray[i3])) continue;
                    bl2 = false;
                    break;
                }
                if (!bl2) continue;
                if (n2 == 0) {
                    methodArray2[n2++] = methodArray[i2];
                    continue;
                }
                throw new XPathException(1042, methodArray[i2].getName());
            }
            if (n2 == 0) {
                throw new XPathException(1043, string2);
            }
            return methodArray2[0];
        }
        catch (XPathException xPathException) {
            throw xPathException;
        }
        catch (Exception exception) {
            XPathException xPathException = new XPathException(1900, exception.getMessage());
            xPathException.setException(exception);
            throw xPathException;
        }
    }

    static boolean checkMethod(String string, String string2) throws XPathException {
        if (string2.equals("new")) {
            return true;
        }
        Class clazz = null;
        try {
            clazz = XSLExtFunctions.getClass(string);
            if (!Modifier.isPublic(clazz.getModifiers())) {
                throw new XPathException(1045, string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new XPathException(1045, classNotFoundException.getMessage());
        }
        try {
            Method[] methodArray = clazz.getMethods();
            String string3 = XSLExtFunctions.getJavaMethodName(string2);
            for (int i2 = 0; i2 < methodArray.length; ++i2) {
                if (!Modifier.isPublic(methodArray[i2].getModifiers()) || !methodArray[i2].getName().equals(string3)) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            XPathException xPathException = new XPathException(1900, exception.getMessage());
            xPathException.setException(exception);
            throw xPathException;
        }
    }

    static String getJavaMethodName(String string) {
        if (string.indexOf(45) == -1) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (cArray[i2] == '-' && i2 < n2 - 1) {
                if (cArray[++i2] >= 'a' && cArray[i2] <= 'z') {
                    cArray[n3++] = (char)(cArray[i2] - 97 + 65);
                    continue;
                }
                cArray[n3++] = cArray[i2];
                continue;
            }
            cArray[n3++] = cArray[i2];
        }
        return new String(cArray, 0, n3);
    }

    static Class getClass(String string) throws ClassNotFoundException {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            return classLoader.loadClass(string);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return Class.forName(string);
        }
        catch (NullPointerException nullPointerException) {
            return Class.forName(string);
        }
    }
}

