/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.datamodel;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import oracle.i18n.text.OraCollator;
import oracle.xml.parser.schema.XSDDataValue;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLParser;
import oracle.xml.util.OraURI;
import oracle.xml.util.OraURIException;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLConstants;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.datamodel.XMLItem;
import oracle.xml.xqxp.functions.OXMLCollator;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNUtil;

public abstract class OXMLItem
extends XSDDataValue
implements XMLItem,
OXMLConstants {
    protected XMLNode nodeValue;
    protected OXMLSequenceType stype;
    static final int MAX_OP = 6;
    static final int NUM_PRIMITIVE_TYPES = 22;
    static boolean[][] castTable;
    private static final int[][] opComb;
    private static final int[][] opTable;
    private static final boolean[][] compTable;
    public static final DecimalFormat numberFormat;
    public static final ThreadLocal<DecimalFormat> dfUS;

    @Override
    protected void reset() {
        super.reset();
        this.stype = OXMLSequenceType.TUNTYPED;
        this.nodeValue = null;
    }

    @Override
    public void setValue(int n2, String string) throws XQException {
        try {
            super.setValue(n2, string);
            this.stype = OXMLSequenceType.constantTypes[0][n2];
        }
        catch (Exception exception) {
            throw new XQException("FORG0001");
        }
    }

    public int getPrimitiveType() {
        if (this.isNode()) {
            return 90;
        }
        return this.stype.getPrimitiveId();
    }

    public OXMLSequenceType getItemType() {
        if (this.stype == null && this.nodeValue != null) {
            this.stype = OXMLSequenceType.createNodeType(this.nodeValue);
        }
        return this.stype;
    }

    public boolean isNode() {
        return this.nodeValue != null;
    }

    public abstract void atomize(OXMLSequence var1) throws XQException;

    public abstract OXMLSequence atomize() throws XQException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void convert(OXMLSequenceType oXMLSequenceType) throws XQException {
        if (this.stype == oXMLSequenceType) {
            return;
        }
        if (this.stype.isOfType(oXMLSequenceType)) {
            this.setType(oXMLSequenceType);
            return;
        }
        int n2 = oXMLSequenceType.getPrimitiveId();
        OXMLSequenceType oXMLSequenceType2 = OXMLSequenceType.getConstantType(1, n2);
        int n3 = this.stype.getPrimitiveId();
        int n4 = n3 = n3 == 22 ? 5 : n3;
        if (n2 == 22) {
            if (!castTable[n3][5]) throw new XQException("XPTY0004");
            this.convert2Integer();
        } else {
            if (!castTable[n3][n2]) throw new XQException("XPTY0004");
            switch (n2) {
                case 3: {
                    this.convert2Float();
                    break;
                }
                case 4: {
                    this.convert2Double();
                    break;
                }
                case 5: {
                    this.convert2Decimal();
                    break;
                }
                case 2: {
                    this.convert2Boolean();
                    break;
                }
                case 16: {
                    this.convert2Base64Binary();
                    break;
                }
                case 15: {
                    this.convert2HexBinary();
                    break;
                }
                case 17: {
                    this.convert2URI();
                    break;
                }
                case 18: {
                    this.convert2QName();
                    break;
                }
                case 1: {
                    this.setString(OXMLSequenceType.TSTRING, this.getLexicalValue());
                    break;
                }
                case 0: {
                    this.setUntypedLexical(this.getLexicalValue());
                    break;
                }
                case 19: {
                    this.setString(OXMLSequenceType.TNOTATION, this.getLexicalValue());
                    break;
                }
                case 20: 
                case 21: {
                    if (n3 == 6) {
                        if (n2 == 21) {
                            this.intValue = 0;
                        } else {
                            this.doubleValue = 0.0;
                        }
                    } else if (n3 == 20 && n2 == 21 || n3 == 21 && n2 == 20) {
                        this.intValue = 0;
                        this.doubleValue = 0.0;
                    } else {
                        String string = this.getLexicalValue();
                        this.parseLexical(6);
                        this.objValue = null;
                        this.setType(oXMLSequenceType2);
                        try {
                            oXMLSequenceType2.getDataType().validateValue(string);
                        }
                        catch (Exception exception) {
                            throw new XQException("FORG0001");
                        }
                    }
                    this.lexicalValue = null;
                    this.nodeValue = null;
                    this.objValue = null;
                    this.setType(oXMLSequenceType2);
                    break;
                }
                case 6: {
                    if (n3 == 1 || n3 == 0) {
                        this.parseLexical(6);
                    }
                    this.setType(oXMLSequenceType2);
                    break;
                }
                case 7: {
                    if (n3 == 9) {
                        GregorianCalendar gregorianCalendar = (GregorianCalendar)this.objValue;
                        this.lexicalValue = null;
                        this.nodeValue = null;
                    } else {
                        this.parseLexical(n2);
                    }
                    this.setType(oXMLSequenceType2);
                    break;
                }
                case 9: {
                    if (n3 == 7) {
                        GregorianCalendar gregorianCalendar = (GregorianCalendar)this.objValue;
                        gregorianCalendar.set(11, 0);
                        gregorianCalendar.set(9, 0);
                        gregorianCalendar.set(10, 0);
                        gregorianCalendar.set(12, 0);
                        gregorianCalendar.set(13, 0);
                        gregorianCalendar.set(14, 0);
                        this.lexicalValue = null;
                        this.nodeValue = null;
                    } else {
                        this.parseLexical(n2);
                    }
                    this.setType(oXMLSequenceType2);
                    break;
                }
                case 8: {
                    if (n3 == 7) {
                        GregorianCalendar gregorianCalendar = (GregorianCalendar)this.objValue;
                        gregorianCalendar.set(1, 2000);
                        gregorianCalendar.set(2, 0);
                        gregorianCalendar.set(5, 1);
                        this.lexicalValue = null;
                        this.nodeValue = null;
                    } else {
                        this.parseLexical(n2);
                    }
                    this.setType(oXMLSequenceType2);
                    break;
                }
                case 10: {
                    if (n3 == 7 || n3 == 9) {
                        GregorianCalendar gregorianCalendar = (GregorianCalendar)this.objValue;
                        gregorianCalendar.set(5, 1);
                        gregorianCalendar.set(11, 0);
                        gregorianCalendar.set(9, 0);
                        gregorianCalendar.set(10, 0);
                        gregorianCalendar.set(12, 0);
                        gregorianCalendar.set(13, 0);
                        gregorianCalendar.set(14, 0);
                        this.lexicalValue = null;
                        this.nodeValue = null;
                    } else {
                        this.parseLexical(n2);
                    }
                    this.setType(oXMLSequenceType2);
                    break;
                }
                case 11: {
                    if (n3 == 7 || n3 == 9) {
                        GregorianCalendar gregorianCalendar = (GregorianCalendar)this.objValue;
                        gregorianCalendar.set(2, 0);
                        gregorianCalendar.set(5, 1);
                        gregorianCalendar.set(11, 0);
                        gregorianCalendar.set(9, 0);
                        gregorianCalendar.set(10, 0);
                        gregorianCalendar.set(12, 0);
                        gregorianCalendar.set(13, 0);
                        gregorianCalendar.set(14, 0);
                        this.lexicalValue = null;
                        this.nodeValue = null;
                    } else {
                        this.parseLexical(n2);
                    }
                    this.setType(oXMLSequenceType2);
                    break;
                }
                case 12: {
                    if (n3 == 7 || n3 == 9) {
                        GregorianCalendar gregorianCalendar = (GregorianCalendar)this.objValue;
                        gregorianCalendar.set(1, 2000);
                        gregorianCalendar.set(5, 1);
                        gregorianCalendar.set(11, 0);
                        gregorianCalendar.set(9, 0);
                        gregorianCalendar.set(10, 0);
                        gregorianCalendar.set(12, 0);
                        gregorianCalendar.set(13, 0);
                        gregorianCalendar.set(14, 0);
                        this.lexicalValue = null;
                        this.nodeValue = null;
                    } else {
                        this.parseLexical(n2);
                    }
                    this.setType(oXMLSequenceType2);
                    break;
                }
                case 13: {
                    if (n3 == 7 || n3 == 9) {
                        GregorianCalendar gregorianCalendar = (GregorianCalendar)this.objValue;
                        gregorianCalendar.set(1, 2000);
                        gregorianCalendar.set(11, 0);
                        gregorianCalendar.set(9, 0);
                        gregorianCalendar.set(10, 0);
                        gregorianCalendar.set(12, 0);
                        gregorianCalendar.set(13, 0);
                        gregorianCalendar.set(14, 0);
                        this.lexicalValue = null;
                        this.nodeValue = null;
                    } else {
                        this.parseLexical(n2);
                    }
                    this.setType(oXMLSequenceType2);
                    break;
                }
                case 14: {
                    if (n3 == 7 || n3 == 9) {
                        GregorianCalendar gregorianCalendar = (GregorianCalendar)this.objValue;
                        gregorianCalendar.set(1, 2000);
                        gregorianCalendar.set(2, 0);
                        gregorianCalendar.set(11, 0);
                        gregorianCalendar.set(9, 0);
                        gregorianCalendar.set(10, 0);
                        gregorianCalendar.set(12, 0);
                        gregorianCalendar.set(13, 0);
                        gregorianCalendar.set(14, 0);
                        this.lexicalValue = null;
                        this.nodeValue = null;
                    } else {
                        this.parseLexical(n2);
                    }
                    this.setType(oXMLSequenceType2);
                    break;
                }
            }
        }
        if (oXMLSequenceType.exactlyMatches(oXMLSequenceType2)) return;
        try {
            oXMLSequenceType.getDataType().validateValue(this.getLexicalValue());
            this.setType(oXMLSequenceType);
            return;
        }
        catch (Exception exception) {
            throw new XQException("FORG0001");
        }
    }

    protected OXMLFunctionContext getContext() throws XQException {
        throw new XQException("FONC0001");
    }

    private void parseLexical(int n2) {
        try {
            this.getLexicalValue();
            this.setValue(n2, this.lexicalValue.trim());
        }
        catch (Exception exception) {
            throw new XQException("FORG0001");
        }
        this.nodeValue = null;
        this.lexicalValue = null;
    }

    private void convert2Float() throws XQException {
        int n2 = this.stype.getPrimitiveId();
        double d2 = -1.0;
        switch (n2) {
            case 3: {
                return;
            }
            case 5: 
            case 22: {
                d2 = this.booleanValue ? (double)((BigDecimal)this.objValue).floatValue() : (double)this.intValue;
                break;
            }
            case 4: {
                if (this.doubleValue > 3.4028234663852886E38) {
                    d2 = Double.POSITIVE_INFINITY;
                    break;
                }
                if (this.doubleValue < -3.4028234663852886E38) {
                    d2 = Double.NEGATIVE_INFINITY;
                    break;
                }
                if (Math.abs(this.doubleValue) < (double)1.4E-45f) {
                    d2 = 0.0;
                    break;
                }
                d2 = this.doubleValue;
                break;
            }
            case 2: {
                d2 = this.booleanValue ? 1.0 : 0.0;
                break;
            }
            case 0: 
            case 1: {
                String string = this.getLexicalValue().trim();
                if (string.equals("INF")) {
                    d2 = Double.POSITIVE_INFINITY;
                    break;
                }
                if (string.equals("-INF")) {
                    d2 = Double.NEGATIVE_INFINITY;
                    break;
                }
                if (string.equals("Infinity") || string.equals("-Infinity")) {
                    throw new XQException("FORG0001");
                }
                try {
                    d2 = Float.parseFloat(this.getLexicalValue().trim());
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new XQException("FORG0001");
                }
            }
        }
        this.setDouble(OXMLSequenceType.TFLOAT, d2);
    }

    protected void convert2Double() throws XQException {
        int n2 = this.stype.getPrimitiveId();
        double d2 = -1.0;
        switch (n2) {
            case 4: {
                return;
            }
            case 5: 
            case 22: {
                d2 = this.booleanValue ? ((BigDecimal)this.objValue).doubleValue() : (double)this.intValue;
                break;
            }
            case 3: {
                d2 = (float)this.doubleValue;
                break;
            }
            case 2: {
                d2 = this.booleanValue ? 1.0 : 0.0;
                break;
            }
            case 0: 
            case 1: {
                String string = this.getLexicalValue().trim();
                if (string.equals("INF")) {
                    d2 = Double.POSITIVE_INFINITY;
                    break;
                }
                if (string.equals("-INF")) {
                    d2 = Double.NEGATIVE_INFINITY;
                    break;
                }
                if (string.equals("Infinity") || string.equals("-Infinity")) {
                    throw new XQException("FORG0001");
                }
                try {
                    d2 = Double.parseDouble(string);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new XQException("FORG0001");
                }
            }
        }
        this.setDouble(OXMLSequenceType.TDOUBLE, d2);
    }

    private void convert2Decimal() throws XQException {
        int n2 = this.stype.getPrimitiveId();
        switch (n2) {
            case 5: {
                return;
            }
            case 3: 
            case 4: {
                if (Double.isInfinite(this.doubleValue) || Double.isNaN(this.doubleValue)) {
                    throw new XQException("FOCA0002");
                }
                this.setDecimal(OXMLSequenceType.TDECIMAL, new BigDecimal(this.doubleValue));
                break;
            }
            case 2: {
                int n3 = this.booleanValue ? 1 : 0;
                this.setInt(OXMLSequenceType.TDECIMAL, n3);
                break;
            }
            case 0: 
            case 1: {
                String string = this.getLexicalValue().trim();
                if (string.length() == 0) {
                    throw new XQException("FORG0001");
                }
                if (string.indexOf(101) >= 0 || string.indexOf(69) >= 0) {
                    throw new XQException("FORG0001");
                }
                if (string.charAt(0) == '+') {
                    string = string.substring(1);
                }
                int n4 = string.length() - 1;
                try {
                    int n5 = Integer.parseInt(this.lexicalValue);
                    this.setInt(OXMLSequenceType.TDECIMAL, n5);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    if (string.charAt(n4) == '.') {
                        string = string.substring(0, n4);
                    }
                    try {
                        BigDecimal bigDecimal = new BigDecimal(string);
                        this.setDecimal(OXMLSequenceType.TDECIMAL, bigDecimal);
                        break;
                    }
                    catch (NumberFormatException numberFormatException2) {
                        throw new XQException("FORG0001");
                    }
                }
            }
        }
    }

    private void convert2Integer() throws XQException {
        int n2 = this.stype.getPrimitiveId();
        switch (n2) {
            case 22: {
                return;
            }
            case 5: {
                if (this.booleanValue) {
                    BigDecimal bigDecimal = ((BigDecimal)this.objValue).setScale(0, 1);
                    BigDecimal bigDecimal2 = new BigDecimal(Integer.toString(Integer.MIN_VALUE));
                    BigDecimal bigDecimal3 = new BigDecimal(Integer.toString(Integer.MAX_VALUE));
                    if (bigDecimal.compareTo(bigDecimal3) <= 0 && bigDecimal.compareTo(bigDecimal2) >= 0) {
                        int n3 = bigDecimal.intValue();
                        this.setInt(OXMLSequenceType.TINTEGER, n3);
                        break;
                    }
                    this.setDecimal(OXMLSequenceType.TINTEGER, bigDecimal);
                    break;
                }
                this.setInt(OXMLSequenceType.TINTEGER, this.intValue);
                break;
            }
            case 3: 
            case 4: {
                this.convertFloatDouble2Integer();
                break;
            }
            case 2: {
                int n4 = this.booleanValue ? 1 : 0;
                this.setInt(OXMLSequenceType.TINTEGER, n4);
                break;
            }
            case 0: 
            case 1: {
                String string = this.getLexicalValue().trim();
                if (string.length() == 0) {
                    throw new XQException("FORG0001");
                }
                if (string.indexOf(101) >= 0 || string.indexOf(69) >= 0 || string.indexOf(46) >= 0) {
                    throw new XQException("FORG0001");
                }
                int n5 = string.length() - 1;
                if (n5 >= 0 && string.charAt(0) == '+') {
                    string = string.substring(1);
                }
                try {
                    int n6 = Integer.parseInt(this.lexicalValue);
                    this.setInt(OXMLSequenceType.TINTEGER, n6);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        BigDecimal bigDecimal = new BigDecimal(string);
                        this.setDecimal(OXMLSequenceType.TINTEGER, bigDecimal);
                        break;
                    }
                    catch (NumberFormatException numberFormatException2) {
                        throw new XQException("FORG0001");
                    }
                }
            }
        }
    }

    private void convertFloatDouble2Integer() throws XQException {
        if (Double.isNaN(this.doubleValue) || Double.isInfinite(this.doubleValue)) {
            throw new XQException("FOCA0002");
        }
        double d2 = Math.floor(this.doubleValue);
        double d3 = d2 = d2 < 0.0 ? d2 + 1.0 : d2;
        if (d2 > 2.147483647E9 || d2 < -2.147483648E9) {
            this.setDecimal(OXMLSequenceType.TINTEGER, new BigDecimal(d2));
        } else {
            this.setInt(OXMLSequenceType.TINTEGER, (int)d2);
        }
    }

    protected void convert2Boolean() throws XQException {
        int n2 = this.stype.getPrimitiveId();
        boolean bl = false;
        switch (n2) {
            case 2: {
                return;
            }
            case 3: 
            case 4: {
                if (Double.isNaN(this.doubleValue) || this.doubleValue == 0.0) {
                    bl = false;
                    break;
                }
                bl = true;
                break;
            }
            case 5: 
            case 22: {
                if (this.booleanValue) {
                    bl = ((BigDecimal)this.objValue).intValue() != 0;
                    break;
                }
                bl = this.intValue != 0;
                break;
            }
            case 0: 
            case 1: {
                String string = this.getLexicalValue().trim();
                if (string.equals("true") || string.equals("1")) {
                    bl = true;
                    break;
                }
                if (string.equals("false") || string.equals("0")) {
                    bl = false;
                    break;
                }
                throw new XQException("FORG0001");
            }
        }
        this.setBoolean(OXMLSequenceType.TBOOLEAN, bl);
    }

    private void convert2URI() throws XQException {
        int n2 = this.stype.getPrimitiveId();
        switch (n2) {
            case 17: {
                return;
            }
            case 0: 
            case 1: {
                try {
                    new OraURI(this.getLexicalValue().trim());
                    break;
                }
                catch (OraURIException oraURIException) {
                    throw new XQException("FORG0001");
                }
            }
        }
        this.setString(OXMLSequenceType.TANYURI, this.lexicalValue);
    }

    private void convert2HexBinary() {
        int n2 = this.stype.getPrimitiveId();
        switch (n2) {
            case 15: {
                return;
            }
            case 16: {
                this.lexicalValue = FNUtil.encodeHex(FNUtil.decodeBase64(this.getLexicalValue()));
                break;
            }
            case 0: 
            case 1: {
                try {
                    this.setValue(15, this.getLexicalValue());
                    break;
                }
                catch (Exception exception) {
                    throw new XQException("FORG0001");
                }
            }
        }
        this.setString(OXMLSequenceType.THEXBINARY, this.lexicalValue);
    }

    private void convert2Base64Binary() {
        int n2 = this.stype.getPrimitiveId();
        switch (n2) {
            case 16: {
                return;
            }
            case 15: {
                this.lexicalValue = FNUtil.encodeBase64(FNUtil.decodeHex(this.getLexicalValue()));
                break;
            }
            case 0: 
            case 1: {
                try {
                    this.setValue(16, this.getLexicalValue());
                    break;
                }
                catch (Exception exception) {
                    throw new XQException("FORG0001");
                }
            }
        }
        this.setString(OXMLSequenceType.TBASE64BINARY, this.lexicalValue);
    }

    protected abstract void convert2QName() throws XQException;

    public boolean matchesType(OXMLSequenceType oXMLSequenceType) throws XQException {
        if (this.stype == null && this.nodeValue != null) {
            this.stype = OXMLSequenceType.createNodeType(this.nodeValue);
        }
        if (this.stype != null) {
            return this.stype.isOfTypeIgnoreOccurence(oXMLSequenceType);
        }
        throw new XQException("XPTY0004");
    }

    @Override
    public boolean instanceOfType(int n2) {
        boolean bl = false;
        switch (n2) {
            case 99: {
                bl = this.isNode();
                break;
            }
            case 7: {
                bl = this.matchesType(OXMLSequenceType.TDTDURATION);
                break;
            }
            case 8: {
                bl = this.matchesType(OXMLSequenceType.TYMDURATION);
                break;
            }
            case 20: {
                bl = this.matchesType(OXMLSequenceType.TDURATION);
                break;
            }
            case 9: {
                bl = this.matchesType(OXMLSequenceType.TANYURI);
                break;
            }
            case 10: {
                bl = this.matchesType(OXMLSequenceType.TBASE64BINARY);
                break;
            }
            case 11: {
                bl = this.matchesType(OXMLSequenceType.TBOOLEAN);
                break;
            }
            case 13: {
                bl = this.matchesType(FNUtil.TINT);
                break;
            }
            case 14: {
                bl = this.matchesType(OXMLSequenceType.TINTEGER);
                break;
            }
            case 16: {
                bl = this.matchesType(FNUtil.TLONG);
                break;
            }
            case 17: {
                bl = this.matchesType(OXMLSequenceType.TDATETIME);
                break;
            }
            case 18: {
                bl = this.matchesType(OXMLSequenceType.TDECIMAL);
                break;
            }
            case 19: {
                bl = this.matchesType(OXMLSequenceType.TDOUBLE);
                break;
            }
            case 21: {
                bl = this.matchesType(OXMLSequenceType.TFLOAT);
                break;
            }
            case 27: {
                bl = this.matchesType(OXMLSequenceType.THEXBINARY);
                break;
            }
            case 30: {
                bl = this.matchesType(OXMLSequenceType.TSTRING);
            }
        }
        return bl;
    }

    public boolean isCastable(OXMLSequenceType oXMLSequenceType) throws XQException {
        boolean bl = true;
        OXMLItem oXMLItem = this.getContext().createItem();
        oXMLItem.copyItem(this);
        try {
            oXMLItem.convert(oXMLSequenceType);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public void compareValue(OXMLItem oXMLItem, int n2, OXMLItem oXMLItem2) throws XQException {
        OXMLCollator oXMLCollator = null;
        OXMLFunctionContext oXMLFunctionContext = null;
        try {
            oXMLFunctionContext = this.getContext();
        }
        catch (XQException xQException) {
            oXMLCollator = FNUtil.getCollator("http://www.w3.org/2005/xpath-functions/collation/codepoint", null);
            this.compareValue(oXMLItem, n2, oXMLItem2, oXMLCollator);
            return;
        }
        if (oXMLFunctionContext == null) {
            oXMLCollator = FNUtil.getCollator("http://www.w3.org/2005/xpath-functions/collation/codepoint", null);
        } else {
            String string = oXMLFunctionContext.getDefaultCollation();
            oXMLCollator = oXMLFunctionContext.getCollator(string);
            if (oXMLCollator == null) {
                oXMLCollator = FNUtil.getCollator(string, oXMLFunctionContext.getDBCharSet());
            }
        }
        this.compareValue(oXMLItem, n2, oXMLItem2, oXMLCollator);
    }

    public void compareValue(OXMLItem oXMLItem, int n2, OXMLItem oXMLItem2, OraCollator oraCollator) throws XQException {
        this.compareValue(oXMLItem, n2, oXMLItem2, OXMLCollator.newInstance(oraCollator));
    }

    public void compareValue(OXMLItem oXMLItem, int n2, OXMLItem oXMLItem2, OXMLCollator oXMLCollator) throws XQException {
        switch (n2) {
            case 212: 
            case 213: 
            case 214: 
            case 215: {
                switch (this.basicType) {
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 18: 
                    case 19: {
                        throw new XQException("XPTY0004");
                    }
                    case 6: {
                        if (this.stype.getPrimitiveId() == oXMLItem.stype.getPrimitiveId()) break;
                        throw new XQException("XPTY0004");
                    }
                }
                if (this.stype.getPrimitiveId() != 6 && oXMLItem.stype.getPrimitiveId() != 6) break;
                throw new XQException("XPTY0004");
            }
        }
        int n3 = this.compareValue(oXMLItem, oXMLCollator);
        if (n3 == -2 && this.isNumeric()) {
            oXMLItem2.setBoolean(OXMLSequenceType.TBOOLEAN, n2 == 211);
        } else if (this.basicType == 6 && (n2 == 210 || n2 == 211)) {
            oXMLItem2.setBoolean(OXMLSequenceType.TBOOLEAN, n2 == 210 ? n3 == 0 : n3 != 0);
        } else {
            if (n3 > 1 || n3 < -1 || n2 < 210 || n2 > 215) {
                throw new XQException("XPTY0004");
            }
            oXMLItem2.setBoolean(OXMLSequenceType.TBOOLEAN, compTable[n3 + 1][n2 - 210]);
        }
    }

    private boolean isNumeric() {
        return this.basicType == 3 || this.basicType == 4 || this.basicType == 5;
    }

    public int compareValue(OXMLItem oXMLItem) throws XQException {
        OXMLCollator oXMLCollator = null;
        OXMLFunctionContext oXMLFunctionContext = null;
        try {
            oXMLFunctionContext = this.getContext();
        }
        catch (XQException xQException) {
            oXMLCollator = FNUtil.getCollator("http://www.w3.org/2005/xpath-functions/collation/codepoint", null);
            return this.compareValue(oXMLItem, oXMLCollator);
        }
        if (oXMLFunctionContext == null) {
            oXMLCollator = FNUtil.getCollator("http://www.w3.org/2005/xpath-functions/collation/codepoint", null);
        } else {
            String string = oXMLFunctionContext.getDefaultCollation();
            oXMLCollator = oXMLFunctionContext.getCollator(string);
            if (oXMLCollator == null) {
                oXMLCollator = FNUtil.getCollator(string, oXMLFunctionContext.getDBCharSet());
            }
        }
        return this.compareValue(oXMLItem, oXMLCollator);
    }

    public int compareValue(OXMLItem oXMLItem, OraCollator oraCollator) throws XQException {
        return this.compareValue(oXMLItem, OXMLCollator.newInstance(oraCollator));
    }

    public int compareValue(OXMLItem oXMLItem, OXMLCollator oXMLCollator) throws XQException {
        int n2 = this.stype.getPrimitiveId();
        n2 = n2 == 0 ? 1 : n2;
        int n3 = oXMLItem.stype.getPrimitiveId();
        n3 = n3 == 0 ? 1 : n3;
        switch (this.getComp(n2, n3)) {
            case 2: {
                if (this.booleanValue == oXMLItem.booleanValue) {
                    return 0;
                }
                if (this.booleanValue) {
                    return 1;
                }
                return -1;
            }
            case 3: {
                if (Double.isNaN(this.doubleValue) || Double.isNaN(oXMLItem.doubleValue)) {
                    return -2;
                }
                if (Double.isInfinite(this.doubleValue)) {
                    if (Double.isInfinite(oXMLItem.doubleValue)) {
                        if (this.doubleValue > 0.0) {
                            return oXMLItem.doubleValue > 0.0 ? 0 : 1;
                        }
                        return oXMLItem.doubleValue < 0.0 ? 0 : -1;
                    }
                    return this.doubleValue > 0.0 ? 1 : -1;
                }
                float f2 = this.floatValue() - oXMLItem.floatValue();
                if (f2 > 0.0f) {
                    return 1;
                }
                if (f2 < 0.0f) {
                    return -1;
                }
                if (f2 == 0.0f) {
                    return 0;
                }
            }
            case 4: {
                if (Double.isNaN(this.doubleValue) || Double.isNaN(oXMLItem.doubleValue)) {
                    return -2;
                }
                if (Double.isInfinite(this.doubleValue)) {
                    if (Double.isInfinite(oXMLItem.doubleValue)) {
                        if (this.doubleValue > 0.0) {
                            return oXMLItem.doubleValue > 0.0 ? 0 : 1;
                        }
                        return oXMLItem.doubleValue < 0.0 ? 0 : -1;
                    }
                    return this.doubleValue > 0.0 ? 1 : -1;
                }
                double d2 = this.doubleValue() - oXMLItem.doubleValue();
                if (d2 > 0.0) {
                    return 1;
                }
                if (d2 < 0.0) {
                    return -1;
                }
                if (d2 == 0.0) {
                    return 0;
                }
            }
            case 5: 
            case 22: {
                if (this.booleanValue || oXMLItem.booleanValue) {
                    return this.getDecimal().compareTo(oXMLItem.getDecimal());
                }
                if (this.intValue > oXMLItem.intValue) {
                    return 1;
                }
                if (this.intValue < oXMLItem.intValue) {
                    return -1;
                }
                return 0;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                GregorianCalendar gregorianCalendar = (GregorianCalendar)this.objValue;
                GregorianCalendar gregorianCalendar2 = (GregorianCalendar)oXMLItem.objValue;
                if (this.booleanValue != oXMLItem.booleanValue) {
                    TimeZone timeZone = this.getContext().getImplicitTimezone();
                    if (!this.booleanValue) {
                        gregorianCalendar = (GregorianCalendar)gregorianCalendar.clone();
                        gregorianCalendar.setTimeZone(timeZone);
                    } else {
                        gregorianCalendar2 = (GregorianCalendar)gregorianCalendar2.clone();
                        gregorianCalendar2.setTimeZone(timeZone);
                    }
                }
                if (gregorianCalendar.after(gregorianCalendar2)) {
                    return 1;
                }
                if (gregorianCalendar2.after(gregorianCalendar)) {
                    return -1;
                }
                return 0;
            }
            case 6: 
            case 20: 
            case 21: {
                return this.compareVal(oXMLItem, 6);
            }
            case 1: {
                int n4 = oXMLCollator.compare(this.getString(), oXMLItem.getString());
                n4 = n4 > 0 ? 1 : (n4 < 0 ? -1 : 0);
                return n4;
            }
            case 15: 
            case 16: 
            case 17: {
                int n5 = this.getString().compareTo(oXMLItem.getString());
                n5 = n5 > 0 ? 1 : (n5 < 0 ? -1 : 0);
                return n5;
            }
            case 19: {
                int n6;
                OXMLItem oXMLItem2 = this.getContext().createItem();
                oXMLItem2.setString(OXMLSequenceType.TSTRING, this.getString());
                oXMLItem2.convert2QName();
                OXMLItem oXMLItem3 = this.getContext().createItem();
                oXMLItem3.setString(OXMLSequenceType.TSTRING, oXMLItem.getString());
                oXMLItem3.convert2QName();
                boolean bl = oXMLItem2.getQName().equals(oXMLItem3.getQName());
                int n7 = n6 = bl ? 0 : -1;
                if (n6 != 0) {
                    n6 = oXMLItem2.getQName().toString().compareTo(oXMLItem3.getQName().toString());
                }
                n6 = n6 > 0 ? 1 : (n6 < 0 ? -1 : 0);
                return n6;
            }
            case 18: {
                int n8;
                boolean bl = this.getQName().equals(oXMLItem.getQName());
                int n9 = n8 = bl ? 0 : -1;
                if (n8 != 0) {
                    n8 = this.getQName().toString().compareTo(oXMLItem.getQName().toString());
                }
                n8 = n8 > 0 ? 1 : (n8 < 0 ? -1 : 0);
                return n8;
            }
        }
        throw new XQException("XPTY0004");
    }

    private int getComp(int n2, int n3) throws XQException {
        if (n2 == n3) {
            return n2;
        }
        if ((n2 <= 5 && n2 >= 3 || n2 == 22) && (n3 <= 5 && n3 >= 3 || n3 == 22)) {
            switch (n2) {
                case 22: {
                    return n3;
                }
                case 5: {
                    return n3 == 22 ? n2 : n3;
                }
                case 3: {
                    return n3 == 4 ? n3 : n2;
                }
                case 4: {
                    return n2;
                }
            }
        }
        if (n2 == 1 && n3 == 17 || n3 == 1 && n2 == 17) {
            return 1;
        }
        if (!(n2 != 6 && n2 != 21 && n2 != 20 || n3 != 6 && n3 != 21 && n3 != 20)) {
            return 6;
        }
        throw new XQException("XPTY0004");
    }

    private double doubleValue() throws XQException {
        int n2 = this.stype.getPrimitiveId();
        if (n2 == 3) {
            return (float)this.doubleValue;
        }
        if (n2 == 4) {
            return this.doubleValue;
        }
        if (n2 == 5 || n2 == 22) {
            return this.booleanValue ? ((BigDecimal)this.objValue).doubleValue() : (double)this.intValue;
        }
        throw new XQException("XPTY0004");
    }

    private float floatValue() throws XQException {
        int n2 = this.stype.getPrimitiveId();
        if (n2 == 3) {
            return (float)this.doubleValue;
        }
        if (n2 == 5 || n2 == 22) {
            return this.booleanValue ? ((BigDecimal)this.objValue).floatValue() : (float)this.intValue;
        }
        throw new XQException("XPTY0004");
    }

    private BigDecimal decimalValue() throws XQException {
        int n2 = this.stype.getPrimitiveId();
        if (n2 == 5 || n2 == 22) {
            return this.booleanValue ? (BigDecimal)this.objValue : BigDecimal.valueOf(this.intValue);
        }
        throw new XQException("XPTY0004");
    }

    public void setDecimal(OXMLSequenceType oXMLSequenceType, long l2) throws XQException {
        this.booleanValue = false;
        if ((long)((int)l2) == l2) {
            this.setInt(oXMLSequenceType, (int)l2);
        } else {
            this.setDecimal(oXMLSequenceType, new BigDecimal(l2));
        }
    }

    public void compareNodes(OXMLItem oXMLItem, int n2, OXMLItem oXMLItem2) throws XQException {
        int n3 = FNUtil.compareNodeOrder(this.nodeValue, oXMLItem.nodeValue);
        boolean bl = false;
        switch (n2) {
            case 208: {
                bl = n3 == 0;
                break;
            }
            case 209: {
                if (!XMLParser.getIs1010Compatible()) break;
                bl = n3 != 0;
                break;
            }
            case 223: {
                bl = n3 > 0;
                break;
            }
            case 222: {
                bl = n3 < 0;
            }
        }
        oXMLItem2.setBoolean(OXMLSequenceType.TBOOLEAN, bl);
    }

    public void negate() throws XQException {
        int n2 = this.stype.getPrimitiveId();
        if (n2 == 5 || n2 == 22) {
            if (this.booleanValue) {
                this.objValue = ((BigDecimal)this.objValue).negate();
                BigDecimal bigDecimal = new BigDecimal(Integer.toString(Integer.MIN_VALUE));
                if (((BigDecimal)this.objValue).compareTo(bigDecimal) == 0) {
                    this.booleanValue = false;
                    this.intValue = Integer.MIN_VALUE;
                }
            } else if (this.intValue == Integer.MIN_VALUE) {
                this.booleanValue = true;
                this.objValue = new BigDecimal(this.intValue);
                this.objValue = ((BigDecimal)this.objValue).negate();
            } else {
                this.intValue = -this.intValue;
            }
            this.lexicalValue = null;
        } else if (n2 == 4 || n2 == 3) {
            this.doubleValue = -this.doubleValue;
            this.lexicalValue = null;
        }
    }

    public void arithmetic(OXMLItem oXMLItem, int n2, OXMLItem oXMLItem2) throws XQException {
        if (this.stype == null || oXMLItem.stype == null) {
            throw new XQException("FOTY0014");
        }
        int n3 = this.stype.getPrimitiveId();
        int n4 = oXMLItem.stype.getPrimitiveId();
        switch (OXMLItem.getCase(this.basicType, oXMLItem.basicType, n2)) {
            case 1: {
                oXMLItem2.setDouble(OXMLSequenceType.TFLOAT, this.floatValue() + oXMLItem.floatValue());
                return;
            }
            case 2: {
                oXMLItem2.setDouble(OXMLSequenceType.TDOUBLE, this.doubleValue() + oXMLItem.doubleValue());
                return;
            }
            case 3: {
                if (this.booleanValue || oXMLItem.booleanValue) {
                    BigDecimal bigDecimal = this.decimalValue().add(oXMLItem.decimalValue());
                    if (n3 == 22 && n4 == 22) {
                        oXMLItem2.setDecimal(OXMLSequenceType.TINTEGER, bigDecimal);
                    } else {
                        oXMLItem2.setDecimal(OXMLSequenceType.TDECIMAL, bigDecimal);
                    }
                } else {
                    long l2 = (long)this.intValue + (long)oXMLItem.intValue;
                    if (n3 == 22 && n4 == 22) {
                        oXMLItem2.setDecimal(OXMLSequenceType.TINTEGER, l2);
                    } else {
                        oXMLItem2.setDecimal(OXMLSequenceType.TDECIMAL, l2);
                    }
                }
                return;
            }
            case 4: {
                oXMLItem2.setDouble(OXMLSequenceType.TFLOAT, this.floatValue() - oXMLItem.floatValue());
                return;
            }
            case 5: {
                oXMLItem2.setDouble(OXMLSequenceType.TDOUBLE, this.doubleValue() - oXMLItem.doubleValue());
                return;
            }
            case 6: {
                if (this.booleanValue || oXMLItem.booleanValue) {
                    BigDecimal bigDecimal = this.decimalValue().subtract(oXMLItem.decimalValue());
                    if (n3 == 22 && n4 == 22) {
                        oXMLItem2.setDecimal(OXMLSequenceType.TINTEGER, bigDecimal);
                    } else {
                        oXMLItem2.setDecimal(OXMLSequenceType.TDECIMAL, bigDecimal);
                    }
                } else {
                    long l3 = (long)this.intValue - (long)oXMLItem.intValue;
                    if (n3 == 22 && n4 == 22) {
                        oXMLItem2.setDecimal(OXMLSequenceType.TINTEGER, l3);
                    } else {
                        oXMLItem2.setDecimal(OXMLSequenceType.TDECIMAL, l3);
                    }
                }
                return;
            }
            case 7: {
                oXMLItem2.setDouble(OXMLSequenceType.TFLOAT, this.floatValue() * oXMLItem.floatValue());
                return;
            }
            case 8: {
                oXMLItem2.setDouble(OXMLSequenceType.TDOUBLE, this.doubleValue() * oXMLItem.doubleValue());
                return;
            }
            case 9: {
                if (this.booleanValue || oXMLItem.booleanValue) {
                    BigDecimal bigDecimal = this.decimalValue().multiply(oXMLItem.decimalValue());
                    if (n3 == 22 && n4 == 22) {
                        oXMLItem2.setDecimal(OXMLSequenceType.TINTEGER, bigDecimal);
                    } else {
                        oXMLItem2.setDecimal(OXMLSequenceType.TDECIMAL, bigDecimal);
                    }
                } else {
                    long l4 = (long)this.intValue * (long)oXMLItem.intValue;
                    if (n3 == 22 && n4 == 22) {
                        oXMLItem2.setDecimal(OXMLSequenceType.TINTEGER, l4);
                    } else {
                        oXMLItem2.setDecimal(OXMLSequenceType.TDECIMAL, l4);
                    }
                }
                return;
            }
            case 10: {
                oXMLItem2.setDouble(OXMLSequenceType.TFLOAT, this.floatValue() / oXMLItem.floatValue());
                return;
            }
            case 11: {
                oXMLItem2.setDouble(OXMLSequenceType.TDOUBLE, this.doubleValue() / oXMLItem.doubleValue());
                return;
            }
            case 12: {
                if (oXMLItem.isZero()) {
                    throw new XQException("FOAR0001");
                }
                if (this.isZero()) {
                    oXMLItem2.setDecimal(OXMLSequenceType.TDECIMAL, 0L);
                    return;
                }
                if (!this.booleanValue && !oXMLItem.booleanValue && this.intValue % oXMLItem.intValue == 0) {
                    long l5 = (long)this.intValue / (long)oXMLItem.intValue;
                    oXMLItem2.setDecimal(OXMLSequenceType.TDECIMAL, l5);
                } else {
                    BigDecimal bigDecimal = this.decimalValue().divide(oXMLItem.decimalValue(), 20, 1);
                    oXMLItem2.setDecimal(OXMLSequenceType.TDECIMAL, bigDecimal);
                }
                return;
            }
            case 13: {
                if (oXMLItem.isZero()) {
                    throw new XQException("FOAR0001");
                }
                if (this.isZero()) {
                    oXMLItem2.setDecimal(OXMLSequenceType.TINTEGER, 0L);
                    return;
                }
                if (!this.booleanValue && !oXMLItem.booleanValue && this.intValue % oXMLItem.intValue == 0) {
                    long l6 = (long)this.intValue / (long)oXMLItem.intValue;
                    oXMLItem2.setDecimal(OXMLSequenceType.TINTEGER, l6);
                } else {
                    BigDecimal bigDecimal = this.decimalValue().divide(oXMLItem.decimalValue(), 0, 1);
                    oXMLItem2.setDecimal(OXMLSequenceType.TINTEGER, bigDecimal);
                }
                return;
            }
            case 32: {
                if (oXMLItem.isZero()) {
                    throw new XQException("FOAR0001");
                }
                if (this.isINF() || this.isNaN() || oXMLItem.isNaN()) {
                    throw new XQException("FOAR0002");
                }
                float f2 = oXMLItem.floatValue();
                oXMLItem2.setDouble(OXMLSequenceType.TFLOAT, this.floatValue() / f2);
                oXMLItem2.convertFloatDouble2Integer();
                return;
            }
            case 33: {
                if (oXMLItem.isZero()) {
                    throw new XQException("FOAR0001");
                }
                if (this.isINF() || this.isNaN() || oXMLItem.isNaN()) {
                    throw new XQException("FOAR0002");
                }
                double d2 = oXMLItem.doubleValue();
                oXMLItem2.setDouble(OXMLSequenceType.TDOUBLE, this.doubleValue() / d2);
                oXMLItem2.convertFloatDouble2Integer();
                return;
            }
            case 14: {
                oXMLItem2.setDouble(OXMLSequenceType.TFLOAT, this.floatValue() % oXMLItem.floatValue());
                return;
            }
            case 15: {
                oXMLItem2.setDouble(OXMLSequenceType.TDOUBLE, this.doubleValue() % oXMLItem.doubleValue());
                return;
            }
            case 16: {
                if (oXMLItem.isZero()) {
                    throw new XQException("FOAR0001");
                }
                if (this.booleanValue || oXMLItem.booleanValue) {
                    BigDecimal bigDecimal = this.decimalValue().subtract(this.decimalValue().divide(oXMLItem.decimalValue(), 0, 1).multiply(oXMLItem.decimalValue()));
                    if (n3 == 22 && n4 == 22) {
                        oXMLItem2.setDecimal(OXMLSequenceType.TINTEGER, bigDecimal);
                    } else {
                        oXMLItem2.setDecimal(OXMLSequenceType.TDECIMAL, bigDecimal);
                    }
                } else {
                    long l7 = (long)this.intValue % (long)oXMLItem.intValue;
                    if (n3 == 22 && n4 == 22) {
                        oXMLItem2.setDecimal(OXMLSequenceType.TINTEGER, l7);
                    } else {
                        oXMLItem2.setDecimal(OXMLSequenceType.TDECIMAL, l7);
                    }
                }
                return;
            }
            case 17: {
                if (n3 != n4 || n3 == 6) {
                    throw new XQException("XPTY0004");
                }
                oXMLItem2.setDuration(OXMLSequenceType.getConstantType(1, n3), this.intValue + oXMLItem.intValue, this.doubleValue + oXMLItem.doubleValue);
                return;
            }
            case 18: {
                if (n3 != n4 || n3 == 6) {
                    throw new XQException("XPTY0004");
                }
                oXMLItem2.setDuration(OXMLSequenceType.getConstantType(1, n3), this.intValue - oXMLItem.intValue, this.doubleValue - oXMLItem.doubleValue);
                return;
            }
            case 19: {
                if (n3 == 6) {
                    throw new XQException("XPTY0004");
                }
                if (oXMLItem.isNaN()) {
                    throw new XQException("FOCA0005");
                }
                if (oXMLItem.isINF()) {
                    throw new XQException("FODT0002");
                }
                oXMLItem2.setDuration(OXMLSequenceType.getConstantType(1, n3), (int)((double)this.intValue * oXMLItem.doubleValue()), this.doubleValue * oXMLItem.doubleValue());
                return;
            }
            case 36: {
                if (n4 == 6) {
                    throw new XQException("XPTY0004");
                }
                if (this.isNaN()) {
                    throw new XQException("FOCA0005");
                }
                if (this.isINF()) {
                    throw new XQException("FODT0002");
                }
                oXMLItem2.setDuration(OXMLSequenceType.getConstantType(1, n4), (int)((double)oXMLItem.intValue * this.doubleValue()), oXMLItem.doubleValue * this.doubleValue());
                return;
            }
            case 37: {
                if (n3 == 6) {
                    throw new XQException("XPTY0004");
                }
                oXMLItem2.setDuration(OXMLSequenceType.getConstantType(1, n3), (int)((double)this.intValue * (oXMLItem.intFormat() ? (double)oXMLItem.intValue : oXMLItem.doubleValue())), this.doubleValue * (oXMLItem.intFormat() ? (double)oXMLItem.intValue : oXMLItem.doubleValue()));
                return;
            }
            case 38: {
                if (n4 == 6) {
                    throw new XQException("XPTY0004");
                }
                oXMLItem2.setDuration(OXMLSequenceType.getConstantType(1, n4), (int)((double)oXMLItem.intValue * (this.intFormat() ? (double)this.intValue : this.doubleValue())), oXMLItem.doubleValue * (this.intFormat() ? (double)this.intValue : this.doubleValue()));
                return;
            }
            case 20: {
                if (n3 == 6) {
                    throw new XQException("XPTY0004");
                }
                if (oXMLItem.isNaN()) {
                    throw new XQException("FOCA0005");
                }
                if (oXMLItem.isZero()) {
                    throw new XQException("FODT0002");
                }
                oXMLItem2.setDuration(OXMLSequenceType.getConstantType(1, n3), (int)((double)this.intValue / oXMLItem.doubleValue()), this.doubleValue / oXMLItem.doubleValue());
                return;
            }
            case 34: {
                BigDecimal bigDecimal;
                if (n3 != n4 || n3 == 6) {
                    throw new XQException("XPTY0004");
                }
                if (n3 == 20) {
                    if (oXMLItem.intValue == 0) {
                        throw new XQException("FODT0002");
                    }
                    if (this.intValue == 0) {
                        oXMLItem2.setDecimal(OXMLSequenceType.TDECIMAL, 0L);
                        return;
                    }
                    bigDecimal = new BigDecimal(this.intValue).divide(new BigDecimal(oXMLItem.intValue), 20, 1);
                } else {
                    if (oXMLItem.doubleValue == 0.0) {
                        throw new XQException("FODT0002");
                    }
                    if (this.doubleValue == 0.0) {
                        oXMLItem2.setDecimal(OXMLSequenceType.TDECIMAL, 0L);
                        return;
                    }
                    bigDecimal = new BigDecimal(this.doubleValue).divide(new BigDecimal(oXMLItem.doubleValue), 20, 1);
                }
                oXMLItem2.setDecimal(OXMLSequenceType.TDECIMAL, this.booleanValue == oXMLItem.booleanValue ? bigDecimal : bigDecimal.negate());
                return;
            }
            case 21: 
            case 22: 
            case 35: {
                long l8 = ((GregorianCalendar)this.objValue).getTimeInMillis() - ((GregorianCalendar)oXMLItem.objValue).getTimeInMillis();
                oXMLItem2.setDuration(OXMLSequenceType.TDTDURATION, 0, (double)l8 / 1000.0);
                return;
            }
            case 23: {
                GregorianCalendar gregorianCalendar = (GregorianCalendar)((GregorianCalendar)this.objValue).clone();
                TimeZone timeZone = gregorianCalendar.getTimeZone();
                boolean bl = this.isBigTimeZone(timeZone);
                int n5 = gregorianCalendar.get(5);
                if (bl) {
                    gregorianCalendar.setTimeZone(UTC);
                }
                if (n4 == 20) {
                    gregorianCalendar.add(2, oXMLItem.intValue);
                } else if (n4 == 21) {
                    this.addTime(gregorianCalendar, oXMLItem.doubleValue);
                } else {
                    throw new XQException("XPTY0004");
                }
                gregorianCalendar.getTime();
                if (bl) {
                    gregorianCalendar.setTimeZone(timeZone);
                    if (n5 > 28 && n4 == 20) {
                        this.adjustDay(gregorianCalendar, n5);
                    }
                }
                oXMLItem2.setCalendar(OXMLSequenceType.TDATETIME, this.booleanValue, gregorianCalendar);
                return;
            }
            case 24: {
                GregorianCalendar gregorianCalendar = (GregorianCalendar)((GregorianCalendar)this.objValue).clone();
                int n6 = gregorianCalendar.get(5);
                TimeZone timeZone = gregorianCalendar.getTimeZone();
                boolean bl = this.isBigTimeZone(timeZone);
                if (bl) {
                    gregorianCalendar.setTimeZone(UTC);
                }
                if (n4 == 20) {
                    gregorianCalendar.add(2, -oXMLItem.intValue);
                } else if (n4 == 21) {
                    this.addTime(gregorianCalendar, -oXMLItem.doubleValue);
                } else {
                    throw new XQException("XPTY0004");
                }
                gregorianCalendar.getTime();
                if (bl) {
                    gregorianCalendar.setTimeZone(timeZone);
                    if (n6 > 28 && n4 == 20) {
                        this.adjustDay(gregorianCalendar, n6);
                    }
                }
                oXMLItem2.setCalendar(OXMLSequenceType.TDATETIME, this.booleanValue, gregorianCalendar);
                return;
            }
            case 25: {
                GregorianCalendar gregorianCalendar = (GregorianCalendar)((GregorianCalendar)this.objValue).clone();
                int n7 = gregorianCalendar.get(5);
                TimeZone timeZone = gregorianCalendar.getTimeZone();
                boolean bl = this.isBigTimeZone(timeZone);
                if (bl) {
                    gregorianCalendar.setTimeZone(UTC);
                }
                if (n4 == 20) {
                    gregorianCalendar.add(2, oXMLItem.intValue);
                } else if (n4 == 21) {
                    this.addDays(gregorianCalendar, oXMLItem.doubleValue);
                } else {
                    throw new XQException("XPTY0004");
                }
                gregorianCalendar.getTime();
                if (bl) {
                    gregorianCalendar.setTimeZone(timeZone);
                    if (n7 > 28 && n4 == 20) {
                        this.adjustDay(gregorianCalendar, n7);
                    }
                }
                oXMLItem2.setCalendar(OXMLSequenceType.TDATE, this.booleanValue, gregorianCalendar);
                return;
            }
            case 26: {
                GregorianCalendar gregorianCalendar = (GregorianCalendar)((GregorianCalendar)this.objValue).clone();
                int n8 = gregorianCalendar.get(5);
                TimeZone timeZone = gregorianCalendar.getTimeZone();
                boolean bl = this.isBigTimeZone(timeZone);
                if (bl) {
                    gregorianCalendar.setTimeZone(UTC);
                }
                if (n4 == 20) {
                    gregorianCalendar.add(2, -oXMLItem.intValue);
                } else if (n4 == 21) {
                    this.addDays(gregorianCalendar, -oXMLItem.doubleValue);
                } else {
                    throw new XQException("XPTY0004");
                }
                gregorianCalendar.getTime();
                if (bl) {
                    gregorianCalendar.setTimeZone(timeZone);
                    if (n8 > 28 && n4 == 20) {
                        this.adjustDay(gregorianCalendar, n8);
                    }
                }
                oXMLItem2.setCalendar(OXMLSequenceType.TDATE, this.booleanValue, gregorianCalendar);
                return;
            }
            case 27: {
                if (n4 != 21) {
                    throw new XQException("XPTY0004");
                }
                GregorianCalendar gregorianCalendar = (GregorianCalendar)((GregorianCalendar)this.objValue).clone();
                TimeZone timeZone = gregorianCalendar.getTimeZone();
                boolean bl = this.isBigTimeZone(timeZone);
                if (bl) {
                    gregorianCalendar.setTimeZone(UTC);
                }
                this.addTime(gregorianCalendar, oXMLItem.doubleValue);
                gregorianCalendar.getTime();
                if (bl) {
                    gregorianCalendar.setTimeZone(timeZone);
                }
                oXMLItem2.setCalendar(OXMLSequenceType.TTIME, this.booleanValue, gregorianCalendar);
                return;
            }
            case 28: {
                if (n4 != 21) {
                    throw new XQException("XPTY0004");
                }
                GregorianCalendar gregorianCalendar = (GregorianCalendar)((GregorianCalendar)this.objValue).clone();
                TimeZone timeZone = gregorianCalendar.getTimeZone();
                boolean bl = this.isBigTimeZone(timeZone);
                if (bl) {
                    gregorianCalendar.setTimeZone(UTC);
                }
                this.addTime(gregorianCalendar, -oXMLItem.doubleValue);
                gregorianCalendar.getTime();
                if (bl) {
                    gregorianCalendar.setTimeZone(timeZone);
                }
                oXMLItem2.setCalendar(OXMLSequenceType.TTIME, this.booleanValue, gregorianCalendar);
                return;
            }
            case 29: {
                GregorianCalendar gregorianCalendar = (GregorianCalendar)((GregorianCalendar)oXMLItem.objValue).clone();
                int n9 = gregorianCalendar.get(5);
                TimeZone timeZone = gregorianCalendar.getTimeZone();
                boolean bl = this.isBigTimeZone(timeZone);
                if (bl) {
                    gregorianCalendar.setTimeZone(UTC);
                }
                if (n3 == 20) {
                    gregorianCalendar.add(2, oXMLItem.intValue);
                } else if (n3 == 21) {
                    this.addTime(gregorianCalendar, oXMLItem.doubleValue);
                } else {
                    throw new XQException("XPTY0004");
                }
                gregorianCalendar.getTime();
                if (bl) {
                    gregorianCalendar.setTimeZone(timeZone);
                    if (n9 > 28 && n3 == 20) {
                        this.adjustDay(gregorianCalendar, n9);
                    }
                }
                oXMLItem2.setCalendar(OXMLSequenceType.TDATETIME, oXMLItem.booleanValue, gregorianCalendar);
                return;
            }
            case 30: {
                GregorianCalendar gregorianCalendar = (GregorianCalendar)((GregorianCalendar)oXMLItem.objValue).clone();
                int n10 = gregorianCalendar.get(5);
                TimeZone timeZone = gregorianCalendar.getTimeZone();
                boolean bl = this.isBigTimeZone(timeZone);
                if (bl) {
                    gregorianCalendar.setTimeZone(UTC);
                }
                if (n3 == 20) {
                    gregorianCalendar.add(2, this.intValue);
                } else if (n3 == 21) {
                    this.addDays(gregorianCalendar, this.doubleValue);
                } else {
                    throw new XQException("XPTY0004");
                }
                gregorianCalendar.getTime();
                if (bl) {
                    gregorianCalendar.setTimeZone(timeZone);
                    if (n10 > 28 && n3 == 20) {
                        this.adjustDay(gregorianCalendar, n10);
                    }
                }
                oXMLItem2.setCalendar(OXMLSequenceType.TDATE, oXMLItem.booleanValue, gregorianCalendar);
                return;
            }
            case 31: {
                if (n3 != 21) {
                    throw new XQException("XPTY0004");
                }
                GregorianCalendar gregorianCalendar = (GregorianCalendar)((GregorianCalendar)oXMLItem.objValue).clone();
                TimeZone timeZone = gregorianCalendar.getTimeZone();
                boolean bl = this.isBigTimeZone(timeZone);
                if (bl) {
                    gregorianCalendar.setTimeZone(UTC);
                }
                this.addTime(gregorianCalendar, oXMLItem.doubleValue);
                gregorianCalendar.getTime();
                gregorianCalendar.setTimeZone(timeZone);
                oXMLItem2.setCalendar(OXMLSequenceType.TTIME, oXMLItem.booleanValue, gregorianCalendar);
                return;
            }
        }
        throw new XQException("XPTY0004");
    }

    public boolean isZero() {
        boolean bl = false;
        switch (this.getPrimitiveType()) {
            case 5: 
            case 22: {
                bl = this.booleanValue ? ((BigDecimal)this.objValue).compareTo(new BigDecimal(0)) == 0 : this.intValue == 0;
                break;
            }
            case 3: {
                bl = this.floatValue() == 0.0f;
                break;
            }
            case 4: {
                bl = this.doubleValue() == 0.0;
            }
        }
        return bl;
    }

    public boolean isNaN() {
        boolean bl = false;
        switch (this.getPrimitiveType()) {
            case 3: 
            case 4: {
                bl = Double.isNaN(this.doubleValue);
            }
        }
        return bl;
    }

    private boolean isINF() {
        boolean bl = false;
        switch (this.getPrimitiveType()) {
            case 3: 
            case 4: {
                bl = Double.isInfinite(this.doubleValue);
            }
        }
        return bl;
    }

    private void adjustDay(GregorianCalendar gregorianCalendar, int n2) {
        int n3;
        int n4 = gregorianCalendar.get(5);
        int n5 = n3 = gregorianCalendar.get(0) == 1 ? -1 : 1;
        if (n4 == 1) {
            gregorianCalendar.add(5, n3);
        }
    }

    private boolean isBigTimeZone(TimeZone timeZone) {
        int n2 = timeZone.getRawOffset();
        return n2 < -43200000 || n2 > 43200000;
    }

    private void addTime(GregorianCalendar gregorianCalendar, double d2) {
        if (d2 == 0.0) {
            return;
        }
        int n2 = (int)d2 / 86400;
        gregorianCalendar.add(5, n2);
        d2 -= (double)(n2 * 86400);
        n2 = (int)d2;
        gregorianCalendar.add(13, n2);
        d2 -= (double)n2;
        n2 = (int)d2 * 1000;
        gregorianCalendar.add(14, n2);
    }

    private void addDays(GregorianCalendar gregorianCalendar, double d2) {
        if (d2 == 0.0) {
            return;
        }
        int n2 = (int)d2 / 86400;
        gregorianCalendar.add(5, n2);
    }

    public void copyItem(OXMLItem oXMLItem) {
        this.copyDataValue(oXMLItem);
        this.nodeValue = oXMLItem.nodeValue;
        this.stype = oXMLItem.stype;
    }

    @Override
    public XMLNode getNode() {
        return this.nodeValue;
    }

    public void setNode(XMLNode xMLNode) throws XQException {
        this.setNode(null, xMLNode);
    }

    public void setNode(OXMLSequenceType oXMLSequenceType, XMLNode xMLNode) throws XQException {
        this.nodeValue = xMLNode;
        this.lexicalValue = null;
        this.objValue = null;
        this.stype = oXMLSequenceType;
    }

    @Override
    public String getLexicalValue() {
        if (this.lexicalValue != null) {
            return this.lexicalValue;
        }
        if (this.isNode()) {
            this.lexicalValue = this.nodeValue.getText();
            return this.lexicalValue;
        }
        if (this.stype == null) {
            return "";
        }
        int n2 = this.stype.getPrimitiveId();
        switch (n2) {
            case 3: 
            case 4: {
                if (Double.isNaN(this.doubleValue)) {
                    this.lexicalValue = "NaN";
                    break;
                }
                if (Double.isInfinite(this.doubleValue)) {
                    this.lexicalValue = this.doubleValue > 0.0 ? "INF" : "-INF";
                    break;
                }
                double d2 = n2 == 4 ? this.doubleValue : Double.parseDouble(Float.toString((float)this.doubleValue));
                double d3 = Math.abs(d2);
                DecimalFormat decimalFormat = d3 != 0.0 && (d3 >= 1000000.0 || d3 < 1.0E-6) ? dfUS.get() : this.getDecimalFormat();
                this.lexicalValue = decimalFormat.format(d2);
                break;
            }
            case 5: 
            case 22: {
                if (this.booleanValue) {
                    this.lexicalValue = this.getBigDecimalLexical((BigDecimal)this.objValue);
                    break;
                }
                DecimalFormat decimalFormat = this.getDecimalFormat();
                this.lexicalValue = decimalFormat.format(this.intValue);
                break;
            }
            case 2: {
                this.lexicalValue = this.booleanValue ? "true" : "false";
                break;
            }
            case 6: 
            case 20: 
            case 21: {
                this.lexicalValue = this.getDurationLexical(n2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                this.lexicalValue = this.getDateTimeLexical(n2);
                break;
            }
            case 18: {
                QName qName = (QName)this.objValue;
                String string = qName.getPrefix();
                String string2 = qName.getLocalPart();
                if (string == null || string.length() == 0) {
                    this.lexicalValue = string2;
                    break;
                }
                this.lexicalValue = string + ':' + string2;
                break;
            }
        }
        this.lexicalValue = this.lexicalValue.intern();
        return this.lexicalValue;
    }

    public DecimalFormat getDecimalFormat() {
        DecimalFormat decimalFormat = (DecimalFormat)DecimalFormat.getInstance(Locale.US);
        decimalFormat.setGroupingUsed(false);
        decimalFormat.setMaximumFractionDigits(100);
        return decimalFormat;
    }

    public String getBigDecimalLexical(BigDecimal bigDecimal) {
        int n2;
        String string = bigDecimal.toPlainString();
        int n3 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n3);
        int n4 = string.indexOf(46);
        if (n4 < 0) {
            n4 = n3;
        }
        int n5 = n2 = string.charAt(0) == '+' ? 1 : 0;
        while (n2 < n4 - 1 && string.charAt(n2) == '0') {
            ++n2;
        }
        stringBuffer.append(string.substring(n2, n4));
        if (n4 != n3) {
            for (n2 = n3 - 1; n2 > n4 && string.charAt(n2) == '0'; --n2) {
            }
            if (n2 > n4) {
                stringBuffer.append(string.substring(n4, n2 + 1));
            }
        }
        return stringBuffer.toString();
    }

    public String getDurationLexical() {
        return this.getDurationLexical(this.stype.getPrimitiveId());
    }

    String getDurationLexical(int n2) {
        long l2;
        long l3;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.intValue < 0 || this.doubleValue < 0.0) {
            stringBuffer.append('-');
        }
        stringBuffer.append('P');
        if (n2 != 21) {
            l3 = this.intValue >= 0 ? (long)this.intValue : (long)(-this.intValue);
            l2 = l3 / 12L;
            if (l2 > 0L) {
                stringBuffer.append(l2);
                stringBuffer.append('Y');
            }
            if ((l2 = l3 % 12L) > 0L) {
                stringBuffer.append(l2);
                stringBuffer.append('M');
            }
            if (n2 == 20 && stringBuffer.length() <= 2) {
                return "P0M";
            }
        }
        if (n2 != 20) {
            int n3;
            l3 = Math.round(this.doubleValue >= 0.0 ? this.doubleValue * 1000.0 : -this.doubleValue * 1000.0);
            l2 = l3 / 86400000L;
            l3 %= 86400000L;
            if (l2 > 0L) {
                stringBuffer.append(l2);
                stringBuffer.append('D');
            }
            stringBuffer.append('T');
            l2 = l3 / 3600000L;
            l3 %= 3600000L;
            if (l2 > 0L) {
                stringBuffer.append(l2);
                stringBuffer.append('H');
            }
            l2 = l3 / 60000L;
            l3 %= 60000L;
            if (l2 > 0L) {
                stringBuffer.append(l2);
                stringBuffer.append('M');
            }
            if (l3 > 0L) {
                l2 = l3 / 1000L;
                stringBuffer.append(l2);
                if ((l3 %= 1000L) > 0L) {
                    int n4;
                    stringBuffer.append('.');
                    if (l3 < 100L) {
                        stringBuffer.append('0');
                    }
                    if (l3 < 10L) {
                        stringBuffer.append('0');
                    }
                    String string = String.valueOf(l3);
                    for (n4 = string.length() - 1; n4 >= 0 && string.charAt(n4) == '0'; --n4) {
                    }
                    stringBuffer.append(string.substring(0, n4 + 1));
                }
                stringBuffer.append('S');
            }
            if (stringBuffer.charAt(n3 = stringBuffer.length() - 1) == 'T') {
                if (stringBuffer.charAt(n3 - 1) == 'P') {
                    return "PT0S";
                }
                stringBuffer.deleteCharAt(n3);
            }
        }
        return stringBuffer.toString();
    }

    String getDateTimeLexical(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        GregorianCalendar gregorianCalendar = (GregorianCalendar)this.objValue;
        if (n2 == 7 || n2 == 9 || n2 == 10 || n2 == 11) {
            if (gregorianCalendar.get(0) == 0) {
                stringBuffer.append('-');
                n3 = 1;
            }
            stringBuffer.append(gregorianCalendar.get(1));
            while (stringBuffer.length() - n3 < 4) {
                stringBuffer.insert(n3, '0');
            }
        }
        if (n2 != 11 && n2 != 8) {
            if (stringBuffer.length() == 0) {
                stringBuffer.append('-');
            }
            stringBuffer.append('-');
            if (n2 != 14) {
                n3 = gregorianCalendar.get(2) + 1;
                if (n3 < 10) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(n3);
            } else {
                stringBuffer.append('-');
            }
            if (n2 != 12 && n2 != 10) {
                if (n2 != 14) {
                    stringBuffer.append('-');
                }
                if ((n3 = gregorianCalendar.get(5)) < 10) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(n3);
            }
        }
        if (n2 == 7 || n2 == 8) {
            if (n2 == 7) {
                stringBuffer.append('T');
            }
            if ((n3 = gregorianCalendar.get(11)) < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n3);
            stringBuffer.append(':');
            n3 = gregorianCalendar.get(12);
            if (n3 < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n3);
            stringBuffer.append(':');
            n3 = gregorianCalendar.get(13);
            if (n3 < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n3);
            n3 = gregorianCalendar.get(14);
            if (n3 > 0) {
                int n4;
                stringBuffer.append('.');
                if (n3 < 100) {
                    stringBuffer.append('0');
                }
                if (n3 < 10) {
                    stringBuffer.append('0');
                }
                String string = String.valueOf(n3);
                for (n4 = string.length() - 1; n4 >= 0 && string.charAt(n4) == '0'; --n4) {
                }
                stringBuffer.append(string.substring(0, n4 + 1));
            }
        }
        if (this.booleanValue) {
            int n5 = gregorianCalendar.getTimeZone().getRawOffset() / 60000;
            if (n5 == 0) {
                stringBuffer.append('Z');
                return stringBuffer.toString();
            }
            if (n5 > 0) {
                stringBuffer.append('+');
            } else {
                stringBuffer.append('-');
                n5 = -n5;
            }
            n3 = n5 / 60;
            if (n3 < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n3);
            n3 = n5 % 60;
            stringBuffer.append(':');
            if (n3 < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n3);
        }
        return stringBuffer.toString();
    }

    public Object getExternalObject() {
        return this.objValue;
    }

    public void setExternalObject(Object object) throws XQException {
        this.stype = null;
        this.basicType = -1;
        this.objValue = object;
        this.lexicalValue = null;
        this.nodeValue = null;
    }

    public void setUntypedLexical(String string) throws XQException {
        this.lexicalValue = string;
        this.basicType = 0;
        this.nodeValue = null;
        this.objValue = null;
        this.stype = OXMLSequenceType.TUNTYPED;
    }

    @Override
    public String getString() {
        return this.lexicalValue;
    }

    public void setString(OXMLSequenceType oXMLSequenceType, String string) throws XQException {
        this.setType(oXMLSequenceType);
        this.lexicalValue = string;
        this.nodeValue = null;
        this.objValue = null;
        if (this.basicType != 1 && this.basicType != 17 && this.basicType != 19 && this.basicType != 16 && this.basicType != 15) {
            throw new XQException("FOTY0001");
        }
    }

    @Override
    public boolean getBoolean() {
        return this.booleanValue;
    }

    public void setBoolean(OXMLSequenceType oXMLSequenceType, boolean bl) throws XQException {
        this.setType(oXMLSequenceType);
        this.booleanValue = bl;
        this.lexicalValue = null;
        this.nodeValue = null;
        this.objValue = null;
        if (this.basicType != 2) {
            throw new XQException("FOTY0001");
        }
    }

    @Override
    public GregorianCalendar getCalendar() {
        return (GregorianCalendar)this.objValue;
    }

    public boolean hasTimeZone() {
        return this.booleanValue;
    }

    public void setCalendar(OXMLSequenceType oXMLSequenceType, boolean bl, GregorianCalendar gregorianCalendar) throws XQException {
        this.setType(oXMLSequenceType);
        this.objValue = gregorianCalendar;
        this.lexicalValue = null;
        this.nodeValue = null;
        this.booleanValue = bl;
        if (this.basicType < 7 || this.basicType > 14 || !bl && gregorianCalendar.get(15) != 0) {
            throw new XQException("FOTY0001");
        }
    }

    @Override
    public int getYearMonthDuration() {
        return this.intValue;
    }

    @Override
    public double getDayTimeDuration() {
        return this.doubleValue;
    }

    public void setDuration(OXMLSequenceType oXMLSequenceType, int n2, double d2) throws XQException {
        this.setType(oXMLSequenceType);
        this.intValue = n2;
        this.doubleValue = d2;
        this.lexicalValue = null;
        this.nodeValue = null;
        this.objValue = null;
        if (this.basicType != 6) {
            throw new XQException("FOTY0001");
        }
    }

    public boolean withinRange() throws XQException {
        return !this.booleanValue;
    }

    @Override
    public boolean intFormat() {
        return this.withinRange();
    }

    @Override
    public int getInt() {
        return this.intValue;
    }

    public void setInt(OXMLSequenceType oXMLSequenceType, int n2) throws XQException {
        this.setType(oXMLSequenceType);
        this.intValue = n2;
        this.booleanValue = false;
        this.lexicalValue = null;
        this.nodeValue = null;
        this.objValue = null;
        if (this.basicType != 5) {
            throw new XQException("FOTY0001");
        }
    }

    @Override
    public double getDouble() {
        return this.doubleValue;
    }

    @Override
    public float getFloat() {
        return (float)this.doubleValue;
    }

    public void setDouble(OXMLSequenceType oXMLSequenceType, double d2) throws XQException {
        this.setType(oXMLSequenceType);
        this.doubleValue = d2;
        if (this.basicType == 3) {
            if (d2 > 3.4028234663852886E38) {
                this.doubleValue = Double.POSITIVE_INFINITY;
            } else if (d2 < -3.4028234663852886E38) {
                this.doubleValue = Double.NEGATIVE_INFINITY;
            } else if (Math.abs(d2) < (double)1.4E-45f) {
                this.doubleValue = 0.0;
            }
        }
        this.lexicalValue = null;
        this.nodeValue = null;
        this.objValue = null;
        if (this.basicType != 4 && this.basicType != 3) {
            throw new XQException("FOTY0001");
        }
    }

    @Override
    public BigDecimal getDecimal() {
        if (this.booleanValue) {
            return (BigDecimal)this.objValue;
        }
        return new BigDecimal((double)this.intValue);
    }

    public void setDecimal(OXMLSequenceType oXMLSequenceType, BigDecimal bigDecimal) throws XQException {
        this.setType(oXMLSequenceType);
        this.objValue = bigDecimal;
        this.booleanValue = true;
        this.lexicalValue = null;
        this.nodeValue = null;
        if (this.basicType != 5) {
            throw new XQException("FOTY0001");
        }
    }

    public QName getQName() {
        return (QName)this.objValue;
    }

    public void setQName(OXMLSequenceType oXMLSequenceType, QName qName) throws XQException {
        this.setType(oXMLSequenceType);
        this.objValue = qName;
        this.lexicalValue = null;
        this.nodeValue = null;
        if (this.basicType != 18) {
            throw new XQException("FOTY0001");
        }
    }

    private void setType(OXMLSequenceType oXMLSequenceType) throws XQException {
        if (oXMLSequenceType == null) {
            throw new XQException("FOTY0001");
        }
        this.stype = oXMLSequenceType;
        int n2 = oXMLSequenceType.getPrimitiveId();
        this.basicType = n2 == 21 || n2 == 20 ? 6 : (n2 == 22 ? 5 : n2);
    }

    static int getCase(int n2, int n3, int n4) throws XQException {
        if (n4 > 2005 || n2 < 3 || n3 < 3 || n2 > 9 || n3 > 9) {
            throw new XQException("XPTY0004");
        }
        return opTable[n4 - 200][opComb[n2 - 3][n3 - 3]];
    }

    static {
        int n2;
        castTable = new boolean[22][22];
        for (n2 = 0; n2 < 22; ++n2) {
            for (int i2 = 0; i2 < 22; ++i2) {
                OXMLItem.castTable[n2][i2] = false;
            }
        }
        for (n2 = 0; n2 < 22; ++n2) {
            OXMLItem.castTable[n2][n2] = true;
            OXMLItem.castTable[0][n2] = true;
            OXMLItem.castTable[n2][0] = true;
            OXMLItem.castTable[n2][1] = true;
            OXMLItem.castTable[1][n2] = true;
        }
        OXMLItem.castTable[0][19] = false;
        OXMLItem.castTable[6][20] = true;
        OXMLItem.castTable[6][21] = true;
        OXMLItem.castTable[20][6] = true;
        OXMLItem.castTable[21][6] = true;
        OXMLItem.castTable[20][21] = true;
        OXMLItem.castTable[21][20] = true;
        OXMLItem.castTable[7][8] = true;
        OXMLItem.castTable[7][9] = true;
        OXMLItem.castTable[7][10] = true;
        OXMLItem.castTable[7][11] = true;
        OXMLItem.castTable[7][13] = true;
        OXMLItem.castTable[7][12] = true;
        OXMLItem.castTable[7][14] = true;
        OXMLItem.castTable[9][7] = true;
        OXMLItem.castTable[9][10] = true;
        OXMLItem.castTable[9][11] = true;
        OXMLItem.castTable[9][13] = true;
        OXMLItem.castTable[9][12] = true;
        OXMLItem.castTable[9][14] = true;
        OXMLItem.castTable[3][4] = true;
        OXMLItem.castTable[3][5] = true;
        OXMLItem.castTable[3][2] = true;
        OXMLItem.castTable[4][3] = true;
        OXMLItem.castTable[4][5] = true;
        OXMLItem.castTable[4][2] = true;
        OXMLItem.castTable[5][3] = true;
        OXMLItem.castTable[5][4] = true;
        OXMLItem.castTable[5][2] = true;
        OXMLItem.castTable[2][3] = true;
        OXMLItem.castTable[2][4] = true;
        OXMLItem.castTable[2][5] = true;
        OXMLItem.castTable[16][15] = true;
        OXMLItem.castTable[15][16] = true;
        opComb = new int[][]{{1, 2, 1, 16, 0, 0, 0}, {2, 2, 2, 17, 0, 0, 0}, {1, 2, 3, 4, 0, 0, 0}, {18, 19, 5, 6, 10, 14, 13}, {0, 0, 0, 9, 15, 0, 0}, {0, 0, 0, 11, 0, 8, 0}, {0, 0, 0, 12, 0, 0, 7}};
        opTable = new int[][]{{0, 1, 2, 3, 0, 0, 17, 0, 0, 23, 29, 27, 25, 30, 31, 0, 0, 0, 0, 0}, {0, 4, 5, 6, 0, 0, 18, 21, 22, 24, 0, 28, 26, 0, 0, 35, 0, 0, 0, 0}, {0, 7, 8, 9, 38, 37, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 36, 36, 19, 19}, {0, 10, 11, 12, 0, 20, 34, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 20}, {0, 32, 33, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 14, 15, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
        compTable = new boolean[][]{{false, true, true, true, false, false}, {true, false, false, true, false, true}, {false, true, false, false, true, true}};
        numberFormat = (DecimalFormat)DecimalFormat.getInstance(Locale.US);
        numberFormat.setGroupingUsed(false);
        numberFormat.setMaximumFractionDigits(100);
        dfUS = new DFUSThread();
    }

    static class DFUSThread
    extends ThreadLocal {
        DFUSThread() {
        }

        protected DecimalFormat initialValue() {
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Locale.US);
            return new DecimalFormat("0.0################E0##", decimalFormatSymbols);
        }
    }
}

