/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLCollator;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNUtil;

class IndexOf
extends OXMLFunction {
    private int numParams;

    IndexOf(int n2) {
        this.numParams = n2;
    }

    @Override
    public String getFunctionName() {
        return "index-of";
    }

    @Override
    public int getNumberArgs() {
        return this.numParams;
    }

    @Override
    public OXMLSequenceType getReturnType() {
        return OXMLSequenceType.getConstantType(4, 22);
    }

    @Override
    public OXMLSequenceType getArgType(int n2) {
        if (n2 == 0) {
            return OXMLSequenceType.ANYATOMIC_ZERO_OR_MORE;
        }
        if (n2 == 1) {
            return OXMLSequenceType.ANYATOMIC_ONE;
        }
        if (n2 == 2) {
            return OXMLSequenceType.TSTRING;
        }
        return null;
    }

    @Override
    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2) throws XQException {
        String string = oXMLFunctionContext.getDefaultCollation();
        OXMLCollator oXMLCollator = oXMLFunctionContext.getCollator(string);
        if (oXMLCollator == null) {
            oXMLCollator = FNUtil.getCollator(string, oXMLFunctionContext.getDBCharSet());
        }
        return this.indexOf(oXMLFunctionContext, oXMLSequence, oXMLSequence2, oXMLCollator);
    }

    private OXMLSequence indexOf(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2, OXMLCollator oXMLCollator) throws XQException {
        OXMLSequence oXMLSequence3 = oXMLFunctionContext.createSequence();
        OXMLItem oXMLItem = FNUtil.getSingleItem(oXMLSequence2);
        int n2 = 1;
        while (oXMLSequence.next()) {
            OXMLItem oXMLItem2 = oXMLSequence.getItem();
            try {
                if (oXMLItem2.compareValue(oXMLItem, oXMLCollator) == 0) {
                    OXMLItem oXMLItem3 = oXMLFunctionContext.createItem();
                    oXMLItem3.setInt(OXMLSequenceType.TINTEGER, n2);
                    oXMLSequence3.appendItem(oXMLItem3);
                }
            }
            catch (XQException xQException) {
                // empty catch block
            }
            ++n2;
        }
        return oXMLSequence3;
    }

    @Override
    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence[] oXMLSequenceArray) throws XQException {
        if (oXMLSequenceArray.length != this.numParams) {
            throw new XQException("FORT0001");
        }
        if (oXMLSequenceArray.length == 3) {
            String string = FNUtil.getSingleItem(oXMLSequenceArray[2]).getString();
            OXMLCollator oXMLCollator = oXMLFunctionContext.getCollator(string);
            if (oXMLCollator == null) {
                oXMLCollator = FNUtil.getCollator(string, oXMLFunctionContext.getDBCharSet());
            }
            return this.indexOf(oXMLFunctionContext, oXMLSequenceArray[0], oXMLSequenceArray[1], oXMLCollator);
        }
        return this.invoke(oXMLFunctionContext, oXMLSequenceArray[0], oXMLSequenceArray[1]);
    }
}

