/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import oracle.xml.util.UnicodeUtil;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNUtil;

class NormalizeUnicode
extends OXMLFunction {
    private int numParams;

    NormalizeUnicode(int n2) {
        this.numParams = n2;
    }

    @Override
    public String getFunctionName() {
        return "normalize-unicode";
    }

    @Override
    public int getNumberArgs() {
        return this.numParams;
    }

    @Override
    public OXMLSequenceType getReturnType() {
        return OXMLSequenceType.TSTRING;
    }

    @Override
    public OXMLSequenceType getArgType(int n2) {
        if (n2 == 0) {
            return OXMLSequenceType.TSTRING_ZERO_OR_ONE;
        }
        if (n2 == 1) {
            return OXMLSequenceType.TSTRING;
        }
        return null;
    }

    @Override
    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2) throws XQException {
        OXMLItem oXMLItem = FNUtil.getEmptyOrSingleItem(oXMLSequence);
        if (oXMLItem == null) {
            OXMLSequence oXMLSequence3 = oXMLFunctionContext.createSequence();
            OXMLItem oXMLItem2 = oXMLFunctionContext.createItem();
            oXMLItem2.setString(OXMLSequenceType.TSTRING, "");
            oXMLSequence3.appendItem(oXMLItem2);
            return oXMLSequence3;
        }
        OXMLItem oXMLItem3 = FNUtil.getSingleItem(oXMLSequence2);
        String string = oXMLItem3.getString();
        if (string.length() == 0) {
            OXMLSequence oXMLSequence4 = oXMLFunctionContext.createSequence();
            oXMLSequence4.appendItem(oXMLItem);
            return oXMLSequence4;
        }
        int n2 = FNUtil.getUNFMode(string);
        return this.normalize(oXMLFunctionContext, oXMLItem, n2);
    }

    @Override
    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence) throws XQException {
        OXMLItem oXMLItem = FNUtil.getEmptyOrSingleItem(oXMLSequence);
        return this.normalize(oXMLFunctionContext, oXMLItem, FNUtil.getUNFMode("NFC"));
    }

    private OXMLSequence normalize(OXMLFunctionContext oXMLFunctionContext, OXMLItem oXMLItem, int n2) throws XQException {
        String string = null;
        if (oXMLItem == null) {
            string = "";
        } else {
            if (n2 == 65536) {
                throw new XQException("FOCH0003");
            }
            string = UnicodeUtil.normalizeUnicodeByJdkOrGdk(oXMLItem.getString(), n2);
        }
        OXMLSequence oXMLSequence = oXMLFunctionContext.createSequence();
        OXMLItem oXMLItem2 = oXMLFunctionContext.createItem();
        oXMLItem2.setString(OXMLSequenceType.TSTRING, string);
        oXMLSequence.appendItem(oXMLItem2);
        return oXMLSequence;
    }

    @Override
    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence[] oXMLSequenceArray) throws XQException {
        if (oXMLSequenceArray.length != this.numParams) {
            throw new XQException("FORT0001");
        }
        OXMLSequence oXMLSequence = null;
        switch (oXMLSequenceArray.length) {
            case 1: {
                oXMLSequence = this.invoke(oXMLFunctionContext, oXMLSequenceArray[0]);
                break;
            }
            case 2: {
                oXMLSequence = this.invoke(oXMLFunctionContext, oXMLSequenceArray[0], oXMLSequenceArray[1]);
            }
        }
        return oXMLSequence;
    }
}

