/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xslt;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Vector;
import oracle.xml.common.regex.xerces.ParseException;
import oracle.xml.common.regex.xerces.ReMatch;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.util.RegExprEngine;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xslt.XSLConstants;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLMatchingSubstring;
import oracle.xml.xslt.XSLNode;
import oracle.xml.xslt.XSLNonMatchingSubstring;
import oracle.xml.xslt.XSLStylesheet;
import oracle.xml.xslt.XSLTContext;

class XSLAnalyzeString
extends XSLNode
implements XSLConstants {
    private int imatchildnum = 0;
    private int inonmatchildnum = 0;
    private XSLMatchingSubstring omatchildnode = null;
    private XSLNonMatchingSubstring ononmatchildnode = null;
    private XSLExprBase select = null;
    private XSLNode.AttrValueTmpl regex = null;
    private XSLNode.AttrValueTmpl flags = null;

    XSLAnalyzeString(XSLStylesheet xSLStylesheet) throws XSLException {
        super(xSLStylesheet);
        this.elementType = 7;
    }

    void setMatchildNode(XSLMatchingSubstring xSLMatchingSubstring) {
        this.omatchildnode = xSLMatchingSubstring;
    }

    void setNonMatchildNode(XSLNonMatchingSubstring xSLNonMatchingSubstring) {
        this.ononmatchildnode = xSLNonMatchingSubstring;
    }

    int getMatchildNum() {
        return this.imatchildnum;
    }

    int getNonMatchildNum() {
        return this.inonmatchildnum;
    }

    void incMatchildNum() {
        ++this.imatchildnum;
    }

    void incNonMatchildNum() {
        ++this.inonmatchildnum;
    }

    @Override
    public void appendChild(XSLNode xSLNode) throws XSLException {
        super.appendChild(xSLNode);
        if (xSLNode instanceof XSLMatchingSubstring) {
            this.omatchildnode = (XSLMatchingSubstring)xSLNode;
        }
        if (xSLNode instanceof XSLNonMatchingSubstring) {
            this.ononmatchildnode = (XSLNonMatchingSubstring)xSLNode;
        }
    }

    @Override
    public void startContent() throws XSLException {
        if (this.select == null) {
            this.xss.err.error2(22220, 1, "select", this.getQualifiedName());
        }
        if (this.regex == null) {
            this.xss.err.error2(22220, 1, "regex", this.getQualifiedName());
        }
    }

    @Override
    public void setAttribute(String string, String string2, String string3, String string4) throws XSLException, XQException {
        if (string == "" && string3 == "select") {
            this.select = XSLExprBase.createExpression(string4, (NSResolver)this, this.xss);
        }
        if (string == "" && string3 == "regex") {
            this.regex = new XSLNode.AttrValueTmpl(this, string4, this);
        }
        if (string == "" && string3 == "flags") {
            this.flags = new XSLNode.AttrValueTmpl(this, string4, this);
        }
        super.setAttribute(string, string2, string3, string4);
    }

    @Override
    public void finalizeXSLNode() throws XSLException, XQException {
        super.finalizeXSLNode();
    }

    @Override
    public void processAction(XSLTContext xSLTContext) throws XSLException, XQException {
        boolean bl;
        XMLError xMLError = xSLTContext.getError();
        OXMLItem oXMLItem = xSLTContext.getContextItem();
        XMLNode xMLNode = xSLTContext.getContextNode();
        int n2 = xSLTContext.getContextSize();
        int n3 = xSLTContext.getContextPosition();
        oXMLItem.setNode(xMLNode);
        this.setContextBaseURL(xSLTContext);
        this.setDefaultCollation(xSLTContext);
        if (xSLTContext.getOSBDebugMode()) {
            this.fireOSBDebuggerTraceEventBeforeExe(xSLTContext, this, "xsl:analyze-string");
        }
        this.select.evaluate(xSLTContext);
        OXMLSequence oXMLSequence = xSLTContext.popExprValue();
        String string = XPathSequence.getStringValue(oXMLSequence);
        if (string == null || string.length() == 0) {
            return;
        }
        String string2 = this.regex.getValue(xSLTContext);
        int n4 = string2.indexOf("{{");
        if (n4 != -1) {
            string2 = string2.replaceAll("\\{{2}", "{");
            string2 = string2.replaceAll("\\}{2}", "}");
        }
        String string3 = "";
        if (this.flags != null) {
            string3 = this.flags.getValue(xSLTContext);
        }
        RegExprEngine regExprEngine = null;
        try {
            regExprEngine = new RegExprEngine(string2, string3);
        }
        catch (ParseException parseException) {
            xMLError.error1(1202, 1, string2);
            throw new XSLException(xMLError.getMessage1(22202, string2));
        }
        ReMatch reMatch = regExprEngine.createMatchObject();
        if (regExprEngine.match("")) {
            xMLError.error0(1200, 1);
            throw new XSLException(xMLError.getMessage0(22200));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        BitSet bitSet = new BitSet();
        int n5 = 0;
        int n6 = string.length();
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while (bl = regExprEngine.match(string, n7, reMatch)) {
            n5 = reMatch.getBeginning(0);
            n8 = n7;
            n7 = reMatch.getEnd(0);
            int n10 = reMatch.getNumberOfGroups();
            Vector<String> vector = new Vector<String>(n10);
            for (int i2 = 0; i2 < n10; ++i2) {
                String string4 = reMatch.getCapturedText(i2);
                if (string4 == null) {
                    string4 = "";
                }
                vector.add(string4);
            }
            xSLTContext.addRegexGroupData(vector);
            if (n5 > n8) {
                arrayList.add(string.substring(n8, n5));
                bitSet.set(n9, false);
                ++n9;
            }
            arrayList.add(string.substring(n5, n7));
            bitSet.set(n9, true);
            ++n9;
        }
        if (n7 < n6) {
            arrayList.add(string.substring(n7, n6));
            bitSet.set(n9, false);
            ++n9;
        }
        xSLTContext.setContextSize(n9);
        for (n9 = 0; n9 < arrayList.size(); ++n9) {
            if (bitSet.get(n9) && this.omatchildnode != null) {
                xSLTContext.setContextPosition(n9 + 1);
                xSLTContext.saveCapturedSubstring(true);
                this.omatchildnode.reportMatchingNodes(xSLTContext, (String)arrayList.get(n9));
                xSLTContext.restoreCapturedSubstring();
                xSLTContext.pollRegexGroupData();
                continue;
            }
            if (bitSet.get(n9) || this.ononmatchildnode == null) continue;
            xSLTContext.setContextPosition(n9 + 1);
            xSLTContext.saveCapturedSubstring(false);
            this.ononmatchildnode.reportNonMatchingNodes(xSLTContext, (String)arrayList.get(n9));
            xSLTContext.restoreCapturedSubstring();
        }
        this.processChildren(xSLTContext);
        xSLTContext.setContextPosition(n3);
        xSLTContext.setContextSize(n2);
        xSLTContext.setContextNode(xMLNode);
        xSLTContext.setContextItem(oXMLItem);
        if (xSLTContext.getOSBDebugMode()) {
            this.fireOSBDebuggerTraceEventAfterExe(xSLTContext, this, "xsl:analyze-string");
        }
    }
}

